/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_altar;

import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.forge_stuff.CombinedInvWrapper;
import team.lodestar.lodestone.forge_stuff.IItemHandler;
import team.lodestar.lodestone.forge_stuff.IItemHandlerModifiable;
import team.lodestar.lodestone.forge_stuff.ItemStackHandler;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class AltarCraftingHelper {
    public static Extraction simulateExtraction(IItemHandler inventory, List<IngredientWithCount> ingredients) {
        IItemHandlerModifiable frozen = AltarCraftingHelper.frozenCopy(inventory);
        int numberOfItems = 0;
        int numberOfIngredients = 0;
        for (IngredientWithCount ingredient : ingredients) {
            class_2371<class_1799> extracted = AltarCraftingHelper.extractIngredient((IItemHandler)frozen, (Predicate<class_1799>)ingredient.ingredient, ingredient.count, false);
            int numExtracted = extracted.stream().mapToInt(class_1799::method_7947).sum();
            if (numExtracted != ingredient.count) {
                return null;
            }
            ++numberOfIngredients;
            numberOfItems += numExtracted;
        }
        return new Extraction(numberOfIngredients, numberOfItems);
    }

    public static IngredientWithCount getFirstMissingIngredient(IItemHandler inventory, List<IngredientWithCount> ingredients) {
        IItemHandlerModifiable frozen = AltarCraftingHelper.frozenCopy(inventory);
        for (IngredientWithCount ingredient : ingredients) {
            class_2371<class_1799> extracted = AltarCraftingHelper.extractIngredient((IItemHandler)frozen, (Predicate<class_1799>)ingredient.ingredient, ingredient.count, false);
            int numExtracted = extracted.stream().mapToInt(class_1799::method_7947).sum();
            if (numExtracted == ingredient.count) continue;
            return new IngredientWithCount(ingredient.ingredient, ingredient.count - numExtracted);
        }
        return null;
    }

    private static List<IngredientWithCount> convertSpiritsToIngredients(List<SpiritWithCount> ingredients) {
        return ingredients.stream().map(ingredient -> new IngredientWithCount(class_1856.method_8091((class_1935[])new class_1935[]{ingredient.getItem()}), ingredient.count)).collect(Collectors.toList());
    }

    public static class_2371<class_1799> extractIngredient(IItemHandler inventory, Predicate<class_1799> ingredient, int count, boolean simulate) {
        int leftToExtract = count;
        class_2371 extracted = class_2371.method_10211();
        int[] toExtract = new int[inventory.getSlots()];
        for (int i = 0; i < inventory.getSlots(); ++i) {
            class_1799 stack = inventory.extractItem(i, leftToExtract, true);
            if (!ingredient.test(stack)) continue;
            extracted.add((Object)stack);
            toExtract[i] = stack.method_7947();
            if ((leftToExtract -= stack.method_7947()) > 0) continue;
            if (!simulate) {
                extracted.clear();
                for (int slot = 0; slot < toExtract.length; ++slot) {
                    extracted.add((Object)inventory.extractItem(slot, toExtract[slot], false));
                }
            }
            return extracted;
        }
        return extracted;
    }

    public static IngredientWithCount getNextIngredientToTake(SpiritInfusionRecipe recipe, IItemHandlerModifiable consumedItems) {
        IItemHandlerModifiable frozen = AltarCraftingHelper.frozenCopy((IItemHandler)consumedItems);
        return AltarCraftingHelper.getFirstMissingIngredient((IItemHandler)frozen, recipe.extraItems);
    }

    private static IItemHandlerModifiable frozenCopy(IItemHandler inventory) {
        ItemStackHandler handler = new ItemStackHandler(inventory.getSlots());
        for (int i = 0; i < inventory.getSlots(); ++i) {
            handler.setStackInSlot(i, inventory.extractItem(i, 64, true));
        }
        return handler;
    }

    public static Ranking rankRecipe(SpiritInfusionRecipe recipe, class_1799 inputItem, IItemHandlerModifiable spiritContainer, IItemHandlerModifiable pedestalItems, IItemHandlerModifiable consumedItems) {
        if (!recipe.doesInputMatch(inputItem)) {
            return null;
        }
        int inputCount = recipe.input.count;
        Extraction spiritRanking = AltarCraftingHelper.simulateExtraction((IItemHandler)spiritContainer, AltarCraftingHelper.convertSpiritsToIngredients(recipe.spirits));
        if (spiritRanking == null) {
            return null;
        }
        Extraction itemRanking = AltarCraftingHelper.simulateExtraction((IItemHandler)new CombinedInvWrapper(new IItemHandlerModifiable[]{pedestalItems, consumedItems}), recipe.extraItems);
        if (itemRanking == null) {
            return null;
        }
        return new Ranking(inputCount, spiritRanking.numberOfStacks, spiritRanking.numberOfItems, itemRanking.numberOfStacks, itemRanking.numberOfItems);
    }

    public static IItemHandlerModifiable createPedestalInventoryCapture(List<IMalumSpecialItemAccessPoint> pedestals) {
        return new CombinedInvWrapper((IItemHandlerModifiable[])pedestals.stream().map(IMalumSpecialItemAccessPoint::getSuppliedInventory).toArray(IItemHandlerModifiable[]::new));
    }

    public static List<IMalumSpecialItemAccessPoint> capturePedestals(class_1937 level, class_2338 pos) {
        return AltarCraftingHelper.capturePedestals(level, pos, 4, 3, 4);
    }

    public static List<IMalumSpecialItemAccessPoint> capturePedestals(class_1937 level, class_2338 pos, int xRange, int yRange, int zRange) {
        return BlockHelper.getBlockEntities(IMalumSpecialItemAccessPoint.class, (class_1937)level, (class_2338)pos, (int)xRange, (int)yRange, (int)zRange).stream().sorted(Comparator.comparingDouble(it -> -pos.method_10262((class_2382)it.getAccessPointBlockPos()))).collect(Collectors.toList());
    }

    public record Extraction(int numberOfStacks, int numberOfItems) {
    }

    public record Ranking(int inputItemCount, int spiritStackCount, int spiritItemCount, int ingredientStackCount, int ingredientItemCount) implements Comparable<Ranking>
    {
        @Override
        public int compareTo(@NotNull Ranking o) {
            int comparison = this.inputItemCount - o.inputItemCount;
            if (comparison != 0) {
                return comparison;
            }
            comparison = this.spiritStackCount - o.spiritStackCount;
            if (comparison != 0) {
                return comparison;
            }
            comparison = this.spiritItemCount - o.spiritItemCount;
            if (comparison != 0) {
                return comparison;
            }
            comparison = this.ingredientStackCount - o.ingredientStackCount;
            if (comparison != 0) {
                return comparison;
            }
            return this.ingredientItemCount - o.ingredientItemCount;
        }
    }
}

