/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.ritual_plinth;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.ritual_plinth.RitualSoundInstance;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.block.storage.jar.SpiritJarBlockEntity;
import com.sammy.malum.common.item.spirit.RitualShardItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.ritual.MalumRitualRecipeData;
import com.sammy.malum.core.systems.ritual.MalumRitualTier;
import com.sammy.malum.core.systems.ritual.MalumRitualType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.RitualRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.RitualPlinthParticleEffects;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import com.sammy.malum.visual_effects.networked.ritual.RitualPlinthAbsorbItemParticleEffect;
import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.forge_stuff.CombinedInvWrapper;
import team.lodestar.lodestone.forge_stuff.IItemHandler;
import team.lodestar.lodestone.forge_stuff.IItemHandlerModifiable;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class RitualPlinthBlockEntity
extends LodestoneBlockEntity
implements CustomRenderBoundingBoxBlockEntity {
    private static final class_243 PLINTH_ITEM_OFFSET = new class_243(0.5, 1.375, 0.5);
    public MalumRitualType ritualType;
    public MalumRitualTier ritualTier;
    public int spiritAmount;
    public int progress;
    public float activeDuration;
    public boolean setupComplete;
    public Map<Object, Integer> absorptionProgress = new HashMap<Object, Integer>();
    public MalumRitualRecipeData ritualRecipe;
    public LodestoneBlockEntityInventory inventory;
    public LodestoneBlockEntityInventory extrasInventory;
    public LazyOptional<IItemHandler> internalInventory = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.extrasInventory}));
    public LazyOptional<IItemHandler> exposedInventory = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory}));

    public RitualPlinthBlockEntity(class_2591<? extends RitualPlinthBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public RitualPlinthBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntityRegistry.RITUAL_PLINTH.get(), pos, state);
        this.inventory = new MalumBlockEntityInventory(1, 64, t -> this.ritualType != null && this.ritualType.isItemStackValid(this, (class_1799)t) || this.ritualType == null && !(t.method_7909() instanceof SpiritShardItem)){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                RitualPlinthBlockEntity.this.needsSync = true;
                BlockHelper.updateAndNotifyState((class_1937)RitualPlinthBlockEntity.this.field_11863, (class_2338)RitualPlinthBlockEntity.this.field_11867);
            }
        };
        this.extrasInventory = new MalumBlockEntityInventory(8, 64){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BlockHelper.updateAndNotifyState((class_1937)RitualPlinthBlockEntity.this.field_11863, (class_2338)RitualPlinthBlockEntity.this.field_11867);
            }
        };
    }

    protected void method_11007(class_2487 compound) {
        if (this.spiritAmount != 0) {
            compound.method_10569("spiritAmount", this.spiritAmount);
        }
        if (this.progress != 0) {
            compound.method_10569("progress", this.progress);
        }
        if (this.setupComplete) {
            compound.method_10556("setupComplete", true);
        }
        if (this.activeDuration != 0.0f) {
            compound.method_10548("activeDuration", this.activeDuration);
        }
        if (this.ritualType != null) {
            compound.method_10582("ritualType", this.ritualType.identifier.toString());
        }
        this.inventory.save(compound);
        this.extrasInventory.save(compound, "extrasInventory");
    }

    public void method_11014(class_2487 compound) {
        this.spiritAmount = compound.method_10550("spiritAmount");
        this.progress = compound.method_10550("progress");
        this.setupComplete = compound.method_10577("setupComplete");
        this.activeDuration = compound.method_10583("activeDuration");
        this.ritualType = RitualRegistry.get(new class_2960(compound.method_10558("ritualType")));
        this.ritualTier = MalumRitualTier.figureOutTier(this.spiritAmount);
        this.inventory.load(compound);
        this.extrasInventory.load(compound, "extrasInventory");
        super.method_11014(compound);
    }

    public void onBreak(@Nullable class_1657 player) {
        this.inventory.dumpItems(this.field_11863, this.field_11867);
        this.extrasInventory.dumpItems(this.field_11863, this.field_11867);
        if (this.ritualType != null && this.ritualTier != null) {
            class_1799 shard = new class_1799((class_1935)ItemRegistry.RITUAL_SHARD.get());
            shard.method_7980(this.ritualType.createShardNBT(this.ritualTier));
            this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), shard));
        }
    }

    public class_1269 onUse(class_1657 player, class_1268 hand) {
        class_1799 stack;
        if (this.ritualType != null) {
            class_1269 interactionResult = this.ritualType.onUsePlinth(this, player, hand);
            if (!interactionResult.equals((Object)class_1269.field_5811)) {
                return interactionResult;
            }
        } else if (this.inventory.getStackInSlot(0).method_7960() && this.extrasInventory.isEmpty() && (stack = player.method_5998(hand)).method_7909() instanceof RitualShardItem) {
            if (!this.field_11863.field_9236) {
                this.ritualType = RitualShardItem.getRitualType(stack);
                this.ritualTier = RitualShardItem.getRitualTier(stack);
                this.spiritAmount = this.ritualTier.spiritThreshold;
                this.setupComplete = true;
                class_1937 class_19372 = this.field_11863;
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    ParticleEffectTypeRegistry.RITUAL_PLINTH_BEGINS_CHARGING.createPositionedEffect(serverLevel, new PositionEffectData(this.field_11867), new ColorEffectData(this.ritualType.spirit));
                }
                this.field_11863.method_8396(null, this.method_11016(), (class_3414)SoundRegistry.RITUAL_BEGINS.get(), class_3419.field_15245, 1.0f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
                this.field_11863.method_8396(null, this.method_11016(), (class_3414)SoundRegistry.RITUAL_COMPLETED.get(), class_3419.field_15245, 1.0f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
                player.method_6122(hand, class_1799.field_8037);
                BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
            }
            return class_1269.field_5812;
        }
        this.inventory.interact(player.method_37908(), player, hand);
        return class_1269.field_5812;
    }

    public void init() {
        class_1799 stack = this.inventory.getStackInSlot(0);
        boolean wasLackingRecipe = this.ritualRecipe == null;
        this.ritualRecipe = RitualRegistry.RITUALS.stream().map(MalumRitualType::getRecipeData).filter(recipeData -> recipeData != null && recipeData.input.matches(stack)).findAny().orElse(null);
        if (this.ritualType == null && wasLackingRecipe && this.ritualRecipe != null) {
            this.field_11863.method_8396(null, this.method_11016(), (class_3414)SoundRegistry.RITUAL_BEGINS.get(), class_3419.field_15245, 1.0f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
        }
        if (this.field_11863.field_9236) {
            RegistryObject<class_3414> soundEvent = null;
            Predicate<RitualPlinthBlockEntity> stopCondition = null;
            if (this.setupComplete) {
                soundEvent = SoundRegistry.COMPLETED_RITUAL_AMBIENCE;
                stopCondition = p -> false;
            } else if (this.ritualType != null) {
                soundEvent = SoundRegistry.RITUAL_EVOLUTION_AMBIENCE;
                stopCondition = p -> p.setupComplete || p.ritualType == null;
            } else if (wasLackingRecipe && this.ritualRecipe != null) {
                soundEvent = SoundRegistry.RITUAL_BEGINNING_AMBIENCE;
                stopCondition = p -> p.ritualRecipe == null || p.ritualType != null;
            }
            if (soundEvent != null) {
                RitualSoundInstance.playSound(this, soundEvent, stopCondition);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.ritualType != null) {
            this.activeDuration += 1.0f;
            if (this.progress > 0) {
                --this.progress;
                if (!this.field_11863.field_9236) {
                    this.eatSpirits();
                    if (this.progress == 0) {
                        this.completeCharging();
                    }
                }
            } else if (!this.field_11863.field_9236) {
                this.ritualType.triggerRitualEffect(this);
            }
        } else if (this.ritualRecipe != null) {
            ++this.progress;
            if (!this.field_11863.field_9236 && this.progress > 60) {
                boolean success = this.consume();
                if (success) {
                    this.beginCharging();
                } else {
                    this.progress = 0;
                }
            }
        } else {
            this.progress = 0;
        }
        if (this.field_11863.field_9236) {
            class_1799 stack = this.inventory.getStackInSlot(0);
            if (!stack.method_7960()) {
                boolean isItemValid;
                boolean bl = this.ritualType != null ? this.ritualType.isItemStackValid(this, stack) : (isItemValid = this.ritualRecipe != null && this.ritualRecipe.input.matches(stack));
                if (isItemValid) {
                    RitualPlinthParticleEffects.holdingPrimeItemPlinthParticles(this);
                }
            }
            if (this.ritualType != null) {
                RitualPlinthParticleEffects.riteActivePlinthParticles(this);
            }
        }
    }

    public boolean consume() {
        if (this.ritualRecipe.extraItems.isEmpty()) {
            return true;
        }
        this.extrasInventory.updateData();
        int extras = this.extrasInventory.nonEmptyItemAmount;
        if (extras < this.ritualRecipe.extraItems.size()) {
            Collection altarProviders = BlockHelper.getBlockEntities(IMalumSpecialItemAccessPoint.class, (class_1937)this.field_11863, (class_2338)this.field_11867, (int)4);
            for (IMalumSpecialItemAccessPoint provider : altarProviders) {
                LodestoneBlockEntityInventory inventoryForAltar = provider.getSuppliedInventory();
                class_1799 providedStack = inventoryForAltar.getStackInSlot(0);
                IngredientWithCount requestedItem = this.ritualRecipe.extraItems.get(extras);
                if (!requestedItem.matches(providedStack)) continue;
                this.field_11863.method_8396(null, provider.getAccessPointBlockPos(), (class_3414)SoundRegistry.RITUAL_ABSORBS_ITEM.get(), class_3419.field_15245, 1.0f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
                class_1937 class_19372 = this.field_11863;
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    ParticleEffectTypeRegistry.RITUAL_PLINTH_EATS_ITEM.createPositionedEffect(serverLevel, new PositionEffectData(this.field_11867), new ColorEffectData(this.ritualRecipe.ritualType.spirit), RitualPlinthAbsorbItemParticleEffect.createData(provider.getItemPos(), providedStack));
                }
                this.extrasInventory.insertItem(providedStack.method_7971(requestedItem.count));
                inventoryForAltar.updateData();
                BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)provider.getAccessPointBlockPos());
                break;
            }
            return false;
        }
        return true;
    }

    public void beginCharging() {
        this.ritualType = this.ritualRecipe.ritualType;
        this.inventory.getStackInSlot(0).method_7934(this.ritualRecipe.input.count);
        this.inventory.updateData();
        this.extrasInventory.clear();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ParticleEffectTypeRegistry.RITUAL_PLINTH_BEGINS_CHARGING.createPositionedEffect(serverLevel, new PositionEffectData(this.field_11867), new ColorEffectData(this.ritualType.spirit));
        }
        this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.RITUAL_FORMS.get(), class_3419.field_15245, 1.0f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
        BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    public void eatSpirits() {
        class_1792 serverLevel;
        class_1792 class_17922;
        this.extrasInventory.updateData();
        Collection altarProviders = BlockHelper.getBlockEntities(IMalumSpecialItemAccessPoint.class, (class_1937)this.field_11863, (class_2338)this.field_11867, (int)4);
        Collection jars = BlockHelper.getBlockEntities(SpiritJarBlockEntity.class, (class_1937)this.field_11863, (class_2338)this.field_11867, (int)4);
        List<class_1542> itemEntities = this.field_11863.method_18467(class_1542.class, new class_238(this.field_11867).method_1014(4.0)).stream().filter(i -> i.method_6983().method_7909() instanceof SpiritShardItem).toList();
        int increase = 0;
        MalumSpiritType spirit = this.ritualType.spirit;
        for (IMalumSpecialItemAccessPoint altarProvider : altarProviders) {
            LodestoneBlockEntityInventory providerInventory = altarProvider.getSuppliedInventory();
            class_1799 stack = providerInventory.getStackInSlot(0);
            class_17922 = stack.method_7909();
            if (!(class_17922 instanceof SpiritShardItem)) continue;
            SpiritShardItem spiritShardItem = (SpiritShardItem)class_17922;
            if (!spiritShardItem.type.equals(spirit)) continue;
            this.absorptionProgress.compute(altarProvider, (p, i) -> i == null ? 1 : i + 1);
            if (this.absorptionProgress.get(altarProvider) < 5) continue;
            class_2338 accessPointBlockPos = altarProvider.getAccessPointBlockPos();
            int absorbedAmount = Math.min(stack.method_7947(), this.ritualTier == null ? 4 : this.ritualTier.spiritThreshold / 16);
            increase += absorbedAmount;
            stack.method_7934(absorbedAmount);
            providerInventory.onContentsChanged(0);
            this.field_11863.method_8396(null, accessPointBlockPos, (class_3414)SoundRegistry.RITUAL_ABSORBS_SPIRIT.get(), class_3419.field_15245, 1.0f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel2 = (class_3218)class_19372;
                ParticleEffectTypeRegistry.RITUAL_PLINTH_EATS_SPIRIT.createPositionedEffect(serverLevel2, new PositionEffectData(this.field_11867), new ColorEffectData(spirit), RitualPlinthAbsorbItemParticleEffect.createData(altarProvider.getItemPos(), stack));
            }
            this.absorptionProgress.remove(altarProvider);
            BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)accessPointBlockPos);
        }
        for (SpiritJarBlockEntity jar : jars) {
            if (!spirit.equals(jar.type) || jar.count <= 0) continue;
            this.absorptionProgress.compute((Object)jar, (p, i) -> i == null ? 1 : i + 1);
            if (this.absorptionProgress.get((Object)jar) < 5) continue;
            class_2338 jarPosition = jar.method_11016();
            int absorbedAmount = Math.min(jar.count, this.ritualTier == null ? 4 : this.ritualTier.spiritThreshold / 16);
            increase += absorbedAmount;
            jar.count -= absorbedAmount;
            if (jar.count == 0) {
                jar.type = null;
            }
            this.field_11863.method_8396(null, jarPosition, (class_3414)SoundRegistry.RITUAL_ABSORBS_SPIRIT.get(), class_3419.field_15245, 1.0f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
            class_17922 = this.field_11863;
            if (class_17922 instanceof class_3218) {
                serverLevel = (class_3218)class_17922;
                ParticleEffectTypeRegistry.RITUAL_PLINTH_EATS_SPIRIT.createPositionedEffect((class_3218)serverLevel, new PositionEffectData(this.field_11867), new ColorEffectData(spirit), RitualPlinthAbsorbItemParticleEffect.createData(jar.getItemPos(), spirit.spiritShard.get().method_7854()));
            }
            this.absorptionProgress.remove((Object)jar);
            BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)jarPosition);
        }
        for (class_1542 itemEntity : itemEntities) {
            class_1799 item = itemEntity.method_6983();
            serverLevel = item.method_7909();
            if (!(serverLevel instanceof SpiritShardItem)) continue;
            SpiritShardItem spiritShardItem = (SpiritShardItem)serverLevel;
            if (!spiritShardItem.type.equals(spirit)) continue;
            this.absorptionProgress.compute(itemEntity, (p, i) -> i == null ? 1 : i + 1);
            if (this.absorptionProgress.get(itemEntity) < 5) continue;
            this.field_11863.method_8396(null, itemEntity.method_24515(), (class_3414)SoundRegistry.RITUAL_ABSORBS_SPIRIT.get(), class_3419.field_15245, 1.0f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
            class_17922 = this.field_11863;
            if (class_17922 instanceof class_3218) {
                serverLevel = (class_3218)class_17922;
                ParticleEffectTypeRegistry.RITUAL_PLINTH_EATS_SPIRIT.createPositionedEffect((class_3218)serverLevel, new PositionEffectData(this.field_11867), new ColorEffectData(spirit), RitualPlinthAbsorbItemParticleEffect.createData(itemEntity.method_19538().method_1031(0.0, (double)(itemEntity.method_17682() / 2.0f), 0.0), spirit.spiritShard.get().method_7854()));
            }
            increase += item.method_7947();
            itemEntity.method_31472();
            this.absorptionProgress.remove(itemEntity);
        }
        if (increase != 0) {
            this.spiritAmount += increase;
            this.progress = 60;
            MalumRitualTier oldTier = this.ritualTier;
            MalumRitualTier newTier = MalumRitualTier.figureOutTier(this.spiritAmount);
            if (newTier != null && !newTier.equals(oldTier)) {
                this.ritualTier = newTier;
                this.field_11863.method_8396(null, this.field_11867, (class_3414)SoundRegistry.RITUAL_EVOLVES.get(), class_3419.field_15245, 1.0f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
                class_1937 class_19373 = this.field_11863;
                if (class_19373 instanceof class_3218) {
                    class_3218 serverLevel3 = (class_3218)class_19373;
                    ParticleEffectTypeRegistry.RITUAL_PLINTH_CHANGES_TIER.createPositionedEffect(serverLevel3, new PositionEffectData(this.field_11867), new ColorEffectData(spirit));
                }
            }
            BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.method_11016());
        }
    }

    public void completeCharging() {
        this.ritualTier = MalumRitualTier.figureOutTier(this);
        boolean bl = this.setupComplete = this.ritualTier != null;
        if (!this.setupComplete) {
            MalumSpiritType spirit = this.ritualType.spirit;
            this.ritualType = null;
            this.spiritAmount = 0;
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                ParticleEffectTypeRegistry.RITUAL_PLINTH_FAILURE.createPositionedEffect(serverLevel, new PositionEffectData(this.field_11867), new ColorEffectData(spirit));
            }
        }
        this.field_11863.method_8396(null, this.method_11016(), (class_3414)SoundRegistry.RITUAL_COMPLETED.get(), class_3419.field_15245, 1.0f, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f);
        BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    public class_243 getItemPos() {
        class_2338 blockPos = this.method_11016();
        class_243 offset = this.getCentralItemOffset();
        return new class_243((double)blockPos.method_10263() + offset.field_1352, (double)blockPos.method_10264() + offset.field_1351, (double)blockPos.method_10260() + offset.field_1350);
    }

    public class_243 getCentralItemOffset() {
        return PLINTH_ITEM_OFFSET;
    }

    public class_243 getRitualIconPos() {
        class_2338 blockPos = this.method_11016();
        class_243 offset = this.getRitualIconOffset(0.0f);
        return new class_243((double)blockPos.method_10263() + offset.field_1352, (double)blockPos.method_10264() + offset.field_1351, (double)blockPos.method_10260() + offset.field_1350);
    }

    public class_243 getRitualIconOffset(float partialTicks) {
        return new class_243(0.5, (double)(1.5f + Easing.CUBIC_OUT.ease(Math.min(this.activeDuration + partialTicks, 30.0f) / 30.0f, 0.0f, 2.0f, 1.0f)), 0.5);
    }

    public class_243 getParticlePositionPosition(class_2350 direction) {
        class_2338 blockPos = this.method_11016();
        float x = (float)blockPos.method_10263() + 0.5f + (float)direction.method_10148() * 0.51f;
        float y = (float)blockPos.method_10264() + 0.875f;
        float z = (float)blockPos.method_10260() + 0.5f + (float)direction.method_10165() * 0.51f;
        return new class_243((double)x, (double)y, (double)z);
    }

    public class_238 getRenderBoundingBox() {
        class_2338 pos = this.field_11867;
        return new class_238((double)(pos.method_10263() - 1), (double)pos.method_10264(), (double)(pos.method_10260() - 1), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 6), (double)(pos.method_10260() + 1));
    }
}

