/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.repair_pylon;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.repair_pylon.RepairPylonComponentBlock;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.block.BlockRegistry;
import com.sammy.malum.visual_effects.RepairPylonParticleEffects;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import com.sammy.malum.visual_effects.networked.pylon.PylonPrepareRepairParticleEffect;
import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.forge_stuff.CombinedInvWrapper;
import team.lodestar.lodestone.forge_stuff.IItemHandler;
import team.lodestar.lodestone.forge_stuff.IItemHandlerModifiable;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.multiblock.MultiBlockCoreEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockStructure;

public class RepairPylonCoreBlockEntity
extends MultiBlockCoreEntity
implements CustomRenderBoundingBoxBlockEntity {
    private static final class_243 PYLON_ITEM_OFFSET = new class_243(0.5, 2.5, 0.5);
    private static final int HORIZONTAL_RANGE = 6;
    private static final int VERTICAL_RANGE = 4;
    public static final Supplier<MultiBlockStructure> STRUCTURE = () -> MultiBlockStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((class_2248)BlockRegistry.REPAIR_PYLON_COMPONENT.get()).method_9564()), new MultiBlockStructure.StructurePiece(0, 2, 0, (class_2680)((class_2248)BlockRegistry.REPAIR_PYLON_COMPONENT.get()).method_9564().method_11657((class_2769)RepairPylonComponentBlock.TOP, (Comparable)Boolean.valueOf(true)))});
    public static final class_3542.class_7292<RepairPylonState> CODEC = class_3542.method_28140(RepairPylonState::values);
    public LodestoneBlockEntityInventory inventory;
    public LodestoneBlockEntityInventory spiritInventory;
    public SpiritRepairRecipe recipe;
    public RepairPylonState state = RepairPylonState.IDLE;
    public class_2338 repairablePosition;
    public int timer;
    public float spiritAmount;
    public float spiritSpin;
    final LazyOptional<IItemHandler> combinedInventory = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.spiritInventory}));

    public RepairPylonCoreBlockEntity(class_2591<? extends RepairPylonCoreBlockEntity> type, MultiBlockStructure structure, class_2338 pos, class_2680 state) {
        super(type, structure, pos, state);
        this.inventory = new MalumBlockEntityInventory(1, 64, t -> !(t.method_7909() instanceof SpiritShardItem)){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                RepairPylonCoreBlockEntity.this.needsSync = true;
                BlockHelper.updateAndNotifyState((class_1937)RepairPylonCoreBlockEntity.this.field_11863, (class_2338)RepairPylonCoreBlockEntity.this.field_11867);
            }
        };
        this.spiritInventory = new MalumBlockEntityInventory(4, 64){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                RepairPylonCoreBlockEntity.this.needsSync = true;
                RepairPylonCoreBlockEntity.this.spiritAmount = Math.max(1.0f, class_3532.method_16439((float)0.15f, (float)RepairPylonCoreBlockEntity.this.spiritAmount, (float)(this.nonEmptyItemAmount + 1)));
                BlockHelper.updateAndNotifyState((class_1937)RepairPylonCoreBlockEntity.this.field_11863, (class_2338)RepairPylonCoreBlockEntity.this.field_11867);
            }

            public boolean isItemValid(int slot, @NotNull class_1799 stack) {
                class_1792 class_17922 = stack.method_7909();
                if (!(class_17922 instanceof SpiritShardItem)) {
                    return false;
                }
                SpiritShardItem spiritItem = (SpiritShardItem)class_17922;
                for (int i = 0; i < this.getSlots(); ++i) {
                    class_1799 stackInSlot;
                    if (i == slot || (stackInSlot = this.getStackInSlot(i)).method_7960() || stackInSlot.method_7909() != spiritItem) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public RepairPylonCoreBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends RepairPylonCoreBlockEntity>)((class_2591)BlockEntityRegistry.REPAIR_PYLON.get()), STRUCTURE.get(), pos, state);
    }

    protected void method_11007(class_2487 compound) {
        compound.method_10582("state", this.state.name);
        if (this.spiritAmount != 0.0f) {
            compound.method_10548("spiritAmount", this.spiritAmount);
        }
        if (this.repairablePosition != null) {
            compound.method_10566("targetedBlock", (class_2520)BlockHelper.saveBlockPos((class_2487)new class_2487(), (class_2338)this.repairablePosition));
        }
        if (this.timer != 0) {
            compound.method_10569("timer", this.timer);
        }
        this.inventory.save(compound);
        this.spiritInventory.save(compound, "spiritInventory");
    }

    public void method_11014(class_2487 compound) {
        this.state = compound.method_10545("state") ? (RepairPylonState)CODEC.method_42633(compound.method_10558("state")) : RepairPylonState.IDLE;
        this.spiritAmount = compound.method_10583("spiritAmount");
        this.repairablePosition = BlockHelper.loadBlockPos((class_2487)compound.method_10562("targetedBlock"));
        this.timer = compound.method_10550("timer");
        this.inventory.load(compound);
        this.spiritInventory.load(compound, "spiritInventory");
        super.method_11014(compound);
    }

    public class_1269 onUse(class_1657 player, class_1268 hand) {
        if (this.field_11863.field_9236) {
            return class_1269.field_21466;
        }
        if (hand.equals((Object)class_1268.field_5808)) {
            class_1799 stack;
            class_1799 heldStack = player.method_6047();
            boolean isEmpty = heldStack.method_7960();
            class_1799 spiritStack = this.spiritInventory.interact(this.field_11863, player, hand);
            if (!spiritStack.method_7960()) {
                return class_1269.field_5812;
            }
            if (!(heldStack.method_7909() instanceof SpiritShardItem) && !(stack = this.inventory.interact(this.field_11863, player, hand)).method_7960()) {
                return class_1269.field_5812;
            }
            if (isEmpty) {
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }
        return super.onUse(player, hand);
    }

    public void onBreak(@Nullable class_1657 player) {
        this.inventory.dumpItems(this.field_11863, this.field_11867);
        this.spiritInventory.dumpItems(this.field_11863, this.field_11867);
        super.onBreak(player);
    }

    public void init() {
        if (this.state.equals((Object)RepairPylonState.COOLDOWN)) {
            return;
        }
        boolean wasNull = this.recipe == null;
        this.recipe = SpiritRepairRecipe.getRecipe(this.field_11863, c -> c.doesRepairMatch(this.inventory.getStackInSlot(0)) && c.doSpiritsMatch(this.spiritInventory.nonEmptyItemStacks));
        if (wasNull) {
            this.setState(RepairPylonState.SEARCHING);
        }
    }

    public void tick() {
        super.tick();
        this.spiritAmount = Math.max(1.0f, class_3532.method_16439((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.nonEmptyItemAmount));
        if (this.field_11863.field_9236) {
            this.spiritSpin += 1.0f;
            if (this.state.equals((Object)RepairPylonState.COOLDOWN) && this.timer < 300) {
                ++this.timer;
            }
            RepairPylonParticleEffects.passiveRepairPylonParticles(this);
        } else {
            switch (this.state) {
                case IDLE: {
                    if (this.recipe == null) break;
                    this.setState(RepairPylonState.SEARCHING);
                    break;
                }
                case SEARCHING: {
                    ++this.timer;
                    if (this.timer < 100) break;
                    if (this.recipe == null) {
                        this.timer = 0;
                        return;
                    }
                    boolean success = this.tryRepair();
                    if (success) {
                        this.setState(RepairPylonState.CHARGING);
                        break;
                    }
                    this.timer = 0;
                    break;
                }
                case CHARGING: {
                    IMalumSpecialItemAccessPoint provider;
                    ++this.timer;
                    if (this.recipe == null) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    if (this.timer < 60) break;
                    if (this.repairablePosition == null) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    class_2586 class_25862 = this.field_11863.method_8321(this.repairablePosition);
                    if (!(class_25862 instanceof IMalumSpecialItemAccessPoint) || !this.tryRepair(provider = (IMalumSpecialItemAccessPoint)class_25862)) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    this.prepareRepair(provider);
                    break;
                }
                case REPAIRING: {
                    IMalumSpecialItemAccessPoint provider;
                    ++this.timer;
                    if (this.recipe == null) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    if (this.timer < 30) break;
                    if (this.repairablePosition == null) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    class_2586 class_25863 = this.field_11863.method_8321(this.repairablePosition);
                    if (!(class_25863 instanceof IMalumSpecialItemAccessPoint) || !this.tryRepair(provider = (IMalumSpecialItemAccessPoint)class_25863)) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    this.repairItem(provider);
                    break;
                }
                case COOLDOWN: {
                    ++this.timer;
                    if (this.timer < 300) break;
                    this.setState(RepairPylonState.IDLE);
                }
            }
        }
    }

    public boolean tryRepair() {
        Collection altarProviders = BlockHelper.getBlockEntities(IMalumSpecialItemAccessPoint.class, (class_1937)this.field_11863, (class_2338)this.field_11867, (int)6, (int)4, (int)6);
        for (IMalumSpecialItemAccessPoint provider : altarProviders) {
            boolean success = this.tryRepair(provider);
            if (!success) continue;
            this.repairablePosition = provider.getAccessPointBlockPos();
            return true;
        }
        return false;
    }

    public boolean tryRepair(IMalumSpecialItemAccessPoint provider) {
        LodestoneBlockEntityInventory inventoryForAltar = provider.getSuppliedInventory();
        SpiritRepairRecipe newRecipe = SpiritRepairRecipe.getRecipe(this.field_11863, inventoryForAltar.getStackInSlot(0), this.inventory.getStackInSlot(0), this.spiritInventory.nonEmptyItemStacks);
        return newRecipe != null;
    }

    public void prepareRepair(IMalumSpecialItemAccessPoint provider) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ParticleEffectTypeRegistry.REPAIR_PYLON_PREPARES.createPositionedEffect(serverLevel, new PositionEffectData(this.field_11867), ColorEffectData.fromRecipe(this.recipe.spirits), PylonPrepareRepairParticleEffect.createData(provider.getAccessPointBlockPos()));
        }
        this.setState(RepairPylonState.REPAIRING);
    }

    public void repairItem(IMalumSpecialItemAccessPoint provider) {
        LodestoneBlockEntityInventory suppliedInventory = provider.getSuppliedInventory();
        class_1799 damagedItem = suppliedInventory.getStackInSlot(0);
        class_1799 repairMaterial = this.inventory.getStackInSlot(0);
        repairMaterial.method_7934(this.recipe.repairMaterial.getCount());
        block0: for (SpiritWithCount spirit : this.recipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                class_1799 spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.matches(spiritStack)) continue;
                spiritStack.method_7934(spirit.count);
                continue block0;
            }
        }
        this.spiritInventory.updateData();
        class_1799 result = SpiritRepairRecipe.getRepairRecipeOutput(damagedItem);
        result.method_7974(Math.max(0, result.method_7919() - (int)((float)result.method_7936() * this.recipe.durabilityPercentage)));
        suppliedInventory.setStackInSlot(0, result);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ParticleEffectTypeRegistry.REPAIR_PYLON_REPAIRS.createPositionedEffect(serverLevel, new PositionEffectData(this.field_11867), ColorEffectData.fromRecipe(this.recipe.spirits), PylonPrepareRepairParticleEffect.createData(provider.getAccessPointBlockPos()));
        }
        this.setState(RepairPylonState.COOLDOWN);
    }

    public void setState(RepairPylonState state) {
        this.state = state;
        this.timer = 0;
        BlockHelper.updateAndNotifyState((class_1937)this.field_11863, (class_2338)this.field_11867);
    }

    public class_243 getItemPos() {
        class_2338 blockPos = this.method_11016();
        class_243 offset = this.getCentralItemOffset();
        return new class_243((double)blockPos.method_10263() + offset.field_1352, (double)blockPos.method_10264() + offset.field_1351, (double)blockPos.method_10260() + offset.field_1350);
    }

    public class_243 getCentralItemOffset() {
        return PYLON_ITEM_OFFSET;
    }

    public class_243 getSpiritItemOffset(int slot, float partialTicks) {
        float distance = 0.75f + (float)Math.sin((this.spiritSpin + partialTicks) % 6.28f / 20.0f) * 0.025f;
        float height = 2.75f;
        if (this.state.equals((Object)RepairPylonState.COOLDOWN)) {
            int relativeCooldown = this.timer < 270 ? Math.min(this.timer, 30) : 300 - this.timer;
            distance += this.getCooldownOffset(relativeCooldown, Easing.SINE_OUT) * 0.25f;
            height -= this.getCooldownOffset(relativeCooldown, Easing.QUARTIC_OUT) * this.getCooldownOffset(relativeCooldown, (Easing)Easing.BACK_OUT) * 0.5f;
        }
        return DataHelper.rotatingRadialOffset((class_243)new class_243(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.spiritAmount, (long)((long)(this.spiritSpin + partialTicks)), (float)360.0f);
    }

    public float getCooldownOffset(int relativeCooldown, Easing easing) {
        return easing.ease((float)relativeCooldown / 30.0f, 0.0f, 1.0f, 1.0f);
    }

    public class_238 getRenderBoundingBox() {
        class_2338 pos = this.field_11867;
        return new class_238((double)(pos.method_10263() - 1), (double)pos.method_10264(), (double)(pos.method_10260() - 1), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 4), (double)(pos.method_10260() + 1));
    }

    public static enum RepairPylonState implements class_3542
    {
        IDLE("idle"),
        SEARCHING("searching"),
        CHARGING("active"),
        REPAIRING("repairing"),
        COOLDOWN("cooldown");

        final String name;

        private RepairPylonState(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

