/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.screens;

import com.google.common.collect.ImmutableList;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.handlers.BookObjectHandler;
import com.sammy.malum.client.screen.codex.objects.ArrowObject;
import com.sammy.malum.client.screen.codex.objects.LinkedEntryObject;
import com.sammy.malum.client.screen.codex.objects.progression.ProgressionEntryObject;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.AbstractProgressionCodexScreen;
import com.sammy.malum.config.ClientConfig;
import com.sammy.malum.registry.common.SoundRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class EntryScreen
extends AbstractMalumScreen {
    public static EntryScreen entryScreen;
    public static final class_2960 BOOK_TEXTURE;
    public static final class_2960 ELEMENT_SOCKET;
    public final int bookWidth = 312;
    public final int bookHeight = 200;
    public final BookEntry openEntry;
    protected final Consumer<Boolean> onClose;
    public final BookObjectHandler<EntryScreen> bookObjectHandler = new BookObjectHandler();
    public List<Runnable> lateRendering = new ArrayList<Runnable>();
    public int grouping;

    public EntryScreen(BookEntry openEntry, Consumer<Boolean> onClose) {
        super((class_2561)class_2561.method_43473(), (Supplier<class_3414>)(openEntry.isVoid ? SoundRegistry.ARCANA_SWEETENER_EVIL : SoundRegistry.ARCANA_SWEETENER_NORMAL));
        this.openEntry = openEntry;
        this.onClose = onClose;
        int left = -21;
        int right = 297;
        this.bookObjectHandler.add(new ArrowObject(-21, 150, false));
        this.bookObjectHandler.add(new ArrowObject(297, 150, true));
        ImmutableList<EntryReference> references = openEntry.references;
        if (references != null) {
            int counter = 0;
            for (int i = 0; i < references.size(); ++i) {
                EntryReference entryReference = (EntryReference)references.get(i);
                if (!entryReference.entry.shouldShow()) continue;
                this.bookObjectHandler.add(new LinkedEntryObject(297, 15 + counter * 30, true, entryReference));
                ++counter;
            }
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int pageTop;
        int pageLeft;
        boolean isRightSide;
        BookPage page;
        int openPages;
        int i;
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        class_4587 poseStack = guiGraphics.method_51448();
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        ArcanaCodexHelper.renderTexture(BOOK_TEXTURE, poseStack, guiLeft, guiTop, 0.0f, 0.0f, 312, 200);
        if (!this.openEntry.pages.isEmpty()) {
            for (i = openPages = this.grouping * 2; i < openPages + 2; ++i) {
                if (i >= this.openEntry.pages.size()) continue;
                page = (BookPage)this.openEntry.pages.get(i);
                isRightSide = i % 2 == 1;
                pageLeft = guiLeft + (isRightSide ? 161 : 9);
                pageTop = guiTop + 8;
                class_2960 background = page.getBackground(isRightSide);
                if (background == null) continue;
                ArcanaCodexHelper.renderTexture(background, poseStack, pageLeft, pageTop, 0.0f, 0.0f, 142, 172);
            }
        }
        this.bookObjectHandler.renderObjects(this, guiGraphics, guiLeft, guiTop, mouseX, mouseY, partialTicks);
        if (!this.openEntry.pages.isEmpty()) {
            for (i = openPages = this.grouping * 2; i < openPages + 2; ++i) {
                if (i >= this.openEntry.pages.size()) continue;
                page = (BookPage)this.openEntry.pages.get(i);
                isRightSide = i % 2 == 1;
                pageLeft = guiLeft + (isRightSide ? 161 : 9);
                pageTop = guiTop + 8;
                boolean isRepeat = i % 2 != 0 && page.getClass().equals(((BookPage)this.openEntry.pages.get(i - 1)).getClass());
                page.render(this, guiGraphics, pageLeft, pageTop, mouseX, mouseY, partialTicks, isRepeat);
                this.lateRendering.add(() -> page.renderLate(this, guiGraphics, pageLeft, pageTop, mouseX, mouseY, partialTicks, isRepeat));
            }
            this.lateRendering.forEach(Runnable::run);
            this.lateRendering.clear();
        }
        this.bookObjectHandler.renderObjectsLate(this, guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.bookObjectHandler.click(this, mouseX, mouseY);
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        if (!this.openEntry.pages.isEmpty()) {
            int openPages;
            for (int i = openPages = this.grouping * 2; i < openPages + 2; ++i) {
                int pageTop;
                if (i >= this.openEntry.pages.size()) continue;
                BookPage page = (BookPage)this.openEntry.pages.get(i);
                boolean isRightSide = i % 2 == 1;
                int pageLeft = guiLeft + (isRightSide ? 161 : 9);
                if (!this.isHovering(mouseX, mouseY, pageLeft, pageTop = guiTop + 8, 142, 172)) continue;
                double relativeX = class_3532.method_15350((double)(mouseX - (double)guiLeft), (double)guiLeft, (double)(guiLeft + 142));
                double relativeY = class_3532.method_15350((double)(mouseY - (double)guiTop), (double)guiTop, (double)(guiTop + 172));
                page.click(this, pageLeft, pageTop, mouseX, mouseY, relativeX, relativeY);
            }
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        if (((Boolean)ClientConfig.SCROLL_DIRECTION.getConfigValue()).booleanValue()) {
            scroll = -scroll;
        }
        if (scroll > 0.0) {
            this.nextPage();
        } else {
            this.previousPage(false);
        }
        return super.method_25401(mouseX, mouseY, scroll);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1849.method_1417(keyCode, scanCode)) {
            this.nextPage();
            return true;
        }
        if (this.field_22787.field_1690.field_1913.method_1417(keyCode, scanCode)) {
            this.previousPage(false);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.close(false);
    }

    public boolean hasNextPage() {
        return (float)this.grouping < (float)this.openEntry.pages.size() / 2.0f - 1.0f;
    }

    public void nextPage() {
        if (this.hasNextPage()) {
            ++this.grouping;
            this.playPageFlipSound((Supplier<class_3414>)SoundRegistry.ARCANA_PAGE_FLIP, this.getSweetenerPitch());
        }
    }

    public void previousPage(boolean ignore) {
        if (this.grouping > 0) {
            --this.grouping;
            this.playPageFlipSound((Supplier<class_3414>)SoundRegistry.ARCANA_PAGE_FLIP, this.getSweetenerPitch());
        } else {
            this.close(ignore);
        }
    }

    public void close(boolean ignoreNextInput) {
        this.onClose.accept(ignoreNextInput);
        this.playSweetenedSound((Supplier<class_3414>)SoundRegistry.ARCANA_ENTRY_CLOSE, 0.85f);
    }

    public static <K extends AbstractProgressionCodexScreen> void openScreen(K screen, ProgressionEntryObject progressionEntryObject) {
        EntryScreen.openScreen(progressionEntryObject.entry, (Boolean b) -> {
            screen.openScreen((boolean)b);
            progressionEntryObject.exit(screen);
        });
    }

    public static void openScreen(AbstractMalumScreen screen, BookEntry entry) {
        EntryScreen.openScreen(entry, screen::openScreen);
    }

    public static void openScreen(BookEntry bookEntry, Consumer<Boolean> onClose) {
        entryScreen = new EntryScreen(bookEntry, onClose);
        entryScreen.playSweetenedSound((Supplier<class_3414>)SoundRegistry.ARCANA_ENTRY_OPEN, 1.15f);
        class_310.method_1551().method_1507((class_437)entryScreen);
    }

    public float getSweetenerPitch() {
        return 1.0f + (float)this.grouping / (float)this.openEntry.pages.size();
    }

    public int getGuiLeft() {
        return (this.field_22789 - 312) / 2;
    }

    public int getGuiTop() {
        return (this.field_22790 - 200) / 2;
    }

    public void renderLate(Runnable runnable) {
        this.lateRendering.add(runnable);
    }

    static {
        BOOK_TEXTURE = MalumMod.malumPath("textures/gui/book/entry.png");
        ELEMENT_SOCKET = MalumMod.malumPath("textures/gui/book/entry_elements/element_socket.png");
    }
}

