/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.screens;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.PlacedBookEntry;
import com.sammy.malum.client.screen.codex.PlacedBookEntryBuilder;
import com.sammy.malum.client.screen.codex.handlers.EntryObjectHandler;
import com.sammy.malum.client.screen.codex.objects.BookObject;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.registry.common.SoundRegistry;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.lwjgl.opengl.GL11;

public abstract class AbstractProgressionCodexScreen
extends AbstractMalumScreen {
    public static final class_2960 FRAME_TEXTURE = MalumMod.malumPath("textures/gui/book/frame.png");
    public static final class_2960 FRAME_FADE_TEXTURE = MalumMod.malumPath("textures/gui/book/frame_fade.png");
    public float xOffset;
    public float yOffset;
    public float cachedXOffset;
    public float cachedYOffset;
    public boolean ignoreNextMouseInput;
    public int transitionTimer;
    public int timesTransitioned;
    public boolean isVoidTouched;
    public final EntryObjectHandler bookObjectHandler = new EntryObjectHandler();
    public final int bookWidth;
    public final int bookHeight;
    public final int bookInsideWidth;
    public final int bookInsideHeight;
    public final int backgroundImageWidth;
    public final int backgroundImageHeight;

    protected AbstractProgressionCodexScreen(Supplier<class_3414> sweetenerSound, int backgroundImageWidth, int backgroundImageHeight) {
        this(sweetenerSound, 378, 250, 344, 218, backgroundImageWidth, backgroundImageHeight);
    }

    protected AbstractProgressionCodexScreen(Supplier<class_3414> sweetenerSound, int bookWidth, int bookHeight, int bookInsideWidth, int bookInsideHeight, int backgroundImageWidth, int backgroundImageHeight) {
        super((class_2561)class_2561.method_43473(), sweetenerSound);
        this.bookWidth = bookWidth;
        this.bookHeight = bookHeight;
        this.bookInsideWidth = bookInsideWidth;
        this.bookInsideHeight = bookInsideHeight;
        this.backgroundImageWidth = backgroundImageWidth;
        this.backgroundImageHeight = backgroundImageHeight;
        this.field_22787 = class_310.method_1551();
    }

    public abstract void renderBackground(class_4587 var1);

    public abstract Collection<PlacedBookEntry> getEntries();

    public void addEntry(String identifier, int xOffset, int yOffset) {
        this.addEntry(identifier, xOffset, yOffset, b -> {});
    }

    public void addEntry(String identifier, int xOffset, int yOffset, Consumer<PlacedBookEntryBuilder> consumer) {
        PlacedBookEntryBuilder builder = PlacedBookEntry.build(identifier, xOffset, yOffset);
        consumer.accept(builder);
        if (builder.hasFragment()) {
            this.getEntries().add(builder.buildFragment());
        }
        this.getEntries().add(builder.build());
    }

    public PlacedBookEntry getEntry(String identifier) {
        return this.getEntries().stream().filter(p -> p.identifier.matches(identifier)).findFirst().orElseThrow(() -> new NullPointerException("Encyclopedia Arcana tried initiating a reference to the " + identifier + " entry, which doesn't exist"));
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        class_4587 poseStack = guiGraphics.method_51448();
        this.renderBackground(poseStack);
        GL11.glEnable((int)3089);
        this.cut();
        this.bookObjectHandler.renderObjects(this, guiGraphics, (float)guiLeft + this.xOffset, (float)guiTop + this.yOffset, mouseX, mouseY, partialTicks);
        GL11.glDisable((int)3089);
        ArcanaCodexHelper.renderTexture(FRAME_FADE_TEXTURE, poseStack, guiLeft, guiTop, 0.0f, 0.0f, this.bookWidth, this.bookHeight);
        if (this.transitionTimer > 0) {
            ArcanaCodexHelper.renderTransitionFade(this, poseStack);
        }
        ArcanaCodexHelper.renderTexture(FRAME_TEXTURE, poseStack, guiLeft, guiTop, 400, 0.0f, 0.0f, this.bookWidth, this.bookHeight);
        this.bookObjectHandler.renderObjectsLate(this, guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.ignoreNextMouseInput) {
            this.ignoreNextMouseInput = false;
            return super.method_25406(mouseX, mouseY, button);
        }
        if (this.xOffset != this.cachedXOffset || this.yOffset != this.cachedYOffset) {
            return super.method_25406(mouseX, mouseY, button);
        }
        this.bookObjectHandler.click(this, mouseX, mouseY);
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.xOffset = (float)((double)this.xOffset + dragX);
        this.yOffset = (float)((double)this.yOffset + dragY);
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.cachedXOffset = this.xOffset;
        this.cachedYOffset = this.yOffset;
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25419() {
        super.method_25419();
        this.playSweetenedSound((Supplier<class_3414>)SoundRegistry.ARCANA_CODEX_CLOSE, 0.75f);
    }

    public void method_25393() {
        if (this.transitionTimer > 0) {
            --this.transitionTimer;
        }
        super.method_25393();
    }

    @Override
    public boolean isHovering(double mouseX, double mouseY, float posX, float posY, int width, int height) {
        if (!this.isInView(mouseX, mouseY)) {
            return false;
        }
        return super.isHovering(mouseX, mouseY, posX, posY, width, height);
    }

    public void setupObjects() {
        this.field_22789 = this.field_22787.method_22683().method_4486();
        this.field_22790 = this.field_22787.method_22683().method_4502();
        this.bookObjectHandler.setupEntryObjects(this);
    }

    public void faceObject(BookObject<?> object) {
        this.field_22789 = this.field_22787.method_22683().method_4486();
        this.field_22790 = this.field_22787.method_22683().method_4502();
        this.xOffset = (float)(-object.posX) + (float)this.bookInsideWidth / 2.0f;
        this.yOffset = (float)(-object.posY) + (float)this.bookInsideHeight / 2.0f;
    }

    @Override
    public void openScreen(boolean silentMouseInput) {
        class_310.method_1551().method_1507((class_437)this);
        this.ignoreNextMouseInput = silentMouseInput;
    }

    public void renderBackground(class_4587 poseStack, class_2960 texture, float xModifier, float yModifier) {
        int insideLeft = this.getInsideLeft();
        int insideTop = this.getInsideTop();
        float uOffset = (float)this.bookInsideWidth / 8.0f - this.xOffset * xModifier;
        float vOffset = (float)(this.backgroundImageHeight - this.bookInsideHeight) - this.yOffset * yModifier;
        if (uOffset <= 0.0f) {
            uOffset = 0.0f;
        }
        if (uOffset > (float)this.bookInsideWidth / 2.0f) {
            uOffset = (float)this.bookInsideWidth / 2.0f;
        }
        if (vOffset <= (float)this.backgroundImageHeight / 2.0f) {
            vOffset = (float)this.backgroundImageHeight / 2.0f;
        }
        if (vOffset > (float)(this.backgroundImageHeight - this.bookInsideHeight)) {
            vOffset = this.backgroundImageHeight - this.bookInsideHeight;
        }
        ArcanaCodexHelper.renderTexture(texture, poseStack, insideLeft, insideTop, uOffset, vOffset, this.bookInsideWidth, this.bookInsideHeight, this.backgroundImageWidth / 2, this.backgroundImageHeight / 2);
    }

    public boolean isInView(double mouseX, double mouseY) {
        return mouseX >= (double)this.getInsideLeft() && mouseY >= (double)this.getInsideTop() && mouseX <= (double)(this.getInsideLeft() + this.bookInsideWidth) && mouseY <= (double)(this.getInsideTop() + this.bookInsideHeight);
    }

    public void cut() {
        int scale = (int)class_310.method_1551().method_22683().method_4495();
        GL11.glScissor((int)(this.getInsideLeft() * scale), (int)(class_310.method_1551().method_22683().method_4506() - (this.getInsideTop() + this.bookInsideHeight) * scale), (int)(this.bookInsideWidth * scale), (int)(this.bookInsideHeight * scale));
    }

    public int getInsideLeft() {
        return this.getGuiLeft() + 17;
    }

    public int getInsideTop() {
        return this.getGuiTop() + 14;
    }

    public int getGuiLeft() {
        return (this.field_22789 - this.bookWidth) / 2;
    }

    public int getGuiTop() {
        return (this.field_22790 - this.bookHeight) / 2;
    }

    public int getTransitionDuration() {
        return 80 - class_3532.method_15340((int)(this.timesTransitioned - 2), (int)0, (int)4) * 10;
    }
}

