/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex;

import com.google.common.collect.ImmutableList;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_2583;

public class BookEntryBuilder {
    protected final String identifier;
    protected final boolean isVoid;
    protected UnaryOperator<class_2583> titleStyle = UnaryOperator.identity();
    protected UnaryOperator<class_2583> subtitleStyle = style -> style.method_10977(class_124.field_1080);
    protected List<BookPage> pages = new ArrayList<BookPage>();
    protected List<EntryReference> references = new ArrayList<EntryReference>();
    protected BooleanSupplier entryVisibleChecker = () -> true;
    protected boolean tooltipDisabled = false;

    protected BookEntryBuilder(String identifier, boolean isVoid) {
        this.identifier = identifier;
        this.isVoid = isVoid;
    }

    public BookEntryBuilder(String identifier) {
        this(identifier, identifier.startsWith("void."));
    }

    public BookEntryBuilder addPage(BookPage page) {
        if (page.isValid()) {
            this.pages.add(page);
        }
        return this;
    }

    public BookEntryBuilder addReference(EntryReference reference) {
        this.references.add(reference);
        return this;
    }

    public BookEntryBuilder styleTitle(UnaryOperator<class_2583> styleFunction) {
        UnaryOperator<class_2583> existingStyle = this.titleStyle;
        this.titleStyle = style -> (class_2583)styleFunction.apply((class_2583)existingStyle.apply((class_2583)style));
        return this;
    }

    public BookEntryBuilder styleSubtitle(UnaryOperator<class_2583> styleFunction) {
        UnaryOperator<class_2583> existingStyle = this.subtitleStyle;
        this.subtitleStyle = style -> (class_2583)styleFunction.apply((class_2583)existingStyle.apply((class_2583)style));
        return this;
    }

    public BookEntryBuilder setEntryVisibleWhen(BooleanSupplier condition) {
        this.entryVisibleChecker = condition;
        return this;
    }

    public BookEntryBuilder afterUmbralCrystal() {
        this.entryVisibleChecker = BookEntry.AFTER_UMBRAL_CRYSTAL;
        return this;
    }

    public BookEntryBuilder disableTooltip() {
        this.tooltipDisabled = true;
        return this;
    }

    public BookEntry build() {
        ImmutableList bookPages = ImmutableList.copyOf(this.pages);
        ImmutableList entryReferences = ImmutableList.copyOf(this.references);
        BookEntry bookEntry = new BookEntry(this.identifier, this.isVoid, (ImmutableList<BookPage>)bookPages, (ImmutableList<EntryReference>)entryReferences, this.entryVisibleChecker, this.titleStyle, this.subtitleStyle, this.tooltipDisabled, false);
        bookPages.forEach(p -> p.setBookEntry(bookEntry));
        return bookEntry;
    }
}

