/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.AbstractProgressionCodexScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.common.spiritrite.TotemicRiteType;
import com.sammy.malum.config.ClientConfig;
import com.sammy.malum.core.systems.ritual.MalumRitualType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.ShaderRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.joml.Vector4f;
import team.lodestar.lodestone.registry.client.LodestoneShaderRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.recipe.IRecipeComponent;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class ArcanaCodexHelper {
    public static final VFXBuilders.ScreenVFXBuilder VFX_BUILDER = VFXBuilders.createScreen().setPosTexDefaultFormat();

    public static <T extends AbstractProgressionCodexScreen> void renderTransitionFade(T screen, class_4587 stack) {
        float pct = (float)screen.transitionTimer / (float)screen.getTransitionDuration();
        float overlayAlpha = Easing.SINE_IN_OUT.ease(pct, 0.0f, 1.0f, 1.0f);
        float effectStrength = Easing.QUAD_OUT.ease(pct, 0.0f, 1.0f, 1.0f);
        float effectAlpha = Math.min(1.0f, effectStrength * 1.0f);
        float zoom = 0.5f + Math.min(0.35f, effectStrength);
        float intensity = 1.0f + (effectStrength > 0.5f ? (effectStrength - 0.5f) * 2.5f : 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPositionWithWidth((float)screen.getInsideLeft(), (float)screen.getInsideTop(), (float)screen.bookInsideWidth, (float)screen.bookInsideHeight).setColor(0.0f, 0.0f, 0.0f).setAlpha(overlayAlpha).setZLevel(200).setPosColorDefaultFormat().setShader(class_757::method_34540).draw(stack);
        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)ShaderRegistry.TOUCH_OF_DARKNESS.getInstance().get();
        shaderInstance.method_35785("Speed").method_1251(1000.0f);
        Consumer<Float> setZoom = f -> shaderInstance.method_35785("Zoom").method_1251(f.floatValue());
        Consumer<Float> setIntensity = f -> shaderInstance.method_35785("Intensity").method_1251(f.floatValue());
        builder.setPosColorTexDefaultFormat().setAlpha(effectAlpha).setShader(ShaderRegistry.TOUCH_OF_DARKNESS.getInstance());
        setZoom.accept(Float.valueOf(zoom));
        setIntensity.accept(Float.valueOf(intensity));
        builder.draw(stack);
        setZoom.accept(Float.valueOf(zoom * 1.25f + 0.15f));
        setIntensity.accept(Float.valueOf(intensity * 0.8f + 0.5f));
        builder.draw(stack);
        shaderInstance.setUniformDefaults();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void renderRitualIcon(MalumRitualType rite, class_4587 stack, boolean corrupted, float glowAlpha, int x, int y) {
        ArcanaCodexHelper.renderRiteIcon(rite.getIcon(), rite.spirit, stack, corrupted, glowAlpha, x, y, 0);
    }

    public static void renderRiteIcon(TotemicRiteType rite, class_4587 stack, boolean corrupted, float glowAlpha, int x, int y) {
        ArcanaCodexHelper.renderRiteIcon(rite.getIcon(), rite.getIdentifyingSpirit(), stack, corrupted, glowAlpha, x, y, 0);
    }

    public static void renderRiteIcon(class_2960 texture, MalumSpiritType spiritType, class_4587 stack, boolean corrupted, float glowAlpha, int x, int y) {
        ArcanaCodexHelper.renderRiteIcon(texture, spiritType, stack, corrupted, glowAlpha, x, y, 0);
    }

    public static void renderRiteIcon(class_2960 texture, MalumSpiritType spiritType, class_4587 stack, boolean corrupted, float glowAlpha, int x, int y, int z) {
        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)LodestoneShaderRegistry.DISTORTED_TEXTURE.getInstance().get();
        shaderInstance.method_35785("YFrequency").method_1251(corrupted ? 5.0f : 11.0f);
        shaderInstance.method_35785("XFrequency").method_1251(corrupted ? 12.0f : 17.0f);
        shaderInstance.method_35785("Speed").method_1251(2000.0f * (corrupted ? -0.75f : 1.0f));
        shaderInstance.method_35785("Intensity").method_1251(corrupted ? 14.0f : 50.0f);
        Supplier<class_5944> shaderInstanceSupplier = () -> shaderInstance;
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPosColorTexLightmapDefaultFormat().setShader(shaderInstanceSupplier).setColor(spiritType.getPrimaryColor()).setAlpha(0.9f).setZLevel(z);
        RenderSystem.blendFunc((int)770, (int)1);
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        builder.setAlpha(glowAlpha);
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x - 1, y, 0.0f, 0.0f, 16, 16, 16, 16);
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x + 1, y, 0.0f, 0.0f, 16, 16, 16, 16);
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x, y - 1, 0.0f, 0.0f, 16, 16, 16, 16);
        if (corrupted) {
            builder.setColor(spiritType.getSecondaryColor());
        }
        ArcanaCodexHelper.renderTexture(texture, stack, builder, x, y + 1, 0.0f, 0.0f, 16, 16, 16, 16);
        shaderInstance.setUniformDefaults();
        RenderSystem.defaultBlendFunc();
    }

    public static void renderWavyIcon(class_2960 location, class_4587 stack, int x, int y) {
        ArcanaCodexHelper.renderWavyIcon(location, stack, x, y, 0);
    }

    public static void renderWavyIcon(class_2960 location, class_4587 stack, int x, int y, int z) {
        ArcanaCodexHelper.renderWavyIcon(location, stack, x, y, 0, 16, 16);
    }

    public static void renderWavyIcon(class_2960 location, class_4587 stack, int x, int y, int z, int textureWidth, int textureHeight) {
        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)LodestoneShaderRegistry.DISTORTED_TEXTURE.getInstance().get();
        shaderInstance.method_35785("YFrequency").method_1251(10.0f);
        shaderInstance.method_35785("XFrequency").method_1251(12.0f);
        shaderInstance.method_35785("Speed").method_1251(1000.0f);
        shaderInstance.method_35785("Intensity").method_1251(50.0f);
        shaderInstance.method_35785("UVCoordinates").method_35652(new Vector4f(0.0f, 1.0f, 0.0f, 1.0f));
        Supplier<class_5944> shaderInstanceSupplier = () -> shaderInstance;
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPosColorTexLightmapDefaultFormat().setShader(shaderInstanceSupplier).setAlpha(0.7f).setZLevel(z).setShader(() -> shaderInstance);
        RenderSystem.blendFunc((int)770, (int)1);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y, 0.0f, 0.0f, textureWidth, textureHeight);
        builder.setAlpha(0.1f);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x - 1, y, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x + 1, y, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y - 1, 0.0f, 0.0f, textureWidth, textureHeight);
        ArcanaCodexHelper.renderTexture(location, stack, builder, x, y + 1, 0.0f, 0.0f, textureWidth, textureHeight);
        shaderInstance.setUniformDefaults();
        RenderSystem.defaultBlendFunc();
    }

    public static void renderTexture(class_2960 texture, class_4587 poseStack, int x, int y, float u, float v, int width, int height) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, x, y, u, v, width, height, width, height);
    }

    public static void renderTexture(class_2960 texture, class_4587 poseStack, int x, int y, int z, float u, float v, int width, int height) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, x, y, z, u, v, width, height, width, height);
    }

    public static void renderTexture(class_2960 texture, class_4587 poseStack, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, VFX_BUILDER, x, y, 0, u, v, width, height, textureWidth, textureHeight);
    }

    public static void renderTexture(class_2960 texture, class_4587 poseStack, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, VFX_BUILDER, x, y, z, u, v, width, height, textureWidth, textureHeight);
    }

    public static void renderTexture(class_2960 texture, class_4587 poseStack, VFXBuilders.ScreenVFXBuilder builder, int x, int y, float u, float v, int width, int height) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, builder, x, y, 0, u, v, width, height, width, height);
    }

    public static void renderTexture(class_2960 texture, class_4587 poseStack, VFXBuilders.ScreenVFXBuilder builder, int x, int y, int z, float u, float v, int width, int height) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, builder, x, y, z, u, v, width, height, width, height);
    }

    public static void renderTexture(class_2960 texture, class_4587 poseStack, VFXBuilders.ScreenVFXBuilder builder, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        ArcanaCodexHelper.renderTexture(texture, poseStack, builder, x, y, 0, u, v, width, height, textureWidth, textureHeight);
    }

    public static void renderTexture(class_2960 texture, class_4587 poseStack, VFXBuilders.ScreenVFXBuilder builder, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        builder.setPositionWithWidth((float)x, (float)y, (float)width, (float)height).setZLevel(z).setShaderTexture(texture).setUVWithWidth(u, v, (float)width, (float)height, (float)textureWidth, (float)textureHeight).draw(poseStack);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void renderComponents(AbstractMalumScreen screen, class_332 guiGraphics, List<? extends IRecipeComponent> components, int left, int top, int mouseX, int mouseY, boolean vertical) {
        List<class_1799> items = components.stream().map(IRecipeComponent::getStack).collect(Collectors.toList());
        ArcanaCodexHelper.renderItemList(screen, guiGraphics, items, left, top, mouseX, mouseY, vertical).run();
    }

    public static Runnable renderBufferedComponents(AbstractMalumScreen screen, class_332 guiGraphics, List<? extends IRecipeComponent> components, int left, int top, int mouseX, int mouseY, boolean vertical) {
        List<class_1799> items = components.stream().map(IRecipeComponent::getStack).collect(Collectors.toList());
        return ArcanaCodexHelper.renderItemList(screen, guiGraphics, items, left, top, mouseX, mouseY, vertical);
    }

    public static void renderComponent(AbstractMalumScreen screen, class_332 guiGraphics, IRecipeComponent component, int posX, int posY, int mouseX, int mouseY) {
        ArcanaCodexHelper.renderItem(screen, guiGraphics, component.getStacks(), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumScreen screen, class_332 guiGraphics, class_1856 ingredient, int posX, int posY, int mouseX, int mouseY) {
        ArcanaCodexHelper.renderItem(screen, guiGraphics, List.of(ingredient.method_8105()), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumScreen screen, class_332 guiGraphics, List<class_1799> stacks, int posX, int posY, int mouseX, int mouseY) {
        if (stacks.size() == 1) {
            ArcanaCodexHelper.renderItem(screen, guiGraphics, stacks.get(0), posX, posY, mouseX, mouseY);
            return;
        }
        int index = (int)(class_310.method_1551().field_1687.method_8510() % (20L * (long)stacks.size()) / 20L);
        class_1799 stack = stacks.get(index);
        ArcanaCodexHelper.renderItem(screen, guiGraphics, stack, posX, posY, mouseX, mouseY);
    }

    public static void renderItem(AbstractMalumScreen screen, class_332 guiGraphics, class_1799 stack, int posX, int posY, int mouseX, int mouseY) {
        if (!stack.method_7960()) {
            guiGraphics.method_51427(stack, posX, posY);
            guiGraphics.method_51432(class_310.method_1551().field_1772, stack, posX, posY, null);
            if (screen.isHovering(mouseX, mouseY, posX, posY, 16, 16)) {
                guiGraphics.method_51434(class_310.method_1551().field_1772, class_437.method_25408((class_310)class_310.method_1551(), (class_1799)stack), mouseX, mouseY);
            }
        }
    }

    public static Runnable renderItemList(AbstractMalumScreen screen, class_332 guiGraphics, List<class_1799> items, int left, int top, int mouseX, int mouseY, boolean vertical) {
        int slots = items.size();
        ArcanaCodexHelper.renderItemFrames(guiGraphics.method_51448(), slots, left, top, vertical);
        return () -> {
            int finalLeft = left;
            int finalTop = top;
            if (vertical) {
                finalTop -= 10 * (slots - 1);
            } else {
                finalLeft -= 10 * (slots - 1);
            }
            for (int i = 0; i < slots; ++i) {
                class_1799 stack = (class_1799)items.get(i);
                int offset = i * 20;
                int oLeft = finalLeft + 2 + (vertical ? 0 : offset);
                int oTop = finalTop + 2 + (vertical ? offset : 0);
                ArcanaCodexHelper.renderItem(screen, guiGraphics, stack, oLeft, oTop, mouseX, mouseY);
            }
        };
    }

    public static void renderItemFrames(class_4587 poseStack, int slots, int left, int top, boolean vertical) {
        int startingOffset = 10 * (slots - 1);
        if (vertical) {
            top -= startingOffset;
        } else {
            left -= startingOffset;
        }
        for (int i = 0; i < slots; ++i) {
            int offset = i * 20;
            int oLeft = left + (vertical ? 0 : offset);
            int oTop = top + (vertical ? offset : 0);
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, oLeft, oTop, 18.0f, 16.0f, 20, 20, 38, 44);
            if (vertical) {
                int v = i == slots - 1 ? 40 : 37;
                ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, oLeft + 1, oTop + 19, 16.0f, (float)v, 18, 2, 38, 44);
                continue;
            }
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, oLeft + 1, top + 19, 16.0f, 40.0f, 18, 2, 38, 44);
            if (slots <= 1 || i == slots - 1) continue;
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, oLeft + 19, top, 16.0f, 16.0f, 2, 20, 38, 44);
        }
        int crownLeft = left + 5 + (vertical ? 0 : startingOffset);
        ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, crownLeft, top - 5, 28.0f, 0.0f, 10, 6, 38, 44);
        if (vertical) {
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, left - 4, top - 4, 0.0f, 0.0f, 28, 7, 38, 44);
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, left - 4, top + 17 + 20 * (slots - 1), 0.0f, 8.0f, 28, 7, 38, 44);
        } else {
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, left - 4, top - 4, 0.0f, 16.0f, 7, 28, 38, 44);
            ArcanaCodexHelper.renderTexture(EntryScreen.ELEMENT_SOCKET, poseStack, left + 17 + 20 * (slots - 1), top - 4, 8.0f, 16.0f, 7, 28, 38, 44);
        }
    }

    public static class_5250 convertToComponent(String text) {
        return ArcanaCodexHelper.convertToComponent(text, UnaryOperator.identity());
    }

    public static class_5250 convertToComponent(String text, UnaryOperator<class_2583> styleModifier) {
        text = class_2561.method_43471((String)text).getString();
        class_5250 raw = class_2561.method_43473();
        boolean italic = false;
        boolean bold = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean obfuscated = false;
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char peek;
            char chr = text.charAt(i);
            if (chr == '$') {
                if (i != text.length() - 1) {
                    peek = text.charAt(i + 1);
                    switch (peek) {
                        case 'i': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            italic = true;
                            ++i;
                            break;
                        }
                        case 'b': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            bold = true;
                            ++i;
                            break;
                        }
                        case 's': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            strikethrough = true;
                            ++i;
                            break;
                        }
                        case 'u': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            underline = true;
                            ++i;
                            break;
                        }
                        case 'k': {
                            line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                            obfuscated = true;
                            ++i;
                            break;
                        }
                        default: {
                            line.append(chr);
                            break;
                        }
                    }
                    continue;
                }
                line.append(chr);
                continue;
            }
            if (chr == '/') {
                if (i != text.length() - 1) {
                    peek = text.charAt(i + 1);
                    if (peek == '$') {
                        line = ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
                        obfuscated = false;
                        underline = false;
                        strikethrough = false;
                        bold = false;
                        italic = false;
                        ++i;
                        continue;
                    }
                    line.append(chr);
                    continue;
                }
                line.append(chr);
                continue;
            }
            line.append(chr);
        }
        ArcanaCodexHelper.commitComponent(raw, italic, bold, strikethrough, underline, obfuscated, line, styleModifier);
        return raw;
    }

    public static void renderWrappingText(class_332 guiGraphics, String text, int x, int y, int w) {
        int i;
        class_327 font = class_310.method_1551().field_1772;
        text = class_2561.method_43471((String)text).getString() + "\n";
        ArrayList<String> lines = new ArrayList<String>();
        boolean italic = false;
        boolean bold = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean obfuscated = false;
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        for (i = 0; i < ((String)text).length(); ++i) {
            char chr = ((String)text).charAt(i);
            if (chr == ' ' || chr == '\n') {
                if (word.length() > 0) {
                    if (font.method_1727(line.toString()) + font.method_1727(word.toString()) > w) {
                        line = ArcanaCodexHelper.newLine(lines, italic, bold, strikethrough, underline, obfuscated, line);
                    }
                    line.append((CharSequence)word).append(' ');
                    word = new StringBuilder();
                }
                String noFormatting = class_124.method_539((String)line.toString());
                if (chr != '\n' || noFormatting == null) continue;
                line = ArcanaCodexHelper.newLine(lines, italic, bold, strikethrough, underline, obfuscated, line);
                continue;
            }
            if (chr == '$') {
                if (i != ((String)text).length() - 1) {
                    char peek = ((String)text).charAt(i + 1);
                    switch (peek) {
                        case 'i': {
                            word.append(class_124.field_1056);
                            italic = true;
                            ++i;
                            break;
                        }
                        case 'b': {
                            word.append(class_124.field_1067);
                            bold = true;
                            ++i;
                            break;
                        }
                        case 's': {
                            word.append(class_124.field_1055);
                            strikethrough = true;
                            ++i;
                            break;
                        }
                        case 'u': {
                            word.append(class_124.field_1073);
                            underline = true;
                            ++i;
                            break;
                        }
                        case 'k': {
                            word.append(class_124.field_1051);
                            obfuscated = true;
                            ++i;
                            break;
                        }
                        default: {
                            word.append(chr);
                            break;
                        }
                    }
                    continue;
                }
                word.append(chr);
                continue;
            }
            if (chr == '/') {
                if (i != ((String)text).length() - 1) {
                    char peek = ((String)text).charAt(i + 1);
                    if (peek == '$') {
                        obfuscated = false;
                        underline = false;
                        strikethrough = false;
                        bold = false;
                        italic = false;
                        word.append(class_124.field_1070);
                        ++i;
                        continue;
                    }
                    word.append(chr);
                    continue;
                }
                word.append(chr);
                continue;
            }
            word.append(chr);
        }
        for (i = 0; i < lines.size(); ++i) {
            String currentLine = (String)lines.get(i);
            Objects.requireNonNull(font);
            ArcanaCodexHelper.renderRawText(guiGraphics, currentLine, x, y + i * (9 + 1), ArcanaCodexHelper.getTextGlow((float)i / 4.0f));
        }
    }

    private static StringBuilder commitComponent(class_5250 component, boolean italic, boolean bold, boolean strikethrough, boolean underline, boolean obfuscated, StringBuilder line, UnaryOperator<class_2583> styleModifier) {
        component.method_10852((class_2561)class_2561.method_43470((String)line.toString()).method_27694(style -> style.method_10978(Boolean.valueOf(italic)).method_10982(Boolean.valueOf(bold)).method_36140(Boolean.valueOf(strikethrough)).method_30938(Boolean.valueOf(underline)).method_36141(Boolean.valueOf(obfuscated))).method_27694(styleModifier));
        line = new StringBuilder();
        return line;
    }

    private static StringBuilder newLine(List<String> lines, boolean italic, boolean bold, boolean strikethrough, boolean underline, boolean obfuscated, StringBuilder line) {
        lines.add(line.toString());
        line = new StringBuilder();
        if (italic) {
            line.append(class_124.field_1056);
        }
        if (bold) {
            line.append(class_124.field_1067);
        }
        if (strikethrough) {
            line.append(class_124.field_1055);
        }
        if (underline) {
            line.append(class_124.field_1073);
        }
        if (obfuscated) {
            line.append(class_124.field_1051);
        }
        return line;
    }

    public static void renderText(class_332 guiGraphics, String text, int x, int y) {
        ArcanaCodexHelper.renderText(guiGraphics, (class_2561)class_2561.method_43471((String)text), x, y, ArcanaCodexHelper.getTextGlow(0.0f));
    }

    public static void renderText(class_332 guiGraphics, class_2561 component, int x, int y) {
        String text = component.getString();
        ArcanaCodexHelper.renderRawText(guiGraphics, text, x, y, ArcanaCodexHelper.getTextGlow(0.0f));
    }

    public static void renderText(class_332 guiGraphics, String text, int x, int y, float glow) {
        ArcanaCodexHelper.renderText(guiGraphics, (class_2561)class_2561.method_43471((String)text), x, y, glow);
    }

    public static void renderText(class_332 guiGraphics, class_2561 component, int x, int y, float glow) {
        String text = component.getString();
        ArcanaCodexHelper.renderRawText(guiGraphics, text, x, y, glow);
    }

    private static void renderRawText(class_332 guiGraphics, String text, int x, int y, float glow) {
        class_327 font = class_310.method_1551().field_1772;
        if (((BookTheme)((Object)ClientConfig.BOOK_THEME.getConfigValue())).equals((Object)BookTheme.EASY_READING)) {
            guiGraphics.method_25303(font, text, x, y, 0);
            return;
        }
        glow = Easing.CUBIC_IN.ease(glow, 0.0f, 1.0f, 1.0f);
        int r = (int)class_3532.method_16439((float)glow, (float)163.0f, (float)227.0f);
        int g = (int)class_3532.method_16439((float)glow, (float)44.0f, (float)39.0f);
        int b = (int)class_3532.method_16439((float)glow, (float)191.0f, (float)228.0f);
        guiGraphics.method_51433(font, text, (int)((float)x - 1.0f), y, class_5253.class_5254.method_27764((int)96, (int)255, (int)210, (int)243), false);
        guiGraphics.method_51433(font, text, (int)((float)x + 1.0f), y, class_5253.class_5254.method_27764((int)128, (int)240, (int)131, (int)232), false);
        guiGraphics.method_51433(font, text, x, (int)((float)y - 1.0f), class_5253.class_5254.method_27764((int)128, (int)255, (int)183, (int)236), false);
        guiGraphics.method_51433(font, text, x, (int)((float)y + 1.0f), class_5253.class_5254.method_27764((int)96, (int)236, (int)110, (int)226), false);
        guiGraphics.method_51433(font, text, x, y, class_5253.class_5254.method_27764((int)255, (int)r, (int)g, (int)b), false);
    }

    public static float getTextGlow(float offset) {
        return class_3532.method_15374((float)(offset + (float)class_310.method_1551().field_1724.method_37908().method_8510() / 40.0f)) / 2.0f + 0.5f;
    }

    public static boolean isHovering(double mouseX, double mouseY, float posX, float posY, int width, int height) {
        return mouseX > (double)posX && mouseX < (double)(posX + (float)width) && mouseY > (double)posY && mouseY < (double)(posY + (float)height);
    }

    public static enum BookTheme {
        DEFAULT,
        EASY_READING;

    }
}

