/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity.bolt;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import java.awt.Color;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public abstract class AbstractBoltEntityRenderer<T extends AbstractBoltProjectileEntity>
extends class_897<T> {
    public final Color primaryColor;
    public final Color secondaryColor;
    private static final class_1921 TRAIL_TYPE = LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE_TRIANGLE.apply(RenderTypeToken.createCachedToken((class_2960)MalumMod.malumPath("textures/vfx/concentrated_trail.png")));

    public AbstractBoltEntityRenderer(class_5617.class_5618 context, Color primaryColor, Color secondaryColor) {
        super(context);
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.field_4673 = 0.0f;
        this.field_4672 = 0.0f;
    }

    public class_1921 getTrailRenderType() {
        return TRAIL_TYPE;
    }

    public float getAlphaMultiplier() {
        return 1.0f;
    }

    public void render(T entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int packedLightIn) {
        if (((AbstractBoltProjectileEntity)((Object)entity)).spawnDelay > 0) {
            return;
        }
        float effectScalar = ((AbstractBoltProjectileEntity)((Object)entity)).getVisualEffectScalar();
        float alphaScalar = class_3532.method_15363((float)(effectScalar * this.getAlphaMultiplier()), (float)0.0f, (float)1.0f);
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType(this.getTrailRenderType());
        RenderUtils.renderEntityTrail(poseStack, builder, ((AbstractBoltProjectileEntity)((Object)entity)).trailPointBuilder, entity, this.primaryColor, this.secondaryColor, effectScalar, alphaScalar, partialTicks);
        RenderUtils.renderEntityTrail(poseStack, builder, ((AbstractBoltProjectileEntity)((Object)entity)).spinningTrailPointBuilder, entity, this.primaryColor, this.secondaryColor, effectScalar, alphaScalar, partialTicks);
        super.method_3936(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public class_2960 getTextureLocation(T entity) {
        return class_1059.field_5275;
    }
}

