/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity;

import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.entity.FloatingItemEntity;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_918;
import team.lodestar.lodestone.helpers.EasingHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;

public class FloatingItemEntityRenderer
extends class_897<FloatingItemEntity> {
    public final class_918 itemRenderer;
    private static final LodestoneRenderType TRAIL_TYPE = LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE_TRIANGLE.applyAndCache(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
    private static final LodestoneRenderType TWINKLE = LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE.applyAndCache(MalumRenderTypeTokens.TWINKLE);
    private static final LodestoneRenderType STAR = LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE.applyAndCache(MalumRenderTypeTokens.STAR);

    public FloatingItemEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.itemRenderer = context.method_32168();
        this.field_4673 = 0.0f;
        this.field_4672 = 0.0f;
    }

    public void render(FloatingItemEntity entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int packedLightIn) {
        MalumSpiritType spiritType = entity.getSpiritType();
        VFXBuilders.WorldVFXBuilder trailBuilder = SpiritBasedWorldVFXBuilder.create(spiritType).setRenderType((class_1921)TRAIL_TYPE);
        RenderUtils.renderEntityTrail(poseStack, trailBuilder, entity.trailPointBuilder, (class_1297)entity, spiritType.getPrimaryColor(), spiritType.getSecondaryColor(), 1.0f, partialTicks);
        FloatingItemEntityRenderer.renderSpiritEntity(entity, this.itemRenderer, partialTicks, poseStack, bufferIn, packedLightIn);
        super.method_3936((class_1297)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public static void renderSpiritEntity(FloatingItemEntity entity, class_918 itemRenderer, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int packedLightIn) {
        class_1799 itemStack = entity.getItem();
        class_1087 model = itemRenderer.method_4019(itemStack, entity.method_37908(), null, entity.getItem().method_7947());
        float yOffset = entity.getYOffset(partialTicks);
        float scale = model.method_4709().method_3503((class_811)class_811.field_4318).field_4285.y();
        float rotation = entity.getRotation(partialTicks);
        poseStack.method_22903();
        poseStack.method_22904(0.0, (double)(yOffset - 0.25f * scale), 0.0);
        poseStack.method_22907(class_7833.field_40716.rotation(rotation));
        itemRenderer.method_23179(itemStack, class_811.field_4318, false, poseStack, bufferIn, packedLightIn, class_4608.field_21444, model);
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_22904(0.0, (double)yOffset, 0.0);
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, entity.getSpiritType(), partialTicks);
        poseStack.method_22909();
    }

    public static void renderSpiritGlimmer(class_4587 poseStack, MalumSpiritType spiritType, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, spiritType, 1.0f, partialTicks);
    }

    public static void renderSpiritGlimmer(class_4587 poseStack, MalumSpiritType spiritType, float scalar, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, SpiritBasedWorldVFXBuilder.create(spiritType), spiritType.getPrimaryColor(), spiritType.getSecondaryColor(), scalar, scalar, partialTicks);
    }

    public static void renderSpiritGlimmer(class_4587 poseStack, MalumSpiritType spiritType, float scaleScalar, float alphaScalar, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, SpiritBasedWorldVFXBuilder.create(spiritType), spiritType.getPrimaryColor(), spiritType.getSecondaryColor(), scaleScalar, alphaScalar, partialTicks);
    }

    public static void renderSpiritGlimmer(class_4587 poseStack, Color primaryColor, Color secondaryColor, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, primaryColor, secondaryColor, 1.0f, partialTicks);
    }

    public static void renderSpiritGlimmer(class_4587 poseStack, Color primaryColor, Color secondaryColor, float scalar, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, VFXBuilders.createWorld(), primaryColor, secondaryColor, scalar, scalar, partialTicks);
    }

    public static void renderSpiritGlimmer(class_4587 poseStack, Color primaryColor, Color secondaryColor, float scaleScalar, float alphaScalar, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, VFXBuilders.createWorld(), primaryColor, secondaryColor, scaleScalar, alphaScalar, partialTicks);
    }

    public static void renderSpiritGlimmer(class_4587 poseStack, VFXBuilders.WorldVFXBuilder builder, Color primaryColor, Color secondaryColor, float scaleScalar, float alphaScalar, float partialTicks) {
        class_638 level = class_310.method_1551().field_1687;
        float gameTime = (float)level.method_8510() + partialTicks;
        float sine = (float)Math.abs(Math.sin(gameTime / 80.0f % 360.0f) * (double)0.075f);
        float bounce = EasingHelper.weightedEasingLerp((Easing)Easing.BOUNCE_IN_OUT, (float)(gameTime % 20.0f / 20.0f), (float)0.025f, (float)0.05f, (float)0.025f);
        float scale = (0.12f + sine + bounce) * scaleScalar;
        poseStack.method_22903();
        poseStack.method_22907(class_310.method_1551().method_1561().method_24197());
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        builder.setAlpha(0.6f * alphaScalar).setColor(primaryColor).setRenderType((class_1921)STAR).renderQuad(poseStack, scale * 0.8f);
        builder.setAlpha(0.8f * alphaScalar).setRenderType((class_1921)TWINKLE).renderQuad(poseStack, scale * 0.6f);
        builder.setAlpha(0.2f * alphaScalar).setColor(secondaryColor).renderQuad(poseStack, scale * 0.6f);
        poseStack.method_22909();
    }

    public class_2960 getTextureLocation(FloatingItemEntity entity) {
        return class_1059.field_5275;
    }
}

