/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.void_depot.VoidDepotBlockEntity;
import com.sammy.malum.registry.client.RenderTypeRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneBufferWrapper;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class VoidDepotRenderer
implements class_827<VoidDepotBlockEntity> {
    private static final RenderTypeToken VIGNETTE = RenderTypeToken.createToken((class_2960)MalumMod.malumPath("textures/block/weeping_well/primordial_soup_vignette.png"));
    private static final RenderTypeToken NOISE_TEXTURE = RenderTypeToken.createToken((class_2960)MalumMod.malumPath("textures/vfx/void_noise.png"));
    private static final class_4597 ADDITIVE = new LodestoneBufferWrapper(LodestoneRenderTypeRegistry.ADDITIVE_TEXT, (class_4597)RenderHandler.LATE_DELAYED_RENDER.getTarget());
    private static final class_4597 TRANSPARENT = new LodestoneBufferWrapper(LodestoneRenderTypeRegistry.TRANSPARENT_TEXT, (class_4597)RenderHandler.DELAYED_RENDER.getTarget());

    public VoidDepotRenderer(class_5614.class_5615 context) {
    }

    public void render(VoidDepotBlockEntity blockEntityIn, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderQuad(blockEntityIn, poseStack, partialTicks);
    }

    public void renderQuad(VoidDepotBlockEntity voidDepot, class_4587 poseStack, float partialTicks) {
        float height = 0.9375f;
        float width = 0.3125f;
        Vector3f[] positions = new Vector3f[]{new Vector3f(-width, height, width), new Vector3f(width, height, width), new Vector3f(width, height, -width), new Vector3f(-width, height, -width)};
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld();
        poseStack.method_22903();
        poseStack.method_46416(0.5f, 0.01f, 0.5f);
        builder.replaceBufferSource((class_4597)RenderHandler.LATE_DELAYED_RENDER.getTarget()).setRenderType((class_1921)LodestoneRenderTypeRegistry.TRANSPARENT_TEXTURE.applyAndCache(VIGNETTE)).renderQuad(poseStack, positions, 1.0f);
        long gameTime = voidDepot.method_10997().method_8510();
        float uOffset = ((float)gameTime + partialTicks) % 4000.0f / 2000.0f;
        float vOffset = ((float)gameTime + 500.0f + partialTicks) % 8000.0f / 8000.0f;
        float alpha = 0.05f;
        LodestoneRenderType renderType = RenderTypeRegistry.ADDITIVE_DISTORTED_TEXTURE.applyAndCache(NOISE_TEXTURE);
        builder.replaceBufferSource((class_4597)RenderHandler.DELAYED_RENDER.getTarget());
        for (int i = 0; i < 2; ++i) {
            builder.setAlpha(alpha);
            float speed = 1000.0f + 250.0f * (float)i;
            builder.setColor(SpiritTypeRegistry.WICKED_SPIRIT.getPrimaryColor()).setRenderType((class_1921)LodestoneRenderTypeRegistry.applyUniformChanges((LodestoneRenderType)LodestoneRenderTypeRegistry.copyAndStore((Object)i, (LodestoneRenderType)renderType), s -> {
                s.method_35785("Speed").method_1251(speed);
                s.method_35785("Width").method_1251(16.0f);
                s.method_35785("Height").method_1251(16.0f);
                s.method_35785("UVEncasement").method_35652(new Vector4f(-10.0f, 20.0f, -10.0f, 20.0f));
            }));
            builder.setUV(-uOffset, vOffset, 1.0f - uOffset, 1.0f + vOffset).renderQuad(poseStack, positions, 1.0f);
            builder.setUV(uOffset, -vOffset, 1.0f + uOffset, 1.0f - vOffset).renderQuad(poseStack, positions, 1.0f);
            alpha -= 0.0125f;
            uOffset = -uOffset - 0.2f;
            vOffset = -vOffset + 0.4f;
            poseStack.method_46416(0.0f, 0.05f, 0.0f);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            if (i != 0) continue;
            builder.setColor(SpiritTypeRegistry.ELDRITCH_SPIRIT.getPrimaryColor());
        }
        poseStack.method_22909();
        if (voidDepot.textVisibility > 12.0f) {
            class_327 font = class_310.method_1551().field_1772;
            float timer = class_3532.method_15363((float)(voidDepot.textVisibility + (float)(voidDepot.nearTimer > 0 ? 1 : -1) * partialTicks), (float)0.0f, (float)40.0f);
            float scalar = Easing.SINE_IN_OUT.ease(timer / 40.0f, 0.0f, 1.0f, 1.0f);
            float scale = 0.016f - (1.0f - scalar) * 0.004f;
            class_327.class_6415 display = class_327.class_6415.field_33993;
            List<VoidDepotBlockEntity.VoidDepotGoal> goals = voidDepot.goals;
            List components = new ArrayList<class_5250>();
            if (!voidDepot.goals.isEmpty()) {
                components = goals.stream().map(g -> class_2561.method_43470((String)(g.index + ": <" + g.deliveredAmount + "/" + g.amount + ">"))).collect(Collectors.toCollection(ArrayList::new));
            }
            components.addAll(voidDepot.textToDisplay.stream().map(class_2561::method_43470).toList());
            poseStack.method_22903();
            poseStack.method_46416(0.5f, 2.0f, 0.5f);
            poseStack.method_22907(class_310.method_1551().method_1561().method_24197());
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            for (int i = 0; i < components.size(); ++i) {
                for (int j = 0; j < 2; ++j) {
                    class_5250 text = ((class_5250)components.get(i)).method_27661();
                    boolean isAdditive = j == 0;
                    class_4597 bufferToUse = isAdditive ? ADDITIVE : TRANSPARENT;
                    class_5250 outlineText = text.method_27661();
                    text.method_27694(isAdditive ? style -> style.method_27703(class_5251.method_27717((int)SpiritTypeRegistry.WICKED_SPIRIT.getPrimaryColor().getRGB())) : style -> style.method_27703(class_5251.method_27717((int)new Color(50, 0, 50).getRGB())));
                    outlineText.method_27692(isAdditive ? class_124.field_1061 : class_124.field_1074);
                    poseStack.method_22903();
                    Matrix4f pose = poseStack.method_23760().method_23761();
                    poseStack.method_46416(0.0f, (float)i * 0.15f, 0.0f);
                    if (isAdditive) {
                        poseStack.method_46416(0.0f, 0.0f, 0.05f);
                    }
                    poseStack.method_22905(scale, -scale, -scale);
                    float offset = isAdditive ? 0.4f : 0.8f;
                    float f = (float)(-font.method_27525((class_5348)text)) / 2.0f;
                    float xPos = 0.0f + f;
                    int color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((isAdditive ? 0.3f : 0.9f) * scalar));
                    font.method_30882((class_2561)text, xPos, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((isAdditive ? 0.15f : 0.7f) * scalar));
                    font.method_30882((class_2561)text, xPos - offset, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.method_30882((class_2561)text, xPos - offset, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.method_30882((class_2561)text, xPos, offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.method_30882((class_2561)text, xPos, -offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((isAdditive ? 0.1f : 0.5f) * scalar));
                    font.method_30882((class_2561)text, xPos - 2.0f * offset, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.method_30882((class_2561)outlineText, xPos + 2.0f * offset, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.method_30882((class_2561)outlineText, xPos, 2.0f * offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.method_30882((class_2561)text, xPos, -2.0f * offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.method_30882((class_2561)outlineText, xPos - offset, -offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.method_30882((class_2561)text, xPos - offset, offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.method_30882((class_2561)outlineText, xPos + offset, offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.method_30882((class_2561)text, xPos + offset, -offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    poseStack.method_22909();
                }
            }
            poseStack.method_22909();
        }
    }
}

