/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.awt.Color;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Vector3f;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class TotemPoleRenderer
implements class_827<TotemPoleBlockEntity> {
    public TotemPoleRenderer(class_5614.class_5615 context) {
    }

    public void render(TotemPoleBlockEntity blockEntityIn, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        class_2350 direction = (class_2350)blockEntityIn.method_11010().method_11654((class_2769)class_2741.field_12481);
        MalumSpiritType spiritType = blockEntityIn.type;
        if (spiritType == null) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        LodestoneRenderType renderType = LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE.applyAndCache(RenderTypeToken.createCachedToken((class_2960)spiritType.getTotemGlowTexture()));
        poseStack.method_22903();
        poseStack.method_46416(0.5f, 0.5f, 0.5f);
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(direction.method_10144()));
        poseStack.method_46416(-0.5f, -0.5f, -0.5f);
        float pct = (float)blockEntityIn.chargeProgress / 20.0f;
        Color color = spiritType.getPrimaryColor();
        float alphaBonus = pct * 0.5f;
        float alpha = pct * 0.2f + alphaBonus;
        float ease = Easing.SINE_OUT.ease(pct, 0.0f, 1.0f, 1.0f);
        float distance = 0.2f - ease * 0.2f;
        float wobbleStrength = 0.1f - ease * 0.075f;
        Vector3f[] positions = new Vector3f[]{new Vector3f(-0.025f, -0.025f, 1.01f), new Vector3f(1.025f, -0.025f, 1.01f), new Vector3f(1.025f, 1.025f, 1.01f), new Vector3f(-0.025f, 1.025f, 1.01f)};
        float gameTime = (float)level.method_8510() + partialTicks;
        int time = 160;
        for (int i = 0; i < 4; ++i) {
            TotemPoleRenderer.applyWobble(positions, wobbleStrength);
            double translation = 0.0;
            if (distance > 0.0f) {
                boolean odd = i % 2 == 0;
                double angle = (double)((float)i / 4.0f) * (Math.PI * 2);
                double offset = (double)distance * Math.cos(angle += (double)(gameTime % (float)time / (float)time) * (Math.PI * 2));
                translation = odd ? -offset : offset;
            }
            poseStack.method_22904(translation, 0.0, 0.0);
            SpiritBasedWorldVFXBuilder.create(spiritType).setColor(color, alpha).setRenderType((class_1921)renderType).renderQuad(poseStack, positions, 1.0f);
            poseStack.method_22904(-translation, 0.0, 0.0);
            alpha *= 1.0f - alphaBonus;
        }
        poseStack.method_22909();
    }

    public static void applyWobble(Vector3f[] offsets, float strength) {
        float offset = 0.0f;
        for (Vector3f vector3f : offsets) {
            double time = (double)((float)class_310.method_1551().field_1687.method_8510() / 40.0f) % Math.PI * 2.0;
            float sine = class_3532.method_15374((float)((float)(time + (double)offset * Math.PI * 2.0))) * strength;
            vector3f.add(sine, -sine, 0.0f);
            offset += 0.25f;
        }
    }
}

