/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.common.spiritrite.TotemicRiteEffect;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.RenderTypeRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_827;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class TotemBaseRenderer
implements class_827<TotemBaseBlockEntity> {
    public static final RenderTypeToken AREA_COVERAGE_TEXTURE = RenderTypeToken.createToken((class_2960)MalumMod.malumPath("textures/vfx/area_coverage.png"));
    private static float totemicStaffHeldTimer = 0.0f;
    private static boolean isHoldingStaff;

    public TotemBaseRenderer(class_5614.class_5615 context) {
    }

    public static void checkForTotemicStaff(class_310 minecraft) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1792 totemicStaff = (class_1792)ItemRegistry.TOTEMIC_STAFF.get();
        if (player.method_6047().method_7909().equals(totemicStaff) || player.method_6079().method_7909().equals(totemicStaff)) {
            if (totemicStaffHeldTimer < 20.0f) {
                totemicStaffHeldTimer += 1.0f;
            }
            isHoldingStaff = true;
        } else if (totemicStaffHeldTimer > 0.0f) {
            totemicStaffHeldTimer -= 1.0f;
            isHoldingStaff = false;
        }
    }

    public void render(TotemBaseBlockEntity blockEntityIn, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (totemicStaffHeldTimer > 0.0f) {
            int height;
            if (blockEntityIn.cachedRadiusRite == null) {
                return;
            }
            float staffTimer = class_3532.method_15363((float)(totemicStaffHeldTimer + (float)(isHoldingStaff ? 1 : -1) * partialTicks), (float)0.0f, (float)20.0f);
            float totemTimer = class_3532.method_15363((float)((float)blockEntityIn.radiusVisibility + (float)(blockEntityIn.isActiveOrAssembling() ? 1 : -1) * partialTicks), (float)0.0f, (float)40.0f);
            float scalar = Easing.SINE_IN_OUT.ease(staffTimer / 20.0f, 0.0f, 1.0f, 1.0f) * Easing.SINE_IN_OUT.ease(totemTimer / 40.0f, 0.0f, 1.0f, 1.0f);
            MalumSpiritType spiritType = blockEntityIn.cachedRadiusRite.getIdentifyingSpirit();
            TotemicRiteEffect riteEffect = blockEntityIn.cachedRadiusRite.getRiteEffect(blockEntityIn.isSoulwood);
            class_2338 riteEffectCenter = riteEffect.getRiteEffectCenter(blockEntityIn);
            class_2338 offset = riteEffectCenter.method_10059((class_2382)blockEntityIn.method_11016());
            int width = riteEffect.getRiteEffectHorizontalRadius();
            if (width > 1) {
                width = width * 2 + 1;
            }
            if ((height = riteEffect.getRiteEffectVerticalRadius()) > 1) {
                height = height * 2 + 1;
            }
            float shaderWidth = width * 32;
            float shaderHeight = height * 32;
            float distortion = 6.0f + (float)height / 2.0f;
            float sideDistortion = 6.0f + (float)width / 2.0f;
            LodestoneRenderType renderType = RenderTypeRegistry.ADDITIVE_DISTORTED_TEXTURE.applyWithModifierAndCache(AREA_COVERAGE_TEXTURE, b -> b.setCullState(LodestoneRenderTypeRegistry.NO_CULL));
            float index = shaderWidth + distortion;
            float sideIndex = shaderWidth * shaderHeight + sideDistortion;
            VFXBuilders.WorldVFXBuilder builder = SpiritBasedWorldVFXBuilder.create(spiritType).setRenderType((class_1921)LodestoneRenderTypeRegistry.applyUniformChanges((LodestoneRenderType)LodestoneRenderTypeRegistry.copyAndStore((Object)Float.valueOf(index), (LodestoneRenderType)renderType), s -> {
                s.method_35785("Speed").method_1251(1500.0f);
                s.method_35785("Distortion").method_1251(distortion);
                s.method_35785("Width").method_1251(shaderWidth);
                s.method_35785("Height").method_1251(shaderWidth);
            })).setColor(spiritType.getPrimaryColor(), 0.7f * scalar);
            VFXBuilders.WorldVFXBuilder sideBuilder = SpiritBasedWorldVFXBuilder.create(spiritType).setRenderType((class_1921)LodestoneRenderTypeRegistry.applyUniformChanges((LodestoneRenderType)LodestoneRenderTypeRegistry.copyAndStore((Object)Float.valueOf(sideIndex), (LodestoneRenderType)renderType), s -> {
                s.method_35785("Speed").method_1251(1500.0f);
                s.method_35785("Distortion").method_1251(sideDistortion);
                s.method_35785("Width").method_1251(shaderWidth);
                s.method_35785("Height").method_1251(shaderHeight);
            })).setColor(spiritType.getPrimaryColor(), 0.7f * scalar);
            poseStack.method_22903();
            poseStack.method_46416((float)offset.method_10263(), (float)offset.method_10264(), (float)offset.method_10260());
            RenderUtils.CubeVertexData cubeVertexData = RenderUtils.makeCubePositions(width, height).applyWobble(0.0f, 0.5f, 0.01f);
            RenderUtils.CubeVertexData inverse = RenderUtils.makeCubePositions(-width, -height).applyWobble(0.0f, 0.5f, 0.01f);
            RenderUtils.drawCube(poseStack, builder, sideBuilder, 1.05f, cubeVertexData);
            builder.setUV(0.0f, 1.0f, 1.0f, 0.0f).setColor(spiritType.getSecondaryColor(), 0.6f * scalar);
            sideBuilder.setUV(0.0f, 1.0f, 1.0f, 0.0f).setColor(spiritType.getSecondaryColor(), 0.6f * scalar);
            RenderUtils.drawCube(poseStack, builder, sideBuilder, 1.05f, inverse);
            poseStack.method_22909();
        }
    }
}

