/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.sammy.malum.client.renderer.entity.FloatingItemEntityRenderer;
import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleTuning;
import com.sammy.malum.common.block.curiosities.spirit_crucible.SpiritCrucibleCoreBlockEntity;
import com.sammy.malum.common.item.augment.AbstractAugmentItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneBufferWrapper;

public class SpiritCrucibleRenderer
implements class_827<SpiritCrucibleCoreBlockEntity> {
    private static float tuningForkHeldTimer = 0.0f;
    private static boolean isHoldingFork;
    private static final class_4597 TEXT;

    public SpiritCrucibleRenderer(class_5614.class_5615 context) {
    }

    public static void checkForTuningFork(class_310 minecraft) {
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return;
        }
        class_1792 tuningFork = (class_1792)ItemRegistry.TUNING_FORK.get();
        if (player.method_6047().method_7909().equals(tuningFork) || player.method_6079().method_7909().equals(tuningFork)) {
            if (tuningForkHeldTimer < 20.0f) {
                tuningForkHeldTimer += 1.0f;
            }
            isHoldingFork = true;
        } else if (tuningForkHeldTimer > 0.0f) {
            tuningForkHeldTimer -= 1.0f;
            isHoldingFork = false;
        }
    }

    public void render(SpiritCrucibleCoreBlockEntity blockEntityIn, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        class_1799 stack;
        class_638 level = class_310.method_1551().field_1687;
        class_918 itemRenderer = class_310.method_1551().method_1480();
        LodestoneBlockEntityInventory inventory = blockEntityIn.spiritInventory;
        int spiritsRendered = 0;
        if (!inventory.isEmpty()) {
            for (int i = 0; i < inventory.slotCount; ++i) {
                class_1799 item = inventory.getStackInSlot(i);
                class_1792 class_17922 = item.method_7909();
                if (!(class_17922 instanceof SpiritShardItem)) continue;
                SpiritShardItem shardItem = (SpiritShardItem)class_17922;
                poseStack.method_22903();
                Vector3f offset = blockEntityIn.getSpiritItemOffset(spiritsRendered++, partialTicks).method_46409();
                poseStack.method_46416(offset.x(), offset.y(), offset.z());
                FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, shardItem.type, partialTicks);
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(((float)(level.method_8510() % 360L) + partialTicks) * 3.0f));
                poseStack.method_22905(0.5f, 0.5f, 0.5f);
                itemRenderer.method_23178(item, class_811.field_4319, combinedLightIn, class_4608.field_21444, poseStack, bufferIn, (class_1937)level, 0);
                poseStack.method_22909();
            }
        }
        if (!(stack = blockEntityIn.inventory.getStackInSlot(0)).method_7960()) {
            poseStack.method_22903();
            class_243 offset = blockEntityIn.getCentralItemOffset();
            poseStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(((float)(level.method_8510() % 360L) + partialTicks) * 3.0f));
            poseStack.method_22905(0.45f, 0.45f, 0.45f);
            itemRenderer.method_23178(stack, class_811.field_4319, combinedLightIn, class_4608.field_21444, poseStack, bufferIn, (class_1937)level, 0);
            poseStack.method_22909();
        }
        LodestoneBlockEntityInventory augmentInventory = blockEntityIn.augmentInventory;
        int augmentsRendered = 0;
        if (!augmentInventory.isEmpty()) {
            float total = augmentInventory.slotCount;
            float time = 240.0f;
            int i = 0;
            while ((float)i < total) {
                class_1799 item = augmentInventory.getStackInSlot(i);
                if (item.method_7909() instanceof AbstractAugmentItem) {
                    double angle = (double)((float)augmentsRendered / total) * (Math.PI * 2);
                    poseStack.method_22903();
                    Vector3f offset = blockEntityIn.getAugmentItemOffset(augmentsRendered++, partialTicks).method_46409();
                    poseStack.method_46416(offset.x(), offset.y(), offset.z());
                    poseStack.method_22907(class_7833.field_40716.rotation((float)(angle -= (double)((float)((long)(blockEntityIn.spiritSpin + partialTicks)) % time / time) * (Math.PI * 2)) - (i % 2 == 0 ? 4.71f : 1.57f)));
                    poseStack.method_22905(0.5f, 0.5f, 0.5f);
                    itemRenderer.method_23178(item, class_811.field_4319, combinedLightIn, class_4608.field_21444, poseStack, bufferIn, (class_1937)level, 0);
                    poseStack.method_22909();
                }
                ++i;
            }
        }
        if (tuningForkHeldTimer > 5.0f) {
            class_327 font = class_310.method_1551().field_1772;
            float timer = class_3532.method_15363((float)(tuningForkHeldTimer + (float)(isHoldingFork ? 1 : -1) * partialTicks), (float)0.0f, (float)20.0f);
            float scalar = Easing.SINE_IN_OUT.ease(timer / 20.0f, 0.0f, 1.0f, 1.0f);
            float scale = 0.016f - (1.0f - scalar) * 0.004f;
            class_327.class_6415 display = class_327.class_6415.field_33993;
            List<CrucibleTuning.CrucibleAttributeType> validValues = CrucibleTuning.CrucibleAttributeType.getValidValues(blockEntityIn.acceleratorData);
            poseStack.method_22903();
            poseStack.method_46416(0.5f, 2.0f, 0.55f);
            poseStack.method_22907(class_310.method_1551().method_1561().method_24197());
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            for (int i = 0; i < validValues.size(); ++i) {
                CrucibleTuning.CrucibleAttributeType tuningType = validValues.get(i);
                String dataPrint = tuningType.statDisplayFunction.apply(blockEntityIn.getAccelerationData());
                boolean important = tuningType.equals((Object)blockEntityIn.tuningType);
                class_5250 dataText = class_2561.method_43470((String)(" <" + dataPrint + ">"));
                class_5250 text = class_2561.method_43471((String)tuningType.translation());
                class_5250 outlineText = class_2561.method_43471((String)tuningType.translation());
                if (important) {
                    dataText.method_27692(class_124.field_1067);
                    text = class_2561.method_43470((String)"[").method_10852((class_2561)text).method_10852((class_2561)class_2561.method_43470((String)"]")).method_27692(class_124.field_1067);
                    outlineText = class_2561.method_43470((String)"[").method_10852((class_2561)outlineText).method_10852((class_2561)class_2561.method_43470((String)"]")).method_27692(class_124.field_1067);
                }
                text.method_10852((class_2561)dataText).method_27692(class_124.field_1075);
                outlineText.method_10852((class_2561)dataText).method_27692(class_124.field_1076);
                poseStack.method_22903();
                poseStack.method_46416(0.0f, (float)i * 0.15f, 0.0f);
                poseStack.method_22905(scale, -scale, -scale);
                Matrix4f pose = poseStack.method_23760().method_23761();
                float f = (float)(-font.method_27525((class_5348)text)) / 2.0f;
                float xPos = 0.0f + f;
                int color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.38f * scalar));
                font.method_30882((class_2561)text, xPos, 0.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.18f * scalar));
                font.method_30882((class_2561)text, xPos - 0.5f, 0.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.method_30882((class_2561)text, xPos - 0.5f, 0.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.method_30882((class_2561)text, xPos, 0.5f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.method_30882((class_2561)text, xPos, -0.5f, color, false, pose, TEXT, display, 0, 0xF000F0);
                color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.12f * scalar));
                font.method_30882((class_2561)text, xPos - 1.0f, 0.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.method_30882((class_2561)outlineText, xPos + 1.0f, 0.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.method_30882((class_2561)outlineText, xPos, 1.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.method_30882((class_2561)text, xPos, -1.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.method_30882((class_2561)outlineText, xPos - 0.5f, -0.5f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.method_30882((class_2561)text, xPos - 0.5f, 0.5f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.method_30882((class_2561)outlineText, xPos + 0.5f, 0.5f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.method_30882((class_2561)text, xPos + 0.5f, -0.5f, color, false, pose, TEXT, display, 0, 0xF000F0);
                poseStack.method_22909();
            }
            poseStack.method_22909();
        }
    }

    static {
        TEXT = new LodestoneBufferWrapper(LodestoneRenderTypeRegistry.ADDITIVE_TEXT, (class_4597)RenderHandler.DELAYED_RENDER.getTarget());
    }
}

