/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.ritual_plinth.RitualPlinthBlockEntity;
import com.sammy.malum.common.entity.nitrate.EthericNitrateEntity;
import com.sammy.malum.core.systems.ritual.MalumRitualTier;
import com.sammy.malum.core.systems.ritual.MalumRitualType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class RitualPlinthRenderer
implements class_827<RitualPlinthBlockEntity> {
    public static final RenderTypeToken INCOMPLETE_RITUAL = RenderTypeToken.createToken((class_2960)MalumMod.malumPath("textures/vfx/ritual/incomplete_ritual.png"));
    public static final RenderTypeToken SILHOUETTE = RenderTypeToken.createToken((class_2960)MalumMod.malumPath("textures/vfx/ritual/silhouette.png"));

    public RitualPlinthRenderer(class_5614.class_5615 context) {
    }

    public void render(RitualPlinthBlockEntity blockEntityIn, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        class_638 level = class_310.method_1551().field_1687;
        class_918 itemRenderer = class_310.method_1551().method_1480();
        class_1799 stack = blockEntityIn.inventory.getStackInSlot(0);
        if (!stack.method_7960()) {
            poseStack.method_22903();
            class_243 offset = blockEntityIn.getCentralItemOffset();
            poseStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(((float)(level.method_8510() % 360L) + partialTicks) * 3.0f));
            poseStack.method_22905(0.45f, 0.45f, 0.45f);
            itemRenderer.method_23178(stack, class_811.field_4319, combinedLightIn, class_4608.field_21444, poseStack, bufferIn, (class_1937)level, 0);
            poseStack.method_22909();
        }
        MalumRitualType ritualType = blockEntityIn.ritualType;
        MalumRitualTier ritualTier = blockEntityIn.ritualTier;
        if (blockEntityIn.activeDuration > 0.0f && ritualType != null) {
            boolean hasDecor = ritualTier != null && !MalumRitualTier.FADED.equals(ritualTier);
            LodestoneRenderType silhouette = LodestoneRenderTypeRegistry.TRANSPARENT_TEXTURE.applyAndCache(SILHOUETTE);
            LodestoneRenderType icon = LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE.applyAndCache(ritualTier == null ? INCOMPLETE_RITUAL : RenderTypeToken.createCachedToken((class_2960)ritualType.getIcon()));
            LodestoneRenderType decorGlow = hasDecor ? LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE.applyAndCache(RenderTypeToken.createCachedToken((class_2960)ritualTier.getDecorTexture())) : null;
            LodestoneRenderType decorSilhouette = hasDecor ? LodestoneRenderTypeRegistry.TRANSPARENT_TEXTURE.applyAndCache(RenderTypeToken.createCachedToken((class_2960)ritualTier.getDecorTexture())) : null;
            MalumSpiritType spirit = ritualType.spirit;
            class_243 offset = blockEntityIn.getRitualIconOffset(partialTicks);
            float scalar = Math.min(blockEntityIn.activeDuration, 15.0f) / 15.0f;
            float alpha = 0.9f * scalar;
            float scale = 0.25f * (1.0f + scalar);
            VFXBuilders.WorldVFXBuilder worldVFXBuilder = VFXBuilders.createWorld().replaceBufferSource(RenderHandler.LATE_DELAYED_RENDER).setColor(spirit.getPrimaryColor()).setAlpha(alpha);
            VFXBuilders.WorldVFXBuilder backgroundBuilder = VFXBuilders.createWorld().setColor(EthericNitrateEntity.SECOND_SMOKE_COLOR).setAlpha(0.4f * scalar);
            poseStack.method_22903();
            poseStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
            poseStack.method_22907(class_310.method_1551().method_1561().method_24197());
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            worldVFXBuilder.setRenderType((class_1921)icon).renderQuad(poseStack, scale);
            if (hasDecor) {
                worldVFXBuilder.setRenderType((class_1921)decorGlow).renderQuad(poseStack, scale * 2.5f);
            }
            float gameTime = (float)level.method_8510() + partialTicks;
            int time = 160;
            float distance = 0.01f;
            for (int i = 0; i < 8; ++i) {
                boolean odd = i % 2 == 0;
                double angle = (double)((float)i / 8.0f) * (Math.PI * 2);
                double xOffset = (double)distance * Math.cos(angle += (double)(gameTime % (float)time / (float)time) * (Math.PI * 2));
                double zOffset = (double)distance * Math.sin(angle);
                poseStack.method_22904(xOffset, zOffset / 2.0, zOffset);
                worldVFXBuilder.setRenderType((class_1921)icon).setAlpha(alpha * ((float)i / 8.0f)).renderQuad(poseStack, scale);
                backgroundBuilder.setRenderType((class_1921)silhouette).renderQuad(poseStack, scale * (odd ? 0.8f : 1.2f));
                if (hasDecor) {
                    worldVFXBuilder.setRenderType((class_1921)decorGlow).renderQuad(poseStack, scale * 2.5f);
                    backgroundBuilder.setRenderType((class_1921)decorSilhouette).renderQuad(poseStack, scale * (odd ? 2.1f : 2.7f));
                }
                poseStack.method_22904(-xOffset, -zOffset / 2.0, -zOffset);
                if (i == 4) {
                    worldVFXBuilder.setColor(spirit.getSecondaryColor());
                    alpha *= 0.5f;
                }
                distance += 0.0125f;
            }
            poseStack.method_22909();
        }
    }
}

