/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.model;

import com.google.common.collect.ImmutableList;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.item.curiosities.trinkets.runes.AbstractRuneTrinketsItem;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.RenderTypeRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1304;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_572;
import net.minecraft.class_630;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.model.LodestoneArmorModel;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class MalignantStrongholdArmorModel
extends LodestoneArmorModel {
    public static final class_5601 LAYER = new class_5601(MalumMod.malumPath("malignant_lead_armor"), "main");
    public static final RenderTypeToken GLOW_TEXTURE = RenderTypeToken.createToken((class_2960)MalumMod.malumPath("textures/armor/malignant_stronghold_glow.png"));
    private final class_630 right_arm_glow;
    private final class_630 left_arm_glow;
    private final class_630 right_boot_glow;
    private final class_630 left_boot_glow;
    private final class_630 helmet_glow;
    private final class_630 torso_glow;
    private final List<MalumSpiritType> activeGlows = new ArrayList<MalumSpiritType>();

    public MalignantStrongholdArmorModel(class_630 root) {
        super(root);
        this.right_arm_glow = root.method_32086("right_arm_glow");
        this.left_arm_glow = root.method_32086("left_arm_glow");
        this.right_boot_glow = root.method_32086("right_boot_glow");
        this.left_boot_glow = root.method_32086("left_boot_glow");
        this.helmet_glow = root.method_32086("helmet_glow");
        this.torso_glow = root.method_32086("torso_glow");
    }

    protected List<class_630> getGlowingParts() {
        if (this.slot == class_1304.field_6174) {
            return ImmutableList.of((Object)this.torso_glow, (Object)this.left_arm_glow, (Object)this.right_arm_glow);
        }
        if (this.slot == class_1304.field_6169) {
            return ImmutableList.of((Object)this.helmet_glow);
        }
        return this.slot == class_1304.field_6166 ? ImmutableList.of((Object)this.left_boot_glow, (Object)this.right_boot_glow) : ImmutableList.of();
    }

    public void updateGlow(List<AbstractRuneTrinketsItem> runes) {
        this.activeGlows.clear();
        this.activeGlows.addAll(runes.stream().map(r -> r.spiritType).toList());
    }

    public static Color colorLerp(Easing easing, float pct, float[] hsv1, float[] hsv2) {
        pct = class_3532.method_15363((float)pct, (float)0.0f, (float)1.0f);
        float ease = easing.ease(pct, 0.0f, 1.0f, 1.0f);
        float h = class_3532.method_17821((float)ease, (float)(360.0f * hsv1[0]), (float)(360.0f * hsv2[0])) / 360.0f;
        float s = class_3532.method_16439((float)ease, (float)hsv1[1], (float)hsv2[1]);
        float v = class_3532.method_16439((float)ease, (float)hsv1[2], (float)hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)class_5253.class_5254.method_27765((int)packed) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)packed) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)packed) / 255.0f;
        return new Color(r, g, b);
    }

    public static Color multicolorLerp(Easing easing, float pct, List<Color> colors) {
        pct = class_3532.method_15363((float)pct, (float)0.0f, (float)1.0f);
        int colorCount = colors.size() - 1;
        float lerp = easing.ease(pct, 0.0f, 1.0f, 1.0f);
        float colorIndex = (float)colorCount * lerp;
        int index = (int)class_3532.method_15363((float)colorIndex, (float)0.0f, (float)colorCount);
        Color color = colors.get(index);
        Color nextColor = index == colorCount ? color : colors.get(index + 1);
        float[] hsv1 = new float[3];
        float[] hsv2 = new float[3];
        Color.RGBtoHSB(Math.min(255, color.getRed()), Math.min(255, color.getGreen()), Math.min(255, color.getBlue()), hsv1);
        Color.RGBtoHSB(Math.min(255, nextColor.getRed()), Math.min(255, nextColor.getGreen()), Math.min(255, nextColor.getBlue()), hsv2);
        return MalignantStrongholdArmorModel.colorLerp(easing, colorIndex - (float)((int)colorIndex), hsv1, hsv2);
    }

    public void method_2828(class_4587 pPoseStack, class_4588 pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        super.method_2828(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        if (!this.field_3448 && !this.activeGlows.isEmpty()) {
            List<class_630> glowingParts = this.getGlowingParts();
            if (glowingParts.isEmpty()) {
                return;
            }
            pPoseStack.method_22903();
            class_310 minecraft = class_310.method_1551();
            float realPartialTick = minecraft.field_1734 ? minecraft.field_1741 : minecraft.field_1728.field_1970;
            float gameTime = (float)class_310.method_1551().field_1687.method_8510() + realPartialTick;
            Color primaryColor = this.activeGlows.get(0).getPrimaryColor();
            Color secondaryColor = this.activeGlows.get(0).getSecondaryColor();
            float colorCoefficient = this.activeGlows.get(0).getColorCoefficient();
            if (this.activeGlows.size() > 1) {
                this.activeGlows.add(this.activeGlows.get(0));
                float loopTime = 100 * this.activeGlows.size();
                float pct = gameTime % loopTime / loopTime;
                float relative = pct * (float)this.activeGlows.size();
                primaryColor = MalignantStrongholdArmorModel.multicolorLerp(Easing.LINEAR, pct, this.activeGlows.stream().map(MalumSpiritType::getPrimaryColor).collect(Collectors.toList()));
                secondaryColor = MalignantStrongholdArmorModel.multicolorLerp(Easing.LINEAR, pct, this.activeGlows.stream().map(MalumSpiritType::getSecondaryColor).collect(Collectors.toList()));
                colorCoefficient = this.activeGlows.size() == 1 ? this.activeGlows.get(0).getColorCoefficient() : class_3532.method_16439((float)(relative % (float)this.activeGlows.size()), (float)this.activeGlows.get((int)relative).getColorCoefficient(), (float)this.activeGlows.get(Math.min((int)relative + 1, this.activeGlows.size() - 1)).getColorCoefficient());
            }
            class_4588 transparent = RenderHandler.DELAYED_RENDER.getTarget().getBuffer((class_1921)LodestoneRenderTypeRegistry.TRANSPARENT_TEXTURE.applyAndCache(GLOW_TEXTURE));
            class_4588 additive = RenderHandler.DELAYED_RENDER.getTarget().getBuffer((class_1921)RenderTypeRegistry.MALIGNANT_GLOW.applyAndCache(GLOW_TEXTURE));
            float distance = 0.06f;
            float alpha = 0.25f;
            int time = 320;
            for (class_630 glowingPart : glowingParts) {
                glowingPart.method_22699(pPoseStack, transparent, pPackedLight, pPackedOverlay, (float)primaryColor.getRed() / 255.0f, (float)primaryColor.getGreen() / 255.0f, (float)primaryColor.getBlue() / 255.0f, 0.6f);
            }
            for (int i = 0; i < 8; ++i) {
                double angle = (double)((float)i / 4.0f) * (Math.PI * 2);
                angle += (double)(gameTime % (float)time / (float)time) * (Math.PI * 2);
                for (class_630 glowingPart : glowingParts) {
                    double sin = Math.sin(angle);
                    Color color = ColorHelper.colorLerp((Easing)Easing.SINE_IN, (float)Math.min(1.0f, (float)i / 2.0f / colorCoefficient), (Color)secondaryColor, (Color)primaryColor);
                    float yaw = glowingPart.field_3675;
                    float pitch = -glowingPart.field_3654;
                    if (glowingPart.equals(this.helmet_glow)) {
                        yaw += 1.57f;
                    }
                    class_243 forward = new class_243(-Math.cos(yaw), 0.0, Math.sin(yaw));
                    if (!glowingPart.equals(this.helmet_glow)) {
                        class_243 direction = new class_243(Math.cos(yaw) * Math.cos(pitch), Math.sin(yaw) * Math.cos(pitch), Math.sin(pitch));
                        forward = forward.method_1036(direction).method_1031(0.0, 1.0, 0.0);
                    }
                    class_243 offset = forward.method_1037(pitch).method_1029().method_1021((double)distance * sin);
                    pPoseStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
                    glowingPart.method_22699(pPoseStack, additive, 0xF000F0, pPackedOverlay, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha);
                    pPoseStack.method_22904(-offset.field_1352, -offset.field_1351, -offset.field_1350);
                }
                if (i != 3) continue;
                distance *= 2.5f;
                alpha *= 0.35f;
            }
            pPoseStack.method_22909();
        }
    }

    public void copyFromDefault(class_572 model) {
        super.copyFromDefault(model);
        this.left_arm_glow.method_17138(model.field_27433);
        this.right_arm_glow.method_17138(model.field_3401);
        this.left_boot_glow.method_17138(model.field_3397);
        this.right_boot_glow.method_17138(model.field_3392);
        this.helmet_glow.method_17138(model.field_3398);
        this.torso_glow.method_17138(model.field_3391);
    }

    public static class_5607 createBodyLayer() {
        class_5609 mesh = class_572.method_32011((class_5605)new class_5605(0.0f), (float)0.0f);
        class_5610 root = MalignantStrongholdArmorModel.createHumanoidAlias((class_5609)mesh);
        class_5610 right_arm_glow = root.method_32117("right_arm_glow", new class_5606(), class_5603.field_27701);
        class_5610 left_arm_glow = root.method_32117("left_arm_glow", new class_5606(), class_5603.field_27701);
        class_5610 right_foot_glow = root.method_32117("right_boot_glow", new class_5606(), class_5603.field_27701);
        class_5610 left_foot_glow = root.method_32117("left_boot_glow", new class_5606(), class_5603.field_27701);
        class_5610 helmet_glow = root.method_32117("helmet_glow", new class_5606(), class_5603.field_27701);
        class_5610 torso_glow = root.method_32117("torso_glow", new class_5606(), class_5603.field_27701);
        class_5610 body = root.method_32116("body");
        class_5610 leggings = root.method_32116("leggings");
        class_5610 right_legging = root.method_32116("right_legging");
        class_5610 left_legging = root.method_32116("left_legging");
        class_5610 right_foot = root.method_32116("right_foot");
        class_5610 left_foot = root.method_32116("left_foot");
        class_5610 right_arm = root.method_32116("right_arm");
        class_5610 left_arm = root.method_32116("left_arm");
        class_5610 head = root.method_32116("head");
        class_5610 front_glow = torso_glow.method_32117("front_glow", class_5606.method_32108().method_32101(105, 4).method_32098(-1.5f, 1.5f, -5.9f, 3.0f, 3.0f, 2.0f, new class_5605(-0.25f)), class_5603.method_32091((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        class_5610 back_glow = torso_glow.method_32117("back_glow", class_5606.method_32108().method_32101(95, 4).method_32098(-1.5f, 3.5f, 2.0f, 3.0f, 3.0f, 2.0f, new class_5605(-0.25f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 helmet_glow_left = helmet_glow.method_32117("helmet_glow_left", class_5606.method_32108().method_32101(106, 0).method_32096().method_32098(4.6846f, -10.0f, -1.2529f, 2.0f, 5.0f, 9.0f, new class_5605(-0.5f)).method_32106(false), class_5603.method_32091((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        class_5610 helmet_glow_right = helmet_glow.method_32117("helmet_glow_right", class_5606.method_32108().method_32101(106, 0).method_32096().method_32098(-6.6846f, -10.0f, -1.2529f, 2.0f, 5.0f, 9.0f, new class_5605(-0.5f)).method_32106(false), class_5603.method_32091((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        class_5610 helmet = head.method_32117("helmet", class_5606.method_32108().method_32101(0, 34).method_32098(-4.5f, -8.0f, -5.0f, 3.0f, 3.0f, 10.0f, new class_5605(0.0f)).method_32101(6, 40).method_32098(-5.5f, -8.0f, -5.0f, 1.0f, 3.0f, 1.0f, new class_5605(0.0f)).method_32101(26, 34).method_32098(-4.5f, -8.0f, -5.0f, 3.0f, 3.0f, 10.0f, new class_5605(0.25f)).method_32101(0, 47).method_32098(-4.5f, -5.0f, 1.0f, 9.0f, 5.0f, 4.0f, new class_5605(0.0f)).method_32101(26, 47).method_32098(-4.5f, -5.0f, 1.0f, 9.0f, 5.0f, 4.0f, new class_5605(0.25f)).method_32101(0, 34).method_32096().method_32098(1.5f, -8.0f, -5.0f, 3.0f, 3.0f, 10.0f, new class_5605(0.0f)).method_32106(false).method_32101(6, 40).method_32096().method_32098(4.5f, -8.0f, -5.0f, 1.0f, 3.0f, 1.0f, new class_5605(0.0f)).method_32106(false).method_32101(26, 34).method_32096().method_32098(1.5f, -8.0f, -5.0f, 3.0f, 3.0f, 10.0f, new class_5605(0.25f)).method_32106(false).method_32101(0, 0).method_32098(-1.5f, -10.0f, -6.0f, 3.0f, 6.0f, 12.0f, new class_5605(0.0f)).method_32101(0, 3).method_32098(-2.5f, -13.0f, -6.0f, 5.0f, 8.0f, 1.0f, new class_5605(0.0f)).method_32101(30, 0).method_32098(-1.5f, -10.0f, -6.0f, 3.0f, 6.0f, 12.0f, new class_5605(0.25f)).method_32101(0, 18).method_32098(-5.5f, -11.0f, -3.0f, 2.0f, 7.0f, 9.0f, new class_5605(0.0f)).method_32101(0, 18).method_32096().method_32098(3.5f, -11.0f, -3.0f, 2.0f, 7.0f, 9.0f, new class_5605(0.0f)).method_32106(false).method_32101(22, 18).method_32098(-5.5f, -11.0f, -3.0f, 2.0f, 7.0f, 9.0f, new class_5605(0.25f)).method_32101(22, 18).method_32096().method_32098(3.5f, -11.0f, -3.0f, 2.0f, 7.0f, 9.0f, new class_5605(0.25f)).method_32106(false).method_32101(18, 3).method_32098(-5.0f, -5.0f, -5.0f, 2.0f, 5.0f, 4.0f, new class_5605(0.0f)).method_32101(18, 3).method_32096().method_32098(3.0f, -5.0f, -5.0f, 2.0f, 5.0f, 4.0f, new class_5605(0.0f)).method_32106(false).method_32101(30, 3).method_32096().method_32098(3.0f, -5.0f, -5.0f, 2.0f, 5.0f, 4.0f, new class_5605(0.25f)).method_32106(false).method_32101(30, 3).method_32098(-5.0f, -5.0f, -5.0f, 2.0f, 5.0f, 4.0f, new class_5605(0.25f)).method_32101(30, 4).method_32098(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new class_5605(0.0f)).method_32101(30, 4).method_32096().method_32098(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new class_5605(0.0f)).method_32106(false), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 torso = body.method_32117("torso", class_5606.method_32108().method_32101(0, 69).method_32098(-5.0f, 2.0f, -3.0f, 10.0f, 5.0f, 6.0f, new class_5605(0.025f)).method_32101(0, 80).method_32098(-4.5f, 6.5f, -2.5f, 9.0f, 4.0f, 5.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 thing = torso.method_32117("thing", class_5606.method_32108().method_32101(0, 56).method_32098(-6.0f, -1.0f, -5.0f, 12.0f, 4.0f, 9.0f, new class_5605(0.0f)).method_32101(42, 56).method_32098(-6.0f, -1.0f, -5.0f, 12.0f, 4.0f, 9.0f, new class_5605(0.25f)), class_5603.method_32091((float)0.0f, (float)0.05f, (float)0.075f, (float)0.2618f, (float)0.0f, (float)0.0f));
        class_5610 left_shoulder = left_arm.method_32117("left_shoulder", class_5606.method_32108().method_32101(0, 89).method_32098(0.0f, -4.5f, -3.0f, 5.0f, 5.0f, 6.0f, new class_5605(0.01f)).method_32101(22, 89).method_32098(0.0f, -4.5f, -3.0f, 5.0f, 5.0f, 6.0f, new class_5605(0.26f)).method_32101(44, 89).method_32098(0.0f, -5.5f, -3.0f, 3.0f, 1.0f, 6.0f, new class_5605(0.01f)).method_32101(62, 89).method_32098(0.0f, -5.5f, -3.0f, 3.0f, 1.0f, 6.0f, new class_5605(0.27f)).method_32101(0, 111).method_32098(-1.5f, 5.0f, -3.0f, 5.0f, 6.0f, 6.0f, new class_5605(0.01f)).method_32101(22, 111).method_32098(-1.5f, 5.0f, -3.0f, 5.0f, 6.0f, 6.0f, new class_5605(0.26f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 left_shoulder_pad = left_shoulder.method_32117("left_shoulder_pad", class_5606.method_32108().method_32101(0, 100).method_32098(1.8918f, -1.4881f, -4.0f, 6.0f, 3.0f, 8.0f, new class_5605(0.01f)).method_32101(28, 100).method_32098(1.8918f, -1.4881f, -4.0f, 6.0f, 3.0f, 8.0f, new class_5605(0.26f)), class_5603.method_32091((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        class_5610 right_shoulder = right_arm.method_32117("right_shoulder", class_5606.method_32108().method_32101(0, 89).method_32096().method_32098(-5.0f, -4.5f, -3.0f, 5.0f, 5.0f, 6.0f, new class_5605(0.01f)).method_32106(false).method_32101(44, 89).method_32096().method_32098(-3.0f, -5.5f, -3.0f, 3.0f, 1.0f, 6.0f, new class_5605(0.01f)).method_32106(false).method_32101(62, 89).method_32096().method_32098(-3.0f, -5.5f, -3.0f, 3.0f, 1.0f, 6.0f, new class_5605(0.27f)).method_32106(false).method_32101(22, 89).method_32096().method_32098(-5.0f, -4.5f, -3.0f, 5.0f, 5.0f, 6.0f, new class_5605(0.26f)).method_32106(false).method_32101(0, 111).method_32096().method_32098(-3.5f, 5.0f, -3.0f, 5.0f, 6.0f, 6.0f, new class_5605(0.01f)).method_32106(false).method_32101(22, 111).method_32096().method_32098(-3.5f, 5.0f, -3.0f, 5.0f, 6.0f, 6.0f, new class_5605(0.26f)).method_32106(false), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 right_shoulder_pad = right_shoulder.method_32117("right_shoulder_pad", class_5606.method_32108().method_32101(0, 100).method_32096().method_32098(-7.6753f, -1.4644f, -4.0f, 6.0f, 3.0f, 8.0f, new class_5605(0.01f)).method_32106(false).method_32101(28, 100).method_32096().method_32098(-7.6753f, -1.4644f, -4.0f, 6.0f, 3.0f, 8.0f, new class_5605(0.26f)).method_32106(false), class_5603.method_32091((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        class_5610 left_shoulder_glow = left_arm_glow.method_32117("left_shoulder_glow", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 left_shoulder_upper_glow = left_shoulder_glow.method_32117("left_shoulder_upper_glow", class_5606.method_32108().method_32101(116, 22).method_32098(6.0f, -4.75f, -1.5f, 3.0f, 8.0f, 3.0f, new class_5605(-0.24f)).method_32101(89, 5).method_32098(4.0f, -2.25f, -3.75f, 2.0f, 3.0f, 1.0f, new class_5605(0.01f)).method_32101(89, 5).method_32098(4.0f, -2.25f, 2.75f, 2.0f, 3.0f, 1.0f, new class_5605(0.01f)), class_5603.method_32091((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        class_5610 left_shoulder_lower_glow = left_shoulder_glow.method_32117("left_shoulder_lower_glow", class_5606.method_32108().method_32101(116, 14).method_32098(3.5f, 4.0f, -1.5f, 3.0f, 5.0f, 3.0f, new class_5605(-0.23f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 right_shoulder_glow = right_arm_glow.method_32117("right_shoulder_glow", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 right_shoulder_upper_glow = right_shoulder_glow.method_32117("right_shoulder_upper_glow", class_5606.method_32108().method_32101(116, 22).method_32096().method_32098(-9.0f, -5.75f, -1.5f, 3.0f, 8.0f, 3.0f, new class_5605(-0.24f)).method_32106(false).method_32101(89, 5).method_32096().method_32098(-6.0f, -3.25f, -3.75f, 2.0f, 3.0f, 1.0f, new class_5605(0.01f)).method_32106(false).method_32101(89, 5).method_32096().method_32098(-6.0f, -3.25f, 2.75f, 2.0f, 3.0f, 1.0f, new class_5605(0.01f)).method_32106(false), class_5603.method_32091((float)2.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        class_5610 right_shoulder_lower_glow = right_shoulder_glow.method_32117("right_shoulder_lower_glow", class_5606.method_32108().method_32101(116, 14).method_32096().method_32098(-6.5f, 4.0f, -1.5f, 3.0f, 5.0f, 3.0f, new class_5605(-0.23f)).method_32106(false), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 left_leg = left_legging.method_32117("left_leg", class_5606.method_32108().method_32101(84, 116).method_32096().method_32098(-2.4f, -0.5f, -2.5f, 5.0f, 7.0f, 5.0f, new class_5605(0.0f)).method_32106(false), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 left_thigh_guard1 = left_leg.method_32117("left_thigh_guard1", class_5606.method_32108().method_32101(48, 117).method_32096().method_32098(1.3934f, -1.1278f, -3.0f, 3.0f, 5.0f, 6.0f, new class_5605(0.03f)).method_32106(false).method_32101(48, 106).method_32096().method_32098(1.3934f, -1.1278f, -3.0f, 3.0f, 5.0f, 6.0f, new class_5605(0.28f)).method_32106(false), class_5603.method_32091((float)0.1f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1345f));
        class_5610 left_thigh_guard2 = left_leg.method_32117("left_thigh_guard2", class_5606.method_32108().method_32101(66, 115).method_32096().method_32098(-0.2266f, -2.8943f, -3.0f, 3.0f, 7.0f, 6.0f, new class_5605(0.02f)).method_32106(false).method_32101(66, 102).method_32096().method_32098(-0.2266f, -2.8943f, -3.0f, 3.0f, 7.0f, 6.0f, new class_5605(0.27f)).method_32106(false), class_5603.method_32091((float)1.1f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1345f));
        class_5610 right_leg = right_legging.method_32117("right_leg", class_5606.method_32108().method_32101(84, 116).method_32098(-2.6f, -0.5f, -2.5f, 5.0f, 7.0f, 5.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 right_thigh_guard1 = right_leg.method_32117("right_thigh_guard1", class_5606.method_32108().method_32101(48, 117).method_32098(-4.3934f, -1.1278f, -3.0f, 3.0f, 5.0f, 6.0f, new class_5605(0.03f)).method_32101(48, 106).method_32098(-4.3934f, -1.1278f, -3.0f, 3.0f, 5.0f, 6.0f, new class_5605(0.28f)), class_5603.method_32091((float)-0.1f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1345f));
        class_5610 right_thigh_guard2 = right_leg.method_32117("right_thigh_guard2", class_5606.method_32108().method_32101(66, 115).method_32098(-2.7734f, -2.8943f, -3.0f, 3.0f, 7.0f, 6.0f, new class_5605(0.02f)).method_32101(66, 102).method_32098(-2.7734f, -2.8943f, -3.0f, 3.0f, 7.0f, 6.0f, new class_5605(0.27f)), class_5603.method_32091((float)-1.1f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1345f));
        class_5610 codpiece = leggings.method_32117("codpiece", class_5606.method_32108().method_32101(32, 72).method_32098(-4.0f, -14.5f, -3.0f, 8.0f, 2.0f, 6.0f, new class_5605(0.04f)).method_32101(60, 72).method_32098(-4.0f, -14.5f, -3.0f, 8.0f, 2.0f, 6.0f, new class_5605(0.29f)).method_32101(28, 80).method_32098(-2.0f, -12.5f, -3.0f, 4.0f, 3.0f, 6.0f, new class_5605(0.04f)).method_32101(48, 80).method_32098(-2.0f, -12.5f, -3.0f, 4.0f, 3.0f, 6.0f, new class_5605(0.29f)), class_5603.method_32090((float)0.0f, (float)24.0f, (float)0.0f));
        class_5610 left_boot = left_foot.method_32117("left_boot", class_5606.method_32108().method_32101(104, 115).method_32098(-2.9f, 6.0f, -3.0f, 6.0f, 7.0f, 6.0f, new class_5605(0.01f)).method_32101(104, 102).method_32098(-2.9f, 6.0f, -3.0f, 6.0f, 7.0f, 6.0f, new class_5605(0.26f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 right_boot = right_foot.method_32117("right_boot", class_5606.method_32108().method_32101(104, 115).method_32096().method_32098(-3.1f, 6.0f, -3.0f, 6.0f, 7.0f, 6.0f, new class_5605(0.0f)).method_32106(false).method_32101(104, 102).method_32096().method_32098(-3.1f, 6.0f, -3.0f, 6.0f, 7.0f, 6.0f, new class_5605(0.25f)).method_32106(false), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 left_boot_glow = left_foot_glow.method_32117("left_boot_glow", class_5606.method_32108().method_32101(106, 14).method_32098(2.6f, 6.5f, -1.5f, 2.0f, 4.0f, 3.0f, new class_5605(-0.24f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 right_boot_glow = right_foot_glow.method_32117("right_boot_glow", class_5606.method_32108().method_32101(106, 14).method_32096().method_32098(-4.6f, 6.5f, -1.5f, 2.0f, 4.0f, 3.0f, new class_5605(-0.25f)).method_32106(false), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)mesh, (int)128, (int)128);
    }
}

