/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class TimekeeperItem
extends SimplyMoreUniqueSwordItem {
    int skillCooldown = effect.getTimekeeperBaseCooldown();
    int stepMod = 0;

    public TimekeeperItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.field_9236) {
            return super.method_7836(world, user, hand);
        }
        double playerX = user.method_23317();
        double playerY = user.method_23320();
        double playerZ = user.method_23321();
        long currentTime = Math.abs(world.method_8532() % 24000L);
        boolean isFixedTime = world.method_8597().method_29960();
        if (!isFixedTime) {
            if (currentTime < 13000L) {
                this.spawnFlameAttack(world, user, playerX, playerY, playerZ);
            } else {
                this.spawnWindAttack(world, user, playerX, user.method_23318(), playerZ);
            }
            user.method_7357().method_7906(this.method_7854().method_7909(), this.calculateCooldown(currentTime, isFixedTime));
        }
        return super.method_7836(world, user, hand);
    }

    private void spawnFlameAttack(class_1937 world, class_1657 player, double playerX, double playerY, double playerZ) {
        for (int i = 0; i < 12; ++i) {
            float yaw = (float)Math.toRadians(player.method_36454() + 90.0f);
            float pitch = (float)Math.toRadians(player.method_36455());
            double distanceX = Math.cos(yaw) * Math.cos(pitch) * (double)i;
            double distanceZ = Math.sin(yaw) * Math.cos(pitch) * (double)i;
            double distanceY = Math.sin(pitch) * (double)(-i);
            ((class_3218)world).method_14199((class_2394)class_2398.field_11240, playerX + distanceX / 2.0, playerY + distanceY / 2.0, playerZ + distanceZ / 2.0, 10, 0.3, 0.3, 0.3, 0.0);
            class_238 box = new class_238(playerX + distanceX / 2.0 - 0.8, playerY + distanceY / 2.0 - 0.8, playerZ + distanceZ / 2.0 - 0.8, playerX + distanceX / 2.0 + 0.8, playerY + distanceY / 2.0 + 0.8, playerZ + distanceZ / 2.0 + 0.8);
            List entities = world.method_18467(class_1309.class, box);
            for (class_1309 entity : entities) {
                if (entity.method_5722((class_1297)player) || entity == player) continue;
                entity.method_18800(distanceX * 2.5 / (double)i, distanceY * 2.5 / (double)i, distanceZ * 2.5 / (double)i);
                entity.field_6037 = true;
                entity.method_5639(5);
                entity.method_5643(player.method_48923().method_48813(), effect.getTimekeeperDayActiveDamage());
                entity.method_6092(new class_1293(class_1294.field_5919, effect.getTimekeeperDayActiveBlindnessTime()));
            }
        }
        world.method_43128(null, playerX, playerY, playerZ, (class_3414)SoundRegistry.ELEMENTAL_SWORD_FIRE_ATTACK_01.get(), class_3419.field_15248, 1.0f, 1.0f);
    }

    private void spawnWindAttack(class_1937 world, class_1657 player, double playerX, double playerY, double playerZ) {
        for (int j = 0; j < 5; ++j) {
            for (int i = 0; i < 15; ++i) {
                double yaw = Math.toRadians(player.method_36454());
                double distanceZ = Math.cos(yaw += Math.toRadians((j - 2) * 30)) * (double)i;
                double distanceX = Math.sin(yaw) * (double)(-i);
                ((class_3218)world).method_14199((class_2394)class_2398.field_11227, playerX + distanceX / 2.0, playerY + 0.3, playerZ + distanceZ / 2.0, 1, 0.0, 0.0, 0.0, 0.0);
                class_238 box = new class_238(playerX + distanceX / 2.0 - 0.8, playerY + 0.3 - 5.0, playerZ + distanceZ / 2.0 - 0.8, playerX + distanceX / 2.0 + 0.8, playerY + 0.3 + 5.0, playerZ + distanceZ / 2.0 + 0.8);
                List entities = world.method_18467(class_1309.class, box);
                for (class_1309 entity : entities) {
                    if (entity.method_5722((class_1297)player) || entity == player) continue;
                    entity.method_18800(0.0, 1.5, 0.0);
                    entity.field_6037 = true;
                    entity.method_5643(player.method_48923().method_48831(), effect.getTimekeeperNightActiveDamage());
                    entity.method_6092(new class_1293(class_1294.field_5909, effect.getTimekeeperNightActiveSlownessTime(), 3));
                }
            }
        }
        world.method_43128(null, playerX, playerY, playerZ, (class_3414)SoundRegistry.ELEMENTAL_SWORD_WIND_ATTACK_01.get(), class_3419.field_15248, 1.0f, 1.5f);
    }

    private int calculateCooldown(long currentTime, boolean isFixedTime) {
        return isFixedTime && currentTime < 13000L ? (int)((long)this.skillCooldown + (long)this.skillCooldown * Math.abs(6000L - currentTime) / 7000L) : (int)((long)this.skillCooldown + (long)this.skillCooldown * Math.abs(18000L - currentTime) / 7000L);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!attacker.method_37908().method_8608() && attacker.method_6051().method_39332(1, 100) <= effect.getTimekeeperOnHitChance()) {
            long dayTime = Math.abs(attacker.method_37908().method_8532() % 24000L);
            boolean isFixedTime = attacker.method_37908().method_8597().method_29960();
            if (isFixedTime) {
                this.applyRandomEffect(attacker, (class_3218)attacker.method_37908());
            } else {
                this.applyTimeBasedEffect(dayTime, attacker, (class_3218)attacker.method_37908());
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    private void applyDayPassiveEffect(class_1309 attacker, class_3218 world) {
        world.method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), (class_3414)SoundRegistry.MAGIC_SWORD_BLOCK_01.get(), class_3419.field_15248, 0.25f, 1.0f);
        world.method_14199((class_2394)class_2398.field_29644, attacker.method_23317(), attacker.method_23318() + 0.5, attacker.method_23321(), 20, 0.7, 0.7, 0.7, 0.0);
        for (class_1309 passiveTarget : attacker.method_37908().method_18467(class_1309.class, new class_238(attacker.method_23317() - 30.0, attacker.method_23318() - 30.0, attacker.method_23321() - 30.0, attacker.method_23317() + 30.0, attacker.method_23318() + 30.0, attacker.method_23321() + 30.0))) {
            if (passiveTarget == attacker || passiveTarget.method_5722((class_1297)attacker)) continue;
            passiveTarget.method_37222(new class_1293(class_1294.field_5912, effect.getTimekeeperDayPassiveEffectTime(), 0), (class_1297)attacker);
        }
    }

    private void applyNightPassiveEffect(class_1309 attacker, class_3218 world) {
        world.method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), (class_3414)SoundRegistry.MAGIC_SWORD_BLOCK_01.get(), class_3419.field_15248, 0.25f, 1.0f);
        world.method_14199((class_2394)class_2398.field_11233, attacker.method_23317(), attacker.method_23318() + 0.5, attacker.method_23321(), 20, 0.7, 0.7, 0.7, 0.0);
        for (class_1309 passiveTarget : attacker.method_37908().method_18467(class_1309.class, new class_238(attacker.method_23317() - 10.0, attacker.method_23318() - 10.0, attacker.method_23321() - 10.0, attacker.method_23317() + 10.0, attacker.method_23318() + 10.0, attacker.method_23321() + 10.0))) {
            if (passiveTarget == attacker || passiveTarget.method_5722((class_1297)attacker)) continue;
            passiveTarget.method_37222(new class_1293(class_1294.field_38092, effect.getTimekeeperNightPassiveEffectTime(), 0), (class_1297)attacker);
        }
        attacker.method_37222(new class_1293(class_1294.field_5905, effect.getTimekeeperNightPassiveEffectTime(), 0), (class_1297)attacker);
        attacker.method_37222(new class_1293(class_1294.field_5904, effect.getTimekeeperNightPassiveEffectTime(), 1), (class_1297)attacker);
    }

    private void applyRandomEffect(class_1309 entity, class_3218 world) {
        if (entity.method_6051().method_43056()) {
            this.applyDayPassiveEffect(entity, world);
        } else {
            this.applyNightPassiveEffect(entity, world);
        }
    }

    private void applyTimeBasedEffect(long timeOfDay, class_1309 entity, class_3218 world) {
        if (timeOfDay < 13000L) {
            this.applyDayPassiveEffect(entity, world);
        } else {
            this.applyNightPassiveEffect(entity, world);
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, class_2398.field_22247);
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        class_2583 rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        class_2583 abilityStyle = HelperMethods.getStyle((String)"ability");
        class_2583 textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        if (world == null) {
            return;
        }
        long dayTime = Math.abs(world.method_8532() % 24000L);
        boolean isFixedTime = world.method_8597().method_29960();
        if (isFixedTime) {
            this.appendFixedTimeTooltips(tooltip, abilityStyle, textStyle);
        } else if (dayTime < 13000L) {
            this.appendDayTooltips(tooltip, rightClickStyle, abilityStyle, textStyle);
        } else {
            this.appendNightTooltips(tooltip, rightClickStyle, abilityStyle, textStyle);
        }
        super.method_7851(itemStack, world, tooltip, tooltipContext);
    }

    private void appendFixedTimeTooltips(List<class_2561> tooltip, class_2583 abilityStyle, class_2583 textStyle) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_timeless.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_timeless.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_timeless.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_timeless.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_timeless.tooltip5").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_timeless.tooltip6").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_timeless.tooltip7").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_timeless.tooltip8").method_10862(textStyle));
    }

    private void appendDayTooltips(List<class_2561> tooltip, class_2583 rightClickStyle, class_2583 abilityStyle, class_2583 textStyle) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_day.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_day.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_day.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclick").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_day.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_day.tooltip5").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_day.tooltip6").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_day.tooltip7").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_day.tooltip8").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_day.tooltip9").method_10862(textStyle));
    }

    private void appendNightTooltips(List<class_2561> tooltip, class_2583 rightClickStyle, class_2583 abilityStyle, class_2583 textStyle) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_night.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_night.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_night.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclick").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_night.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_night.tooltip5").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_night.tooltip6").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_night.tooltip7").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_night.tooltip8").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.timekeeper_night.tooltip9").method_10862(textStyle));
    }
}

