/*
 * Decompiled with CFR 0.152.
 */
package net.rosemarythyme.simplymore.item.uniques;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.rosemarythyme.simplymore.config.WeaponAttributesConfig;
import net.rosemarythyme.simplymore.entity.JetAreaEffectCloudEntity;
import net.rosemarythyme.simplymore.item.SimplyMoreUniqueSwordItem;
import net.rosemarythyme.simplymore.registry.ModEffectsRegistry;
import net.rosemarythyme.simplymore.util.SimplyMoreHelperMethods;
import net.sweenus.simplyswords.util.HelperMethods;

public class BrassturnItem
extends SimplyMoreUniqueSwordItem {
    protected static WeaponAttributesConfig attributes = BrassturnItem.config.weaponAttributes;
    int stepMod = 0;

    public BrassturnItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        double attackSpeedModifier = (double)BrassturnItem.getOxidisation(stack) * (((double)3.4f + attributes.getBrassturnMaxSwingSpeed()) / -16.0);
        Multimap attributeModifiers = super.method_7844(slot);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(attributeModifiers);
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(UUID.fromString("ebdfffcf-7f0d-4502-96ec-e4f6b995fe2f"), "Weapon modifier", attackSpeedModifier, class_1322.class_1323.field_6328));
        return slot == class_1304.field_6173 ? builder.build() : super.method_7844(slot);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (attacker.method_37908().method_8608()) {
            return super.method_7873(stack, target, attacker);
        }
        int oxidisation = BrassturnItem.getOxidisation(stack) + 1;
        BrassturnItem.saveOxidisation(stack, oxidisation);
        if (attacker.method_6051().method_39332(1, 100) <= effect.getBrassturnJetChance()) {
            attacker.method_37908().method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14986, class_3419.field_15248, 0.5f, 2.0f);
            ((class_3218)attacker.method_37908()).method_8649((class_1297)new JetAreaEffectCloudEntity(target.method_37908(), target.method_23317(), target.method_23318(), target.method_23321(), attacker));
        }
        return super.method_7873(stack, target, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (BrassturnItem.getOxidisation(itemStack) <= 0) {
            return class_1271.method_22431((Object)itemStack);
        }
        if (itemStack.method_7919() >= itemStack.method_7936() - 1) {
            return class_1271.method_22431((Object)itemStack);
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        class_1937 class_19372;
        if (BrassturnItem.getOxidisation(stack) <= 0) {
            user.method_6075();
        }
        if (remainingUseTicks % effect.getBrassturnScrapeTime() == 0 && (class_19372 = user.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            int oxidisation = BrassturnItem.getOxidisation(stack) - 1;
            BrassturnItem.saveOxidisation(stack, oxidisation);
            if (user.method_6051().method_39332(1, 100) <= effect.getBrassturnSparkChance()) {
                serverWorld.method_14199((class_2394)class_2398.field_29642, user.method_23317(), user.method_23318(), user.method_23321(), 20, 0.5, 1.0, 0.5, 0.2);
                serverWorld.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14891, class_3419.field_15248, 0.5f, 2.0f);
                int boxSize = 3;
                class_238 box = new class_238(user.method_23317() - (double)boxSize, user.method_23318() - 2.0, user.method_23321() - (double)boxSize, user.method_23317() + (double)boxSize, user.method_23318() + (double)boxSize, user.method_23321() + (double)boxSize);
                List livingEntities = user.method_37908().method_18467(class_1309.class, box);
                for (class_1309 livingEntity : livingEntities) {
                    if (livingEntity == user || livingEntity.method_5722((class_1297)user)) continue;
                    livingEntity.method_6092(new class_1293((class_1291)ModEffectsRegistry.STUNNED.get(), effect.getBrassturnSparkStunDuration(), 0));
                }
            } else {
                serverWorld.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_29541, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    public int method_7881(class_1799 stack) {
        return 999999;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public static int getOxidisation(class_1799 stack) {
        int maxOxidisation = 16;
        class_2520 oxiRaw = stack.method_7948().method_10580("simplymore:oxidisation");
        if (oxiRaw == null) {
            BrassturnItem.saveOxidisation(stack, 16);
            return 16;
        }
        String oxiString = oxiRaw.toString().replaceAll("\"", "");
        int oxiNumber = 0;
        try {
            oxiNumber = Math.min(16, Integer.parseInt(oxiString));
        }
        catch (NumberFormatException e) {
            oxiNumber = 16;
            BrassturnItem.saveOxidisation(stack, 16);
        }
        return oxiNumber;
    }

    public static void saveOxidisation(class_1799 stack, int oxidisation) {
        stack.method_7948().method_10582("simplymore:oxidisation", Integer.toString(oxidisation));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        this.stepMod = SimplyMoreHelperMethods.simplyMore$footfallsHelper(entity, stack, world, this.stepMod, class_2398.field_22247);
        super.method_7888(stack, world, entity, slot, selected);
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        class_2583 rightClickStyle = HelperMethods.getStyle((String)"rightclick");
        class_2583 abilityStyle = HelperMethods.getStyle((String)"ability");
        class_2583 textStyle = HelperMethods.getStyle((String)"text");
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.brassturn.tooltip1").method_10862(abilityStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.brassturn.tooltip2").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.brassturn.tooltip3").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.brassturn.tooltip4").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43470((String)" "));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclickheld").method_10862(rightClickStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.brassturn.tooltip5").method_10862(textStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplymore.brassturn.tooltip6").method_10862(textStyle));
        super.method_7851(itemStack, world, tooltip, tooltipContext);
    }
}

