/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.api.util.JSONHelper;
import net.darkhax.bookshelf.mixin.accessors.util.random.AccessorWeightedRandomList;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_6005;
import net.minecraft.class_6008;

public interface ISerializer<T> {
    public T fromJSON(JsonElement var1);

    default public T fromJSON(JsonObject json, String memberName) {
        return this.fromJSON(json.get(memberName));
    }

    default public T fromJSON(JsonObject json, String memberName, T fallback) {
        return json.has(memberName) ? this.fromJSON(json, memberName) : fallback;
    }

    default public T fromJSON(JsonObject json, String memberName, Supplier<T> fallback) {
        return json.has(memberName) ? this.fromJSON(json, memberName) : fallback.get();
    }

    default public void toJSON(JsonObject json, String name, T toWrite) {
        json.add(name, this.toJSON(toWrite));
    }

    public JsonElement toJSON(T var1);

    public T fromByteBuf(class_2540 var1);

    public void toByteBuf(class_2540 var1, T var2);

    public class_2520 toNBT(T var1);

    public T fromNBT(class_2520 var1);

    default public T fromNBT(class_2487 tag, String name) {
        if (tag.method_10545(name)) {
            return this.fromNBT(tag.method_10580(name));
        }
        throw new NBTParseException("Required tag " + name + " was not present.");
    }

    default public T fromNBT(@Nullable class_2487 tag, String name, T fallback) {
        return tag != null && tag.method_10545(name) ? this.fromNBT(tag.method_10580(name)) : fallback;
    }

    default public void toNBT(class_2487 tag, String name, T toWrite) {
        tag.method_10566(name, this.toNBT(toWrite));
    }

    default public void toNBTList(@Nullable class_2487 tag, String name, @Nullable List<T> toWrite) {
        if (tag != null && toWrite != null && !toWrite.isEmpty()) {
            tag.method_10566(name, (class_2520)this.toNBTList(toWrite));
        }
    }

    default public class_2499 toNBTList(List<T> toWrite) {
        class_2499 listTag = new class_2499();
        for (T value : toWrite) {
            listTag.add((Object)this.toNBT(value));
        }
        return listTag;
    }

    default public List<T> fromNBTList(class_2487 tag, String name) {
        if (tag.method_10545(name)) {
            return this.fromNBTList(tag.method_10580(name));
        }
        throw new NBTParseException("Expected list tag named " + name);
    }

    default public List<T> fromNBTList(class_2520 toRead) {
        LinkedList<T> list = new LinkedList<T>();
        if (toRead instanceof class_2499) {
            class_2499 listTag = (class_2499)toRead;
            for (class_2520 tag : listTag) {
                list.add(this.fromNBT(tag));
            }
        } else {
            list.add(this.fromNBT(toRead));
        }
        return list;
    }

    default public List<T> fromJSONList(JsonElement json) {
        ArrayList<T> list = new ArrayList<T>();
        if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                list.add(this.fromJSON(element));
            }
        } else {
            list.add(this.fromJSON(json));
        }
        return list;
    }

    default public List<T> fromJSONList(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return this.fromJSONList(json.get(memberName));
        }
        throw new JsonParseException("Expected member " + memberName + " was not found.");
    }

    default public List<T> fromJSONList(JsonObject json, String memberName, List<T> fallback) {
        return json.has(memberName) ? this.fromJSONList(json, memberName) : fallback;
    }

    default public List<T> fromJSONList(JsonObject json, String memberName, Supplier<List<T>> fallback) {
        return json.has(memberName) ? this.fromJSONList(json, memberName) : fallback.get();
    }

    default public JsonElement toJSONList(List<T> toWrite) {
        JsonArray json = new JsonArray();
        toWrite.forEach(t -> json.add(this.toJSON(t)));
        return json;
    }

    default public void toJSONList(JsonObject json, String memberName, @Nullable List<T> toWrite) {
        if (toWrite != null && !toWrite.isEmpty()) {
            json.add(memberName, this.toJSONList(toWrite));
        }
    }

    default public List<T> fromByteBufList(class_2540 buffer) {
        int size = buffer.readInt();
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.fromByteBuf(buffer));
        }
        return list;
    }

    default public void toByteBufList(class_2540 buffer, List<T> toWrite) {
        buffer.writeInt(toWrite.size());
        toWrite.forEach(t -> this.toByteBuf(buffer, t));
    }

    default public Set<T> fromJSONSet(JsonElement json) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                set.add(this.fromJSON(element));
            }
        } else {
            set.add(this.fromJSON(json));
        }
        return set;
    }

    default public Set<T> fromJSONSet(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return this.fromJSONSet(json.get(memberName));
        }
        throw new JsonParseException("Expected member " + memberName + " was not found.");
    }

    default public Set<T> fromJSONSet(JsonObject json, String memberName, Set<T> fallback) {
        return json.has(memberName) ? this.fromJSONSet(json, memberName) : fallback;
    }

    default public Set<T> fromJSONSet(JsonObject json, String memberName, Supplier<Set<T>> fallback) {
        return json.has(memberName) ? this.fromJSONSet(json, memberName) : fallback.get();
    }

    default public JsonElement toJSONSet(Set<T> toWrite) {
        JsonArray json = new JsonArray();
        toWrite.forEach(t -> json.add(this.toJSON(t)));
        return json;
    }

    default public Set<T> readByteBufSet(class_2540 buffer) {
        int size = buffer.readInt();
        LinkedHashSet<T> set = new LinkedHashSet<T>(size);
        for (int i = 0; i < size; ++i) {
            set.add(this.fromByteBuf(buffer));
        }
        return set;
    }

    default public void writeByteBufSet(class_2540 buffer, Set<T> toWrite) {
        buffer.writeInt(toWrite.size());
        toWrite.forEach(t -> this.toByteBuf(buffer, t));
    }

    default public Optional<T> fromJSONOptional(JsonObject json, String memberName) {
        return this.fromJSONOptional(json.get(memberName));
    }

    default public Optional<T> fromJSONOptional(@Nullable JsonElement json) {
        return json != null ? Optional.ofNullable(this.fromJSON(json)) : Optional.empty();
    }

    @Nullable
    default public JsonElement toJSONOptional(@Nullable T value) {
        return this.toJSONOptional(Optional.ofNullable(value));
    }

    @Nullable
    default public JsonElement toJSONOptional(Optional<T> value) {
        return value.map(this::toJSON).orElse(null);
    }

    default public void toJSONOptional(JsonObject json, String memberName, Optional<T> value) {
        value.ifPresent(v -> json.add(memberName, this.toJSON(v)));
    }

    default public Optional<T> fromByteBufOptional(class_2540 buffer) {
        return buffer.readBoolean() ? Optional.of(this.fromByteBuf(buffer)) : Optional.empty();
    }

    default public void toByteBufOptional(class_2540 buffer, Optional<T> optional) {
        boolean isPresent = optional.isPresent();
        buffer.writeBoolean(isPresent);
        if (isPresent) {
            this.toByteBuf(buffer, optional.get());
        }
    }

    default public String toJSONString(T toWrite) {
        return this.toJSON(toWrite).toString();
    }

    default public T fromJSONString(String jsonString) {
        return this.fromJSON(JSONHelper.getAsElement(jsonString));
    }

    default public class_6008.class_6010<T> fromJSONWeighted(JsonElement element) {
        if (element instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            T value = this.fromJSON(obj, "value");
            int weight = Serializers.INT.fromJSON(obj, "weight", 0);
            return class_6008.method_34980(value, (int)weight);
        }
        return class_6008.method_34980(this.fromJSON(element), (int)0);
    }

    default public JsonElement toJSONWeighted(class_6008.class_6010<T> weightedEntry) {
        JsonObject obj = new JsonObject();
        obj.add("value", this.toJSON(weightedEntry.method_34983()));
        obj.addProperty("weight", (Number)weightedEntry.method_34979().method_34976());
        return obj;
    }

    default public void toByteBufWeighted(class_2540 buffer, class_6008.class_6010<T> toWrite) {
        this.toByteBuf(buffer, toWrite.method_34983());
        Serializers.INT.toByteBuf(buffer, toWrite.method_34979().method_34976());
    }

    default public class_6008.class_6010<T> fromByteBufWeighted(class_2540 buffer) {
        T value = this.fromByteBuf(buffer);
        int weight = Serializers.INT.fromByteBuf(buffer);
        return class_6008.method_34980(value, (int)weight);
    }

    default public class_6005<T> fromJSONWeightedList(JsonElement json) {
        class_6005.class_6006 list = class_6005.method_34971();
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            for (JsonElement element : array) {
                class_6008.class_6010<T> wrapped = this.fromJSONWeighted(element);
                list.method_34975(wrapped.method_34983(), wrapped.method_34979().method_34976());
            }
        } else {
            class_6008.class_6010<T> wrapped = this.fromJSONWeighted(json);
            list.method_34975(wrapped.method_34983(), wrapped.method_34979().method_34976());
        }
        return list.method_34974();
    }

    default public JsonElement toJSONWeightedList(class_6005<T> list) {
        JsonArray array = new JsonArray();
        AccessorWeightedRandomList accessor = (AccessorWeightedRandomList)list;
        for (class_6008.class_6010 entry : accessor.bookshelf$getEntries()) {
            array.add(this.toJSONWeighted(entry));
        }
        return array;
    }

    default public class_6005<T> fromByteBufWeightedList(class_2540 buffer) {
        class_6005.class_6006 list = class_6005.method_34971();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            class_6008.class_6010<T> wrapped = this.fromByteBufWeighted(buffer);
            list.method_34975(wrapped.method_34983(), wrapped.method_34979().method_34976());
        }
        return list.method_34974();
    }

    default public void toByteBufWeightedList(class_2540 buffer, class_6005<T> list) {
        AccessorWeightedRandomList accessor = (AccessorWeightedRandomList)list;
        buffer.writeInt(accessor.bookshelf$getEntries().size());
        for (class_6008.class_6010 entry : accessor.bookshelf$getEntries()) {
            this.toByteBufWeighted(buffer, entry);
        }
    }

    @Nullable
    default public T fromJSONNullable(JsonObject json, String memberName) {
        return json.has(memberName) ? (T)this.fromJSONNullable(json.get(memberName)) : null;
    }

    @Nullable
    default public T fromJSONNullable(@Nullable JsonElement json) {
        return json != null ? (T)this.fromJSON(json) : null;
    }

    @Nullable
    default public JsonElement toJSONNullable(@Nullable T value) {
        return value != null ? this.toJSON(value) : null;
    }

    default public void toJSONNullable(@Nullable JsonObject json, String memberName, @Nullable T value) {
        if (json != null && value != null) {
            json.add(memberName, this.toJSON(value));
        }
    }

    @Nullable
    default public T fromByteBufNullable(class_2540 buffer) {
        return buffer.readBoolean() ? (T)this.fromByteBuf(buffer) : null;
    }

    default public void toByteBufNullable(class_2540 buffer, @Nullable T value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            this.toByteBuf(buffer, value);
        }
    }
}

