/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_core.json_util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_core.modifier_util.AbstractModifier;
import me.fzzyhmstrs.fzzy_core.modifier_util.ModifierHelperType;
import me.fzzyhmstrs.fzzy_core.registry.ModifierRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ!\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ1\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0003\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J3\u0010\u0015\u001a\u00028\u0000\"\u000e\b\u0000\u0010\u0017*\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018\u00a2\u0006\u0004\b\u0015\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lme/fzzyhmstrs/fzzy_core/json_util/JsonReader;", "", "Lcom/google/gson/JsonElement;", "json", "Lkotlin/Pair;", "Lnet/minecraft/class_1320;", "Lnet/minecraft/class_1322;", "readEntityAttribute", "(Lcom/google/gson/JsonElement;)Lkotlin/Pair;", "Lcom/google/gson/JsonObject;", "", "name", "", "Lnet/minecraft/class_124;", "fallback", "readFormatting", "(Lcom/google/gson/JsonObject;Ljava/lang/String;Ljava/util/List;)Ljava/util/List;", "Lnet/minecraft/class_2960;", "readIdentifier", "(Lcom/google/gson/JsonElement;)Lnet/minecraft/class_2960;", "Lme/fzzyhmstrs/fzzy_core/modifier_util/AbstractModifier;", "readModifier", "(Lcom/google/gson/JsonElement;)Lme/fzzyhmstrs/fzzy_core/modifier_util/AbstractModifier;", "T", "Ljava/lang/Class;", "classType", "(Lcom/google/gson/JsonElement;Ljava/lang/Class;)Lme/fzzyhmstrs/fzzy_core/modifier_util/AbstractModifier;", "<init>", "()V", "fzzy_core"})
public final class JsonReader {
    @NotNull
    public static final JsonReader INSTANCE = new JsonReader();

    private JsonReader() {
    }

    @NotNull
    public final Pair<class_1320, class_1322> readEntityAttribute(@NotNull JsonElement json) {
        String operationString;
        double d;
        String attributeIdString;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonObject attributeJson = json.getAsJsonObject();
        try {
            attributeIdString = attributeJson.get("attribute").getAsString();
            class_2960 class_29602 = class_2960.method_12829((String)attributeIdString);
            if (class_29602 == null) {
                throw new IllegalStateException("Entity Attribute Json has an attribute bonus with an invalid identifier value [" + attributeIdString + "].");
            }
            class_2960 attributeId = class_29602;
            class_1320 class_13202 = (class_1320)class_7923.field_41190.method_10223(attributeId);
            if (class_13202 == null) {
                throw new IllegalStateException("Entity Attribute Json has an attribute bonus with an attribute value [" + attributeIdString + "] that can't be found in the attribute registry.");
            }
            attributeIdString = class_13202;
        }
        catch (Exception e) {
            throw new IllegalStateException("Entity Attribute Json has an attribute bonus with aan invalid 'attribute' key [" + attributeJson + "]. Missing or needs to be a valid identifier string.");
        }
        String attribute = attributeIdString;
        UUID uuid = UUID.randomUUID();
        String name = class_7923.field_41190.method_10221((Object)attribute) + "_modifier";
        try {
            d = attributeJson.get("amount").getAsDouble();
        }
        catch (Exception e) {
            throw new IllegalStateException("Entity Attribute Json has an attribute bonus with an invalid 'amount' key. Missing or needs to be a valid number.");
        }
        double value = d;
        try {
            operationString = attributeJson.get("operation").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)operationString, (String)"operationString");
            operationString = class_1322.class_1323.valueOf((String)operationString);
        }
        catch (Exception e) {
            throw new IllegalStateException("Entity Attribute Json has an attribute bonus with aan invalid 'operation' key. Missing or needs to be a valid number.");
        }
        String operation = operationString;
        class_1322 attributeModifier = new class_1322(uuid, name, value, (class_1322.class_1323)operation);
        return new Pair((Object)attribute, (Object)attributeModifier);
    }

    @NotNull
    public final class_2960 readIdentifier(@NotNull JsonElement json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String modifierIdString = json.getAsString();
        class_2960 class_29602 = class_2960.method_12829((String)modifierIdString);
        if (class_29602 == null) {
            throw new IllegalStateException("Identifier Json has an invalid identifier value [" + modifierIdString + "].");
        }
        return class_29602;
    }

    @NotNull
    public final <T extends AbstractModifier<T>> T readModifier(@NotNull JsonElement json, @NotNull Class<T> classType) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(classType, (String)"classType");
        T t = ModifierRegistry.INSTANCE.getByType(this.readIdentifier(json), classType);
        if (t == null) {
            throw new IllegalStateException("Modifier Json has a bonus with a modifier value [" + json + "] that can't be found in the modifier registry.");
        }
        return t;
    }

    @NotNull
    public final AbstractModifier<?> readModifier(@NotNull JsonElement json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        AbstractModifier<?> abstractModifier = ModifierRegistry.INSTANCE.get(this.readIdentifier(json));
        if (abstractModifier == null) {
            throw new IllegalStateException("Modifier Json has a bonus with a modifier value [" + json + "] that can't be found in the modifier registry.");
        }
        return abstractModifier;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<class_124> readFormatting(@NotNull JsonObject json, @NotNull String name, @NotNull List<? extends class_124> fallback) {
        List list;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(fallback, (String)"fallback");
        if (json.has(name)) {
            Object object;
            try {
                String jsonElement;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                object = json.getAsJsonArray(name);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"json.getAsJsonArray(name)");
                object = (Iterable)object;
                boolean $i$f$map = false;
                void var6_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(jsonElement.getAsString());
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void str;
                    jsonElement = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(class_124.method_533((String)str));
                }
                object = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
            }
            catch (Exception e) {
                throw new IllegalStateException("Gear Set [" + ModifierHelperType.Companion.EmptyType.INSTANCE.getId() + "] has an 'active_formatting' member that isn't a properly formatted array.");
            }
            list = object;
        } else {
            Object[] objectArray = new class_124[]{class_124.field_1065, class_124.field_1067};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return list;
    }
}

