/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.entity.block.inventory;

import com.nhoryzon.mc.farmersdelight.exception.SlotInvalidRangeException;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public interface ItemStackInventory
extends class_1263 {
    public class_2371<class_1799> getItems();

    public static ItemStackInventory of() {
        return ItemStackInventory.of(1);
    }

    public static ItemStackInventory of(int inventorySize) {
        return () -> class_2371.method_10213((int)inventorySize, (Object)class_1799.field_8037);
    }

    public static boolean canBeStacked(class_1799 left, class_1799 right) {
        if (left.method_7960() || !class_1799.method_7984((class_1799)left, (class_1799)right) || left.method_7985() != right.method_7985()) {
            return false;
        }
        return !left.method_7985() || left.method_7969().equals((Object)right.method_7969());
    }

    public static class_1799 copyStackWithNewSize(class_1799 itemStack, int newSize) {
        if (newSize == 0) {
            return class_1799.field_8037;
        }
        class_1799 copy = itemStack.method_7972();
        copy.method_7939(newSize);
        return copy;
    }

    default public int method_5439() {
        return this.getItems().size();
    }

    default public boolean method_5442() {
        return this.getItems().stream().anyMatch(stack -> !stack.method_7960());
    }

    default public class_1799 method_5438(int slot) {
        this.validateSlotIndex(slot);
        return (class_1799)this.getItems().get(slot);
    }

    default public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this.getItems(), (int)slot, (int)amount);
        if (!result.method_7960()) {
            this.method_5431();
            this.onContentsChanged(slot);
        }
        return result;
    }

    default public class_1799 method_5441(int slot) {
        class_1799 result = class_1262.method_5428(this.getItems(), (int)slot);
        if (!result.method_7960()) {
            this.method_5431();
            this.onContentsChanged(slot);
        }
        return result;
    }

    default public void method_5447(int slot, class_1799 stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.method_7947() > this.getMaxCountForSlot(slot)) {
            stack.method_7939(stack.method_7914());
        }
        this.onContentsChanged(slot);
    }

    default public void method_5448() {
        this.getItems().clear();
    }

    default public void method_5431() {
    }

    default public boolean method_5443(class_1657 player) {
        return true;
    }

    default public void onContentsChanged(int slot) {
    }

    default public void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.method_5439()) {
            throw new SlotInvalidRangeException(slot, this.method_5439());
        }
    }

    default public class_1799 insertStack(int slot, class_1799 stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.method_7960() || !this.method_5437(slot, stack)) {
            return stack;
        }
        class_1799 invItemStack = this.method_5438(slot);
        int limit = this.getStackLimit(slot, invItemStack);
        if (!invItemStack.method_7960()) {
            if (!ItemStackInventory.canBeStacked(stack, invItemStack)) {
                return stack;
            }
            limit -= invItemStack.method_7947();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.method_7947() > limit;
        if (!simulate) {
            if (invItemStack.method_7960()) {
                this.method_5447(slot, reachedLimit ? ItemStackInventory.copyStackWithNewSize(stack, limit) : stack);
            } else {
                invItemStack.method_7933(reachedLimit ? limit : stack.method_7947());
            }
            this.onContentsChanged(slot);
            this.method_5431();
        }
        return reachedLimit ? ItemStackInventory.copyStackWithNewSize(stack, stack.method_7947() - limit) : class_1799.field_8037;
    }

    default public int getMaxCountForSlot(int slot) {
        return 64;
    }

    default public int getStackLimit(int slot, class_1799 stack) {
        return Math.min(this.getMaxCountForSlot(slot), stack.method_7914());
    }

    default public void readInventoryNbt(class_2487 tag) {
        class_1262.method_5429((class_2487)tag.method_10562("Inventory"), this.getItems());
    }

    default public void writeInventoryNbt(class_2487 tag) {
        tag.method_10566("Inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), this.getItems()));
    }
}

