/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_756;
import net.minecraft.class_953;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import tech.alexnijjar.endermanoverhaul.EndermanOverhaul;
import tech.alexnijjar.endermanoverhaul.client.config.EndermanOverhaulClientConfig;
import tech.alexnijjar.endermanoverhaul.client.particles.EndermanParticle;
import tech.alexnijjar.endermanoverhaul.client.renderer.EndIslandsEndermanRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.EnderBulletRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.MushroomFieldsEndermanRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.ReplacedEndermanRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.base.BaseEndermanEntityRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.items.CorruptedShieldRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.items.HoodRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.summons.ScarabRenderer;
import tech.alexnijjar.endermanoverhaul.client.renderer.summons.SpiritRenderer;
import tech.alexnijjar.endermanoverhaul.client.utils.ClientPlatformUtils;
import tech.alexnijjar.endermanoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModItems;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;

public class EndermanOverhaulClient {
    private static final Map<class_1792, class_756> ITEM_RENDERERS = new HashMap<class_1792, class_756>();
    private static final Map<class_1792, Supplier<GeoArmorRenderer<?>>> ARMOR_RENDERERS = new HashMap();

    public static void init() {
        EndermanOverhaul.CONFIGURATOR.registerConfig(EndermanOverhaulClientConfig.class);
        EndermanOverhaulClient.registerEntityRenderers();
        EndermanOverhaulClient.registerArmorRenderers();
        EndermanOverhaulClient.registerItemRenderers();
        EndermanOverhaulClient.registerItemProperties();
    }

    private static void registerEntityRenderers() {
        if (EndermanOverhaulClientConfig.replaceDefaultEnderman) {
            ClientPlatformUtils.registerRenderer(() -> class_1299.field_6091, ReplacedEndermanRenderer::new);
        }
        ClientPlatformUtils.registerRenderer(ModEntityTypes.BADLANDS_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.BADLANDS_ENDERMAN.get()));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.CAVE_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.CAVE_ENDERMAN.get()));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.CRIMSON_FOREST_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.CRIMSON_FOREST_ENDERMAN.get()));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.DARK_OAK_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.DARK_OAK_ENDERMAN.get(), BaseEndermanEntityRenderer.DARK_OAK_ANIMATION));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.DESERT_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.DESERT_ENDERMAN.get(), BaseEndermanEntityRenderer.DESERT_ANIMATION));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.END_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.END_ENDERMAN.get(), BaseEndermanEntityRenderer.END_ANIMATION, false));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.END_ISLANDS_ENDERMAN, EndIslandsEndermanRenderer::new);
        ClientPlatformUtils.registerRenderer(ModEntityTypes.FLOWER_FIELDS_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.FLOWER_FIELDS_ENDERMAN.get(), BaseEndermanEntityRenderer.FLOWER_FIELDS_ANIMATION));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.ICE_SPIKES_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.ICE_SPIKES_ENDERMAN.get(), BaseEndermanEntityRenderer.ICE_SPIKES_ANIMATION));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.MUSHROOM_FIELDS_ENDERMAN, MushroomFieldsEndermanRenderer::new);
        ClientPlatformUtils.registerRenderer(ModEntityTypes.NETHER_WASTES_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.NETHER_WASTES_ENDERMAN.get()));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.CORAL_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.CORAL_ENDERMAN.get(), BaseEndermanEntityRenderer.CORAL_ANIMATION));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.SAVANNA_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.SAVANNA_ENDERMAN.get()));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.SNOWY_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.SNOWY_ENDERMAN.get(), BaseEndermanEntityRenderer.SNOWY_ANIMATION));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.SOULSAND_VALLEY_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.SOULSAND_VALLEY_ENDERMAN.get(), BaseEndermanEntityRenderer.SOULSAND_VALLEY_ANIMATION, false));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.SWAMP_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.SWAMP_ENDERMAN.get()));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.WARPED_FOREST_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.WARPED_FOREST_ENDERMAN.get(), BaseEndermanEntityRenderer.WARPED_FOREST_ANIMATION));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.WINDSWEPT_HILLS_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.WINDSWEPT_HILLS_ENDERMAN.get(), BaseEndermanEntityRenderer.WINDSWEPT_HILLS_ANIMATION));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.PET_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.PET_ENDERMAN.get()));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.HAMMERHEAD_PET_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.HAMMERHEAD_PET_ENDERMAN.get()));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.AXOLOTL_PET_ENDERMAN, c -> new BaseEndermanEntityRenderer(c, (class_1299)ModEntityTypes.AXOLOTL_PET_ENDERMAN.get()));
        ClientPlatformUtils.registerRenderer(ModEntityTypes.SCARAB, ScarabRenderer::new);
        ClientPlatformUtils.registerRenderer(ModEntityTypes.SPIRIT, SpiritRenderer::new);
        ClientPlatformUtils.registerRenderer(ModEntityTypes.ENDER_BULLET, EnderBulletRenderer::new);
        ClientPlatformUtils.registerRenderer(ModEntityTypes.CORRUPTED_PEARL, class_953::new);
        ClientPlatformUtils.registerRenderer(ModEntityTypes.ANCIENT_PEARL, class_953::new);
        ClientPlatformUtils.registerRenderer(ModEntityTypes.SOUL_PEARL, class_953::new);
        ClientPlatformUtils.registerRenderer(ModEntityTypes.BUBBLE_PEARL, class_953::new);
        ClientPlatformUtils.registerRenderer(ModEntityTypes.SUMMONER_PEARL, class_953::new);
        ClientPlatformUtils.registerRenderer(ModEntityTypes.ICY_PEARL, class_953::new);
        ClientPlatformUtils.registerRenderer(ModEntityTypes.CRIMSON_PEARL, class_953::new);
        ClientPlatformUtils.registerRenderer(ModEntityTypes.WARPED_PEARL, class_953::new);
    }

    public static void onRegisterParticles(BiConsumer<class_2396<class_2400>, ClientPlatformUtils.SpriteParticleRegistration<class_2400>> register) {
        register.accept((class_2396<class_2400>)((class_2396)ModParticleTypes.DUST.get()), spriteSet -> new EndermanParticle.Provider(spriteSet, 0.7f, 0.7f, 0.7f));
        register.accept((class_2396<class_2400>)((class_2396)ModParticleTypes.SNOW.get()), EndermanParticle.Provider::new);
        register.accept((class_2396<class_2400>)((class_2396)ModParticleTypes.SAND.get()), spriteSet -> new EndermanParticle.Provider(spriteSet, 0.86f, 0.83f, 0.63f));
        register.accept((class_2396<class_2400>)((class_2396)ModParticleTypes.SOUL_FIRE_FLAME.get()), EndermanParticle.Provider::new);
        register.accept((class_2396<class_2400>)((class_2396)ModParticleTypes.BUBBLE.get()), EndermanParticle.Provider::new);
        register.accept((class_2396<class_2400>)((class_2396)ModParticleTypes.FRIENDERMAN.get()), spriteSet -> new EndermanParticle.Provider(spriteSet, 0.07f, 0.93f, 0.84f));
    }

    public static void registerArmorRenderers() {
        ARMOR_RENDERERS.put((class_1792)ModItems.BADLANDS_HOOD.get(), () -> new HoodRenderer((class_1792)ModItems.BADLANDS_HOOD.get()));
        ARMOR_RENDERERS.put((class_1792)ModItems.SAVANNAS_HOOD.get(), () -> new HoodRenderer((class_1792)ModItems.SAVANNAS_HOOD.get()));
        ARMOR_RENDERERS.put((class_1792)ModItems.SNOWY_HOOD.get(), () -> new HoodRenderer((class_1792)ModItems.SNOWY_HOOD.get()));
    }

    private static void registerItemRenderers() {
        ITEM_RENDERERS.put(((class_1792)ModItems.CORRUPTED_SHIELD.get()).method_8389(), (class_756)new CorruptedShieldRenderer());
    }

    public static void registerItemProperties() {
        ClientPlatformUtils.registerItemProperty((class_1792)ModItems.CORRUPTED_SHIELD.get(), new class_2960("blocking"), (stack, level, entity, i) -> entity != null && entity.method_6115() && entity.method_6030() == stack ? 1.0f : 0.0f);
    }

    public static GeoArmorRenderer<?> getArmorRenderer(class_1935 item) {
        return ARMOR_RENDERERS.get(item.method_8389()).get();
    }

    public static class_756 getItemRenderer(class_1935 item) {
        return ITEM_RENDERERS.get(item.method_8389());
    }
}

