/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.shrek.entity.task;

import java.util.function.Consumer;
import net.minecraft.class_3218;
import net.pixeldreamstudios.shrek.entity.OgreEntity;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;

public abstract class CustomDelayedMeleeBehaviour<E extends OgreEntity>
extends ExtendedBehaviour<E> {
    protected final int delayTime;
    protected long delayFinishedAt = 0L;
    protected Consumer<E> delayedCallback = entity -> {};

    public CustomDelayedMeleeBehaviour(int delayTicks) {
        this.delayTime = delayTicks;
        this.runFor(entity -> Math.max(delayTicks, 60));
    }

    public final CustomDelayedMeleeBehaviour<E> whenActivating(Consumer<E> callback) {
        this.delayedCallback = callback;
        return this;
    }

    protected final void start(class_3218 level, E entity, long gameTime) {
        if (this.delayTime > 0) {
            this.delayFinishedAt = gameTime + (long)this.delayTime;
            super.method_18920(level, entity, gameTime);
        } else {
            super.method_18920(level, entity, gameTime);
            this.doDelayedAction(entity);
        }
        entity.triggerAnim("attackController", entity.method_6051().method_43056() ? "attack" : "attack2");
    }

    protected final void stop(class_3218 level, E entity, long gameTime) {
        super.method_18926(level, entity, gameTime);
        this.delayFinishedAt = 0L;
        ((OgreEntity)((Object)entity)).setAttackingState(0);
    }

    protected boolean shouldKeepRunning(E entity) {
        return this.delayFinishedAt >= entity.method_37908().method_8510();
    }

    protected final void tick(class_3218 level, E entity, long gameTime) {
        super.method_18924(level, entity, gameTime);
        if (this.delayFinishedAt <= gameTime) {
            this.doDelayedAction(entity);
            this.delayedCallback.accept(entity);
        }
    }

    protected void doDelayedAction(E entity) {
    }
}

