/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.world.placement;

import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.world.feature.MineCellsStructurePlacementTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2919;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6874;
import net.minecraft.class_6875;
import net.minecraft.class_7869;

public class InsideGridPlacement
extends class_6874 {
    private static final Map<CacheKey, List<class_1923>> CACHE = new ConcurrentHashMap<CacheKey, List<class_1923>>(512);
    private static long cachedSeed = 0L;
    public static final Codec<InsideGridPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2382.method_39677((int)16).optionalFieldOf("locate_offset", (Object)class_2382.field_11176).forGetter(rec$ -> ((InsideGridPlacement)((Object)((Object)((Object)rec$)))).method_41642()), (App)class_5699.field_33441.optionalFieldOf("salt", (Object)0).forGetter(rec$ -> ((InsideGridPlacement)((Object)((Object)((Object)rec$)))).method_41645()), (App)class_6874.class_7152.field_37781.optionalFieldOf("exclusion_zone").forGetter(rec$ -> ((InsideGridPlacement)((Object)((Object)((Object)rec$)))).method_41646()), (App)class_5699.field_33441.optionalFieldOf("grid_size", (Object)64).forGetter(p -> p.gridSize), (App)class_5699.field_33441.fieldOf("min_distance").forGetter(p -> p.minDistance), (App)class_5699.field_33441.fieldOf("max_distance").forGetter(p -> p.maxDistance), (App)class_5699.field_33442.optionalFieldOf("max_count", (Object)1).forGetter(p -> p.maxCount), (App)class_5699.field_33441.optionalFieldOf("separation", (Object)0).forGetter(p -> p.separation)).apply((Applicative)instance, InsideGridPlacement::new));
    private final int gridSize;
    private final int minDistance;
    private final int maxDistance;
    private final int maxCount;
    private final int separation;

    protected InsideGridPlacement(class_2382 locateOffset, int salt, Optional<class_6874.class_7152> exclusionZone, int gridSize, int minDistance, int maxDistance, int maxCount, int separation) {
        super(locateOffset, class_6874.class_7154.field_37782, 1.0f, salt, exclusionZone);
        this.gridSize = gridSize;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.maxCount = maxCount;
        this.separation = separation;
    }

    protected boolean method_40168(class_7869 calculator, int chunkX, int chunkZ) {
        class_2382 center = MathUtils.getClosestMultiplePosition(new class_2382(chunkX, 0, chunkZ), this.gridSize);
        class_1923 centerChunkPos = new class_1923(center.method_10263(), center.method_10260());
        return this.getStartChunks(centerChunkPos, calculator.method_46714()).contains(new class_1923(chunkX, chunkZ));
    }

    protected List<class_1923> getStartChunks(class_1923 center, long seed) {
        CacheKey key;
        if (CACHE.size() >= 512 || seed != cachedSeed) {
            CACHE.clear();
            cachedSeed = seed;
        }
        if (CACHE.containsKey(key = new CacheKey(center, seed, this.method_41645()))) {
            return CACHE.get(key);
        }
        List<class_1923> candidateChunks = this.generateCandidateChunks(center, this.minDistance, this.maxDistance);
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(seed + (long)this.method_41645(), center.field_9181, center.field_9180);
        List<class_1923> result = this.pickStartChunks(candidateChunks, this.maxCount, (class_5819)random);
        CACHE.put(key, result);
        return result;
    }

    protected List<class_1923> pickStartChunks(List<class_1923> chunks, int count, class_5819 random) {
        if (count >= chunks.size()) {
            return chunks;
        }
        ArrayList<class_1923> result = new ArrayList<class_1923>();
        ArrayList<class_1923> selection = new ArrayList<class_1923>(chunks);
        for (int i = 0; i < count && selection.size() > 0; ++i) {
            int randomIndex = random.method_43048(selection.size());
            result.add(selection.get(randomIndex));
            selection.remove(randomIndex);
            if (this.separation <= 0) continue;
            this.removeBySeparation(selection, this.separation, result.get(i));
        }
        return result;
    }

    protected void removeBySeparation(List<class_1923> chunks, int separation, class_1923 pos) {
        chunks.removeIf(chunk -> pos.method_24022(chunk) <= separation);
    }

    protected List<class_1923> generateCandidateChunks(class_1923 center, int minDistance, int maxDistance) {
        ArrayList<class_1923> list = new ArrayList<class_1923>();
        for (int i = minDistance; i <= maxDistance; ++i) {
            list.addAll(this.generateCandidateChunks(center, i));
        }
        return list;
    }

    protected List<class_1923> generateCandidateChunks(class_1923 center, int distance) {
        if (distance == 0) {
            return List.of(center);
        }
        HashSet<class_1923> set = new HashSet<class_1923>();
        int x = center.field_9181;
        int z = center.field_9180;
        for (int i = -distance; i <= distance; ++i) {
            set.add(new class_1923(x - distance, z + i));
            set.add(new class_1923(x + distance, z + i));
            set.add(new class_1923(x + i, z - distance));
            set.add(new class_1923(x + i, z + distance));
        }
        return List.copyOf(set);
    }

    public class_6875<?> method_40166() {
        return MineCellsStructurePlacementTypes.INSIDE_GRID;
    }

    public class_2338 getClosestPosition(class_1923 pos, long worldSeed) {
        class_2382 center = MathUtils.getClosestMultiplePosition(new class_2382(pos.field_9181, 0, pos.field_9180), this.gridSize);
        List<class_1923> startChunks = this.getStartChunks(new class_1923(center.method_10263(), center.method_10260()), worldSeed);
        if (startChunks.isEmpty()) {
            return null;
        }
        class_1923 closest = startChunks.get(0);
        for (class_1923 chunk : startChunks) {
            int distance = pos.method_24022(chunk);
            if (distance >= closest.method_24022(pos)) continue;
            closest = chunk;
        }
        return new class_2338(closest.field_9181 * 16 + this.method_41642().method_10263(), this.method_41642().method_10264(), closest.field_9180 * 16 + this.method_41642().method_10260());
    }

    private record CacheKey(class_1923 center, long seed, long salt) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                return this.center.equals((Object)other.center) && this.seed == other.seed && this.salt == other.salt;
            }
            return false;
        }
    }
}

