/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item.weapon;

import com.github.mim1q.minecells.item.weapon.interfaces.WeaponWithAbility;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.registry.MineCellsStatusEffects;
import com.github.mim1q.minecells.util.ParticleUtils;
import com.github.mim1q.minecells.valuecalculators.ModValueCalculators;
import dev.mim1q.gimm1q.valuecalculators.ValueCalculator;
import java.util.HashSet;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_5328;
import net.minecraft.class_638;

public class FrostBlastItem
extends class_1792
implements WeaponWithAbility {
    private static final ValueCalculator ABILITY_DAMAGE_CALCULATOR = ModValueCalculators.of("spells/frost_blast", "damage", 0.0);
    private static final ValueCalculator ABILITY_COOLDOWN_CALCULATOR = ModValueCalculators.of("spells/frost_blast", "cooldown", 0.0);

    public FrostBlastItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        stack.method_7956(1, user, e -> e.method_20236(user.method_6058()));
        user.method_5783(MineCellsSounds.FROST_BLAST, 1.0f, 1.1f);
        if (user.method_37908().method_8608()) {
            for (int i = 0; i < 20; ++i) {
                class_243 pos = user.method_19538().method_1031(0.0, 1.25, 0.0);
                class_243 vel = class_243.method_1030((float)(user.method_36455() + (user.method_6051().method_43057() - 0.5f) * 45.0f), (float)(user.method_36454() + (user.method_6051().method_43057() - 0.5f) * 45.0f));
                ParticleUtils.addParticle((class_638)world, (class_2394)class_2398.field_28013, pos, vel.method_1021(0.25 + user.method_6051().method_43058() * 0.25).method_1031(0.0, 0.1, 0.0));
            }
            return stack;
        }
        if (user.method_31747()) {
            ((class_1657)user).method_7357().method_7906((class_1792)this, this.getAbilityCooldown(stack, user));
        }
        HashSet entities = new HashSet();
        for (int i = 1; i <= 3; ++i) {
            class_243 searchPos = user.method_19538().method_1019(user.method_5720().method_1021((double)((float)i * 1.5f)));
            class_238 searchBox = class_238.method_30048((class_243)searchPos, (double)(1.0 + 0.75 * (double)i), (double)1.5, (double)(1.0 + 0.75 * (double)i));
            entities.addAll(world.method_8390(class_1309.class, searchBox, e -> e != user));
        }
        for (class_1309 entity : entities) {
            FrostBlastItem.applyFreeze(entity);
            entity.method_5643(world.method_48963().method_48836(), this.getAbilityDamage(stack, user, entity));
        }
        return stack;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 20;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public static void applyFreeze(class_1309 entity) {
        int duration = 100;
        class_1937 world = entity.method_37908();
        if (world.method_8320(entity.method_24515()).method_26227().method_15767(class_3486.field_15517)) {
            world.method_8501(entity.method_24515(), class_2246.field_10295.method_9564());
            duration = 200;
        }
        entity.method_5783(MineCellsSounds.FREEZE, 1.0f, 1.0f);
        entity.method_6092(new class_1293(MineCellsStatusEffects.FROZEN, duration, 0, false, false, true));
    }

    @Override
    public ValueCalculator getAbilityDamageCalculator() {
        return ABILITY_DAMAGE_CALCULATOR;
    }

    @Override
    public ValueCalculator getAbilityCooldownCalculator() {
        return ABILITY_COOLDOWN_CALCULATOR;
    }
}

