/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity;

import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.entity.ai.goal.JumpBackGoal;
import com.github.mim1q.minecells.entity.ai.goal.ShockwaveGoal;
import com.github.mim1q.minecells.entity.ai.goal.TimedActionGoal;
import com.github.mim1q.minecells.entity.ai.goal.WalkTowardsTargetGoal;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class SweeperEntity
extends MineCellsEntity {
    private int sweepCooldown = 0;
    private int jumpbackCooldown = 0;
    private class_243 gauntletPosition = this.method_19538();
    private static final class_243 GAUNTLET_OFFSET = new class_243(-0.75, 0.2, -0.9);
    public final AnimationProperty sweepCharge = new AnimationProperty(0.0f);
    public final AnimationProperty sweepRelease = new AnimationProperty(0.0f, MathUtils::easeOutBack);
    public final AnimationProperty rollCharge = new AnimationProperty(0.0f);
    public float rollAnimation = 0.0f;
    public float lastRollAnimation = 0.0f;
    private static final class_2940<Boolean> SWEEP_CHARGING = class_2945.method_12791(SweeperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SWEEP_RELEASING = class_2945.method_12791(SweeperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> JUMPBACK_RELEASING = class_2945.method_12791(SweeperEntity.class, (class_2941)class_2943.field_13323);

    public SweeperEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new SweeperMoveControl((class_1308)this);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(2, (class_1352)new WalkTowardsTargetGoal((class_1314)this, 1.0, false, 5.0));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 16.0f));
        this.field_6201.method_6277(0, new ShockwaveGoal<SweeperEntity>(this, settings -> {
            settings.cooldownGetter = () -> this.sweepCooldown;
            settings.cooldownSetter = cooldown -> {
                this.sweepCooldown = cooldown;
            };
            settings.defaultCooldown = 40;
            settings.chance = 0.1f;
            settings.stateSetter = (state, value) -> this.handleStateChange((TimedActionGoal.State)((Object)((Object)state)), (boolean)value, SWEEP_CHARGING, SWEEP_RELEASING);
            settings.actionTick = 20;
            settings.length = 40;
            settings.chargeSound = MineCellsSounds.SWEEPER_CHARGE;
            settings.releaseSound = MineCellsSounds.SWEEPER_RELEASE;
            settings.shockwaveBlock = MineCellsBlocks.SHOCKWAVE_FLAME;
            settings.shockwaveDamage = 6.0f;
            settings.shockwaveInterval = 1.0f;
        }, e -> e.method_5968() != null && Math.abs(e.method_5968().method_23318() - e.method_23318()) < 2.0 && (e.field_6189.method_6345() != null && e.field_6189.method_6345().method_21655() || e.method_5858((class_1297)e.method_5968()) < 25.0)));
        this.field_6201.method_6277(1, new JumpBackGoal<SweeperEntity>(this, s -> {
            s.backStrength = 1.25;
            s.minDistance = 4.0;
            s.upStrength = 0.1;
            s.defaultCooldown = 40;
            s.actionTick = 10;
            s.length = 20;
            s.chance = 0.3f;
            s.cooldownGetter = () -> this.jumpbackCooldown;
            s.cooldownSetter = ticks -> {
                this.jumpbackCooldown = ticks;
            };
            s.stateSetter = (state, value) -> {
                if (state == TimedActionGoal.State.RELEASE) {
                    this.field_6011.method_12778(JUMPBACK_RELEASING, value);
                }
            };
        }, (Predicate<SweeperEntity>)null));
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SWEEP_CHARGING, (Object)false);
        this.field_6011.method_12784(SWEEP_RELEASING, (Object)false);
        this.field_6011.method_12784(JUMPBACK_RELEASING, (Object)false);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        --this.sweepCooldown;
        --this.jumpbackCooldown;
        if (this.method_37908().field_9236) {
            class_243 lastGauntletPosition = this.gauntletPosition;
            this.gauntletPosition = this.method_19538().method_1019(MathUtils.vectorRotateY(GAUNTLET_OFFSET, MathUtils.radians(this.method_43078())));
            this.spawnGauntletParticles(lastGauntletPosition.method_1025(this.gauntletPosition) > 1.0E-4);
            if (((Boolean)this.field_6011.method_12789(SWEEP_CHARGING)).booleanValue()) {
                this.sweepCharge.setupTransitionTo(1.0f, 10.0f);
            } else {
                this.sweepCharge.setupTransitionTo(0.0f, 8.0f);
            }
            if (((Boolean)this.field_6011.method_12789(SWEEP_RELEASING)).booleanValue()) {
                this.sweepRelease.setupTransitionTo(1.0f, 15.0f, MathUtils::easeOutBack);
            } else {
                this.sweepRelease.setupTransitionTo(0.0f, 20.0f, MathUtils::easeInOutQuad);
            }
            this.lastRollAnimation = this.rollAnimation;
            if (((Boolean)this.field_6011.method_12789(JUMPBACK_RELEASING)).booleanValue()) {
                this.rollCharge.setupTransitionTo(1.0f, 2.0f);
                this.rollAnimation += 30.0f;
            } else {
                this.rollCharge.setupTransitionTo(0.0f, 10.0f);
                int nearest360 = MathUtils.getClosestMultiple((int)this.rollAnimation, 360);
                this.rollAnimation = MathUtils.lerp(this.rollAnimation, nearest360, 0.1f);
            }
        }
    }

    public float getRollAnimation(float tickDelta) {
        return MathUtils.lerp(this.lastRollAnimation, this.rollAnimation, tickDelta);
    }

    private void spawnGauntletParticles(boolean moving) {
        class_243 pos;
        class_243 randomOffset;
        float chance;
        float f = chance = moving ? 1.0f : 0.1f;
        if (this.field_5974.method_43057() < chance) {
            randomOffset = new class_243(this.field_5974.method_43058() - 0.5, this.field_5974.method_43058() - 0.5, this.field_5974.method_43058() - 0.5).method_1021(0.5);
            pos = this.gauntletPosition.method_1019(randomOffset);
            this.method_37908().method_8406((class_2394)class_2398.field_11240, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.01, 0.0);
        }
        if (moving) {
            randomOffset = new class_243(this.field_5974.method_43058() - 0.5, 0.0, this.field_5974.method_43058() - 0.5).method_1021(0.5);
            pos = this.gauntletPosition.method_1019(randomOffset);
            this.method_37908().method_8406((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.01, 0.0);
        }
    }

    public static class_5132.class_5133 createSweeperAttributes() {
        return SweeperEntity.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.19).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23717, 18.0).method_26868(class_5134.field_23718, 0.5);
    }

    private static class SweeperMoveControl
    extends class_1335 {
        public SweeperMoveControl(class_1308 entity) {
            super(entity);
        }

        public void method_6240() {
            if (this.field_6371.field_6012 % 30 == 0 && this.field_6374 == class_1335.class_1336.field_6378) {
                this.field_6371.method_5783(class_3417.field_16865, 1.0f, 1.0f);
            }
            if (this.field_6371.field_6012 % 30 <= 15) {
                super.method_6240();
            } else {
                this.field_6371.method_6125(0.0f);
            }
        }
    }
}

