/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity;

import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.entity.ai.goal.JumpBackGoal;
import com.github.mim1q.minecells.entity.ai.goal.ShootGoal;
import com.github.mim1q.minecells.entity.ai.goal.WalkTowardsTargetGoal;
import com.github.mim1q.minecells.entity.interfaces.IShootEntity;
import com.github.mim1q.minecells.entity.nonliving.projectile.GrenadeEntity;
import com.github.mim1q.minecells.registry.MineCellsEntities;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class GrenadierEntity
extends MineCellsEntity
implements IShootEntity {
    public final AnimationProperty additionalRotation = new AnimationProperty(0.0f);
    private static final class_2940<Integer> SHOOT_COOLDOWN = class_2945.method_12791(GrenadierEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SHOOT_CHARGING = class_2945.method_12791(GrenadierEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHOOT_RELEASING = class_2945.method_12791(GrenadierEntity.class, (class_2941)class_2943.field_13323);
    private int jumpbackCooldown = 0;

    public GrenadierEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHOOT_COOLDOWN, (Object)50);
        this.field_6011.method_12784(SHOOT_CHARGING, (Object)false);
        this.field_6011.method_12784(SHOOT_RELEASING, (Object)false);
    }

    @Override
    public void method_5959() {
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, 0, false, false, null));
        this.field_6201.method_6277(1, (class_1352)new GrenadierShootGoal(this, 10, 20));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 16.0f));
        this.field_6201.method_6277(2, (class_1352)new WalkTowardsTargetGoal((class_1314)this, 1.0, true, 6.0));
        this.field_6201.method_6277(1, new JumpBackGoal<GrenadierEntity>(this, s -> {
            s.minDistance = 5.0;
            s.defaultCooldown = 20;
            s.actionTick = 10;
            s.length = 20;
            s.chance = 0.3f;
            s.cooldownGetter = () -> this.jumpbackCooldown;
            s.cooldownSetter = ticks -> {
                this.jumpbackCooldown = ticks;
            };
        }, (Predicate<GrenadierEntity>)null));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    protected void clientTick() {
        if (this.isShootCharging()) {
            this.additionalRotation.setupTransitionTo(240.0f, 15.0f);
        } else if (this.isShootReleasing()) {
            this.additionalRotation.setupTransitionTo(-30.0f, 10.0f);
        } else {
            this.additionalRotation.setupTransitionTo(0.0f, 20.0f);
        }
    }

    protected void serverTick() {
        this.decrementCooldown(SHOOT_COOLDOWN);
        --this.jumpbackCooldown;
    }

    public int method_5850() {
        return 3;
    }

    @Override
    public boolean isShootReleasing() {
        return (Boolean)this.field_6011.method_12789(SHOOT_RELEASING);
    }

    @Override
    public void setShootReleasing(boolean releasing) {
        this.field_6011.method_12778(SHOOT_RELEASING, (Object)releasing);
    }

    @Override
    public boolean isShootCharging() {
        return (Boolean)this.field_6011.method_12789(SHOOT_CHARGING);
    }

    @Override
    public void setShootCharging(boolean charging) {
        this.field_6011.method_12778(SHOOT_CHARGING, (Object)charging);
    }

    @Override
    public int getShootCooldown() {
        return (Integer)this.field_6011.method_12789(SHOOT_COOLDOWN);
    }

    @Override
    public void setShootCooldown(int ticks) {
        this.field_6011.method_12778(SHOOT_COOLDOWN, (Object)ticks);
    }

    @Override
    public int getShootMaxCooldown() {
        return 20 + this.field_5974.method_43048(40);
    }

    @Override
    public class_3414 getShootChargeSoundEvent() {
        return MineCellsSounds.GRENADIER_CHARGE;
    }

    @Override
    public class_3414 getShootReleaseSoundEvent() {
        return null;
    }

    @Override
    protected class_3414 method_6002() {
        return MineCellsSounds.LEAPING_ZOMBIE_DEATH;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("shootCooldown", this.getShootCooldown());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setShootCooldown(nbt.method_10550("shootCooldown"));
    }

    public static class_5132.class_5133 createGrenadierAttributes() {
        return GrenadierEntity.method_26827().method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23724, 4.0);
    }

    public static class GrenadierShootGoal
    extends ShootGoal<GrenadierEntity> {
        public GrenadierShootGoal(GrenadierEntity entity, int actionTick, int lengthTicks) {
            super(entity, actionTick, lengthTicks, 0.3f);
        }

        @Override
        public void shoot(class_1309 target) {
            super.shoot(target);
            class_243 targetPos = target.method_19538().method_1031(((GrenadierEntity)this.entity).field_5974.method_43058() * 2.0 - 1.0, 0.0, ((GrenadierEntity)this.entity).field_5974.method_43058() * 2.0 - 1.0);
            class_243 entityPos = ((GrenadierEntity)this.entity).method_19538();
            class_243 delta = targetPos.method_1020(entityPos).method_1021(0.035).method_1031(0.0, 0.5, 0.0);
            GrenadeEntity grenade = new GrenadeEntity(MineCellsEntities.GRENADE, ((GrenadierEntity)this.entity).method_37908());
            grenade.method_33574(entityPos.method_1031(0.0, 1.5, 0.0));
            grenade.method_7432((class_1297)this.entity);
            grenade.shoot(delta);
            ((GrenadierEntity)this.entity).method_37908().method_8649((class_1297)grenade);
        }
    }
}

