/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.handler;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.config.Config;
import com.bawnorton.neruina.exception.TickingException;
import com.bawnorton.neruina.extend.Errorable;
import com.bawnorton.neruina.handler.MessageHandler;
import com.bawnorton.neruina.handler.client.ClientTickHandler;
import com.bawnorton.neruina.mixin.accessor.WorldChunkAccessor;
import com.bawnorton.neruina.platform.Platform;
import com.bawnorton.neruina.util.ErroredType;
import com.bawnorton.neruina.util.MultiSetMap;
import com.bawnorton.neruina.util.TickingEntry;
import com.bawnorton.neruina.version.Texter;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class TickHandler {
    private final List<TickingEntry> recentErrors = new ArrayList<TickingEntry>();
    private final Map<UUID, TickingEntry> tickingEntries = new HashMap<UUID, TickingEntry>();
    private final MultiSetMap<class_2680, class_2338> erroredBlockStates = new MultiSetMap();
    private int stopwatch = 0;

    public void tick() {
        ++this.stopwatch;
        if (this.stopwatch >= 600) {
            if (!this.recentErrors.isEmpty()) {
                this.recentErrors.remove(0);
            }
            this.stopwatch = 0;
        }
    }

    public void init() {
        this.tickingEntries.clear();
        this.recentErrors.clear();
    }

    public void safelyTickItemStack(class_1799 instance, class_1937 world, class_1297 entity, int slot, boolean selected, Operation<Void> original) {
        try {
            if (this.isErrored(instance)) {
                return;
            }
            original.call(new Object[]{instance, world, entity, slot, selected});
        }
        catch (Throwable e) {
            this.handleTickingItemStack(e, instance, !world.method_8608(), (class_1657)entity, slot);
        }
    }

    public void safelyTickItemStack(class_1799 instance, class_1937 world, class_1657 player, int slot, int selected, Operation<Void> original) {
        try {
            if (this.isErrored(instance)) {
                return;
            }
            original.call(new Object[]{instance, world, player, slot, selected});
        }
        catch (Throwable e) {
            this.handleTickingItemStack(e, instance, !world.method_8608(), player, slot);
        }
    }

    public void safelyTickEntities(Consumer<Object> instance, class_1297 entity, Operation<Void> original) {
        try {
            if (this.isErrored(entity)) {
                this.handleErroredEntity(entity);
                return;
            }
            original.call(new Object[]{instance, entity});
        }
        catch (TickingException e) {
            throw e;
        }
        catch (Throwable e) {
            if (!Config.getInstance().handleTickingEntities.booleanValue()) {
                throw TickingException.notHandled("handle_ticking_entities", e);
            }
            this.handleTickingEntity(entity, e);
        }
    }

    public <T extends class_1297> void safelyTickEntities(Consumer<T> consumer, T entity, class_1937 world, Object random, Operation<Void> original) {
        try {
            if (this.isErrored(entity)) {
                this.handleErroredEntity(entity);
                return;
            }
            original.call(new Object[]{consumer, entity, world, random});
        }
        catch (TickingException e) {
            throw e;
        }
        catch (Throwable e) {
            if (!Config.getInstance().handleTickingEntities.booleanValue()) {
                throw TickingException.notHandled("handle_ticking_entities", e);
            }
            this.handleTickingEntity(entity, e);
        }
    }

    public void safelyTickPlayer(class_3222 instance, Operation<Void> original) {
        try {
            original.call(new Object[]{instance});
        }
        catch (Throwable e) {
            if (!Config.getInstance().handleTickingPlayers.booleanValue()) {
                throw TickingException.notHandled("handle_ticking_players", e);
            }
            this.handleTickingPlayer(instance, e);
        }
    }

    public void safelyTickBlockState(class_2680 instance, class_3218 world, class_2338 pos, Object random, Operation<Void> original) {
        try {
            if (this.isErrored(instance, pos)) {
                return;
            }
            original.call(new Object[]{instance, world, pos, random});
        }
        catch (Throwable e) {
            if (!Config.getInstance().handleTickingBlockStates.booleanValue()) {
                throw TickingException.notHandled("handle_ticking_block_states", e);
            }
            MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
            class_2561 message = messageHandler.formatText("neruina.ticking.block_state", instance.method_26204().method_9518().getString(), messageHandler.posAsNums(pos));
            Neruina.LOGGER.warn("Neruina Caught An Exception, see below for cause", e);
            this.addErrored(instance, pos);
            TickingEntry tickingEntry = new TickingEntry(instance, true, (class_5321<class_1937>)world.method_27983(), pos, e);
            this.trackError(tickingEntry);
            messageHandler.broadcastToPlayers(world.method_8503(), message, messageHandler.generateHandlingActions(ErroredType.BLOCK_STATE, (class_5321<class_1937>)world.method_27983(), pos), messageHandler.generateResourceActions(tickingEntry));
        }
    }

    public void safelyTickBlockEntity(class_5558<? extends class_2586> instance, class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity, Operation<Void> original) {
        block5: {
            try {
                if (this.isErrored(blockEntity)) {
                    if (world.method_8608()) {
                        return;
                    }
                    class_2818 chunk = world.method_8500(pos);
                    ((WorldChunkAccessor)chunk).invokeRemoveBlockEntityTicker(pos);
                    return;
                }
                original.call(new Object[]{instance, world, pos, state, blockEntity});
            }
            catch (Throwable e) {
                if (!Config.getInstance().handleTickingBlockEntities.booleanValue()) {
                    throw TickingException.notHandled("handle_ticking_block_entities", e);
                }
                MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
                class_2561 message = messageHandler.formatText("neruina.ticking.block_entity", state.method_26204().method_9518().getString(), messageHandler.posAsNums(pos));
                Neruina.LOGGER.warn("Neruina caught an exception, see below for cause", e);
                this.addErrored(blockEntity);
                if (world.method_8608()) break block5;
                TickingEntry tickingEntry = new TickingEntry(blockEntity, true, (class_5321<class_1937>)world.method_27983(), pos, e);
                this.trackError((Errorable)blockEntity, tickingEntry);
                messageHandler.broadcastToPlayers(world.method_8503(), message, messageHandler.generateHandlingActions(ErroredType.BLOCK_ENTITY, (class_5321<class_1937>)world.method_27983(), pos), messageHandler.generateResourceActions(tickingEntry));
            }
        }
    }

    private void handleTickingItemStack(Throwable e, class_1799 instance, boolean isServer, class_1657 player, int slot) {
        if (!Config.getInstance().handleTickingItemStacks.booleanValue()) {
            throw TickingException.notHandled("handle_ticking_item_stacks", e);
        }
        Neruina.LOGGER.warn("Neruina caught an exception, see below for cause", e);
        this.addErrored(instance);
        if (isServer) {
            TickingEntry tickingEntry = new TickingEntry(instance, false, (class_5321<class_1937>)player.method_37908().method_27983(), player.method_24515(), e);
            this.trackError((Errorable)instance, tickingEntry);
            MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
            messageHandler.sendToPlayer(player, Texter.translatable("neruina.ticking.item_stack", instance.method_7964().getString(), slot), messageHandler.generateResumeAction(ErroredType.ITEM_STACK, player.method_5845()), messageHandler.generateResourceActions(tickingEntry));
        }
    }

    private void handleErroredEntity(class_1297 entity) {
        try {
            if (entity instanceof class_1657) {
                return;
            }
            if (entity.method_37908().method_8608()) {
                return;
            }
            entity.method_5670();
            if (Config.getInstance().autoKillTickingEntities.booleanValue() || !entity.method_5805()) {
                this.killEntity(entity, null);
            }
        }
        catch (Throwable e) {
            try {
                this.killEntity(entity, Neruina.getInstance().getMessageHandler().formatText("neruina.ticking.entity.suspend_failed", entity.method_5477().getString()));
            }
            catch (Throwable ex) {
                throw new TickingException("Exception occurred while handling errored entity", ex);
            }
        }
    }

    public void killEntity(class_1297 entity, @Nullable class_2561 withMessage) {
        entity.method_5768();
        entity.method_5650(class_1297.class_5529.field_26998);
        this.removeErrored(entity);
        if (withMessage != null) {
            Neruina.getInstance().getMessageHandler().broadcastToPlayers(entity.method_5682(), withMessage);
        }
    }

    private void handleTickingEntity(class_1297 entity, Throwable e) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.handleTickingPlayer(serverPlayer, e);
            } else {
                this.handleTickingClient(player, e);
            }
            return;
        }
        Neruina.LOGGER.warn("Neruina caught an exception, see below for cause", e);
        this.addErrored(entity);
        class_1937 world = entity.method_37908();
        if (!world.method_8608()) {
            class_2338 pos = entity.method_24515();
            TickingEntry tickingEntry = new TickingEntry(entity, true, (class_5321<class_1937>)world.method_27983(), pos, e);
            this.trackError((Errorable)entity, tickingEntry);
            MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
            class_2561 message = messageHandler.formatText("neruina.ticking.entity.%s".formatted(Config.getInstance().autoKillTickingEntities != false ? "killed" : "suspended"), entity.method_5477().getString(), messageHandler.posAsNums(pos));
            class_2561 actions = messageHandler.generateResourceActions(tickingEntry);
            if (!Config.getInstance().autoKillTickingEntities.booleanValue()) {
                actions = Texter.concatDelimited(Texter.LINE_BREAK, messageHandler.generateEntityActions(entity), actions);
            }
            messageHandler.broadcastToPlayers(entity.method_5682(), message, actions);
        }
    }

    private void handleTickingPlayer(class_3222 player, Throwable e) {
        Neruina.LOGGER.warn("Neruina caught an exception, see below for cause", e);
        MinecraftServer server = player.method_5682();
        String name = player.method_5476() == null ? player.method_5477().getString() : player.method_5476().getString();
        MessageHandler messageHandler = Neruina.getInstance().getMessageHandler();
        class_2561 message = messageHandler.formatText("neruina.ticking.player", name);
        TickingEntry tickingEntry = new TickingEntry(player, false, (class_5321<class_1937>)player.method_37908().method_27983(), player.method_24515(), e);
        this.trackError(tickingEntry);
        messageHandler.broadcastToPlayers(server, message, messageHandler.generateResourceActions(tickingEntry));
        try {
            player.field_13987.method_14367(Texter.concat(Texter.translatable("neruina.kick.message", new Object[0]), Texter.translatable("neruina.kick.reason", new Object[0])));
        }
        catch (NullPointerException ex) {
            Neruina.LOGGER.error("Neruina caught an exception on a player, but the player is not connected, this should not happen. Behaviour is undefined.", (Throwable)ex);
        }
    }

    private void handleTickingClient(class_1657 player, Throwable e) {
        if (player.method_37908().method_8608() || Platform.isClient()) {
            ClientTickHandler.handleTickingClient(player, e);
        } else {
            Neruina.LOGGER.error("Neruina caught an exception, but the player is not a server player, this should not happen. Behaviour is undefined.", e);
        }
    }

    private void trackError(TickingEntry entry) {
        this.trackError(null, entry);
    }

    private void trackError(@Nullable Errorable errorable, TickingEntry entry) {
        this.recentErrors.add(entry);
        this.addTickingEntry(entry);
        if (errorable != null) {
            errorable.neruina$setTickingEntryId(entry.uuid());
        }
        if (Config.getInstance().tickingExceptionThreshold != -1 && this.recentErrors.size() >= Config.getInstance().tickingExceptionThreshold) {
            class_128 report = class_128.method_560((Throwable)new RuntimeException("Too Many Ticking Exceptions"), (String)"Neruina has caught too many ticking exceptions in a short period of time, something is very wrong, see below for more info");
            class_129 header = report.method_562("Information");
            header.method_578("Threshold", (Object)"%d, set \"ticking_exception_threshold\" to -1 to disable.".formatted(Config.getInstance().tickingExceptionThreshold));
            header.method_578("Caught", (Object)this.recentErrors.size());
            String wiki = "https://github.com/Bawnorton/Neruina/wiki/Too-Many-Ticking-Exceptions";
            String lines = "=".repeat(wiki.length() + "Wiki".length() + 2);
            header.method_578("", (Object)lines);
            header.method_578("Wiki", (Object)wiki);
            header.method_578("", (Object)lines);
            for (int i = 0; i < this.recentErrors.size(); ++i) {
                TickingEntry error = this.recentErrors.get(i);
                class_129 section = report.method_562("Ticking Exception #%s - (%s: %s)".formatted(i + 1, error.getCauseType(), error.getCauseName()));
                error.populate(section);
            }
            throw new class_148(report);
        }
    }

    public boolean isErrored(Object obj) {
        if (obj instanceof Errorable) {
            Errorable errorable = (Errorable)obj;
            return errorable.neruina$isErrored();
        }
        return false;
    }

    public boolean isErrored(class_2680 state, class_2338 pos) {
        return this.erroredBlockStates.contains(state, pos);
    }

    private void addErrored(Object obj) {
        if (obj instanceof Errorable) {
            Errorable errorable = (Errorable)obj;
            errorable.neruina$setErrored();
        }
    }

    private void addErrored(class_2680 state, class_2338 pos) {
        this.erroredBlockStates.put(state, pos);
    }

    public void removeErrored(Object obj) {
        if (obj instanceof Errorable) {
            Errorable errorable = (Errorable)obj;
            errorable.neruina$clearErrored();
            this.tickingEntries.remove(errorable.neruina$getTickingEntryId());
        }
    }

    public void removeErrored(class_2680 state, class_2338 pos) {
        this.erroredBlockStates.remove(state, pos);
    }

    @Nullable
    public TickingEntry getTickingEntry(UUID uuid) {
        return this.tickingEntries.get(uuid);
    }

    public Collection<TickingEntry> getTickingEntries() {
        return this.tickingEntries.values();
    }

    public void addTickingEntry(TickingEntry entry) {
        Object cause = entry.getCause();
        boolean shouldAdd = false;
        if (this.isErrored(cause)) {
            shouldAdd = true;
        } else if (cause instanceof class_2680) {
            class_2680 state = (class_2680)cause;
            shouldAdd = this.isErrored(state, entry.pos());
        }
        if (shouldAdd) {
            this.tickingEntries.put(entry.uuid(), entry);
        }
    }

    public void addTickingEntryUnsafe(TickingEntry entry) {
        this.tickingEntries.put(entry.uuid(), entry);
    }

    public Optional<UUID> getTickingEntryId(Object obj) {
        Errorable errorable;
        if (obj instanceof Errorable && (errorable = (Errorable)obj).neruina$isErrored()) {
            return Optional.ofNullable(errorable.neruina$getTickingEntryId());
        }
        return Optional.empty();
    }

    public int clearTracked() {
        int size = this.tickingEntries.size();
        this.tickingEntries.clear();
        this.recentErrors.clear();
        return size;
    }
}

