/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.RogueAbilities;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class WayfarerAbilities {
    public static void passiveWayfarerBreakStealth(class_1297 target, class_1657 player, Boolean brokenByDamage, Boolean backstabBonus) {
        if (player.method_6059(EffectRegistry.STEALTH)) {
            if (brokenByDamage.booleanValue()) {
                int speedDuration = SimplySkills.rogueConfig.passiveRogueFleetfootedSpeedDuration;
                int speedStacks = SimplySkills.rogueConfig.passiveRogueFleetfootedSpeedStacks;
                int speedMaxStacks = SimplySkills.rogueConfig.passiveRogueFleetfootedSpeedMaxStacks;
                int evasionDuration = SimplySkills.wayfarerConfig.passiveWayfarerReflexiveEvasionDuration;
                int evasionChance = SimplySkills.wayfarerConfig.passiveWayfarerReflexiveChance;
                if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueFleetfooted, (class_1309)player)) {
                    HelperMethods.incrementStatusEffect((class_1309)player, class_1294.field_5904, speedDuration, speedStacks, speedMaxStacks);
                }
                if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerReflexive, (class_1309)player) && player.method_6051().method_43048(100) < evasionChance) {
                    HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.EVASION, evasionDuration, 1, 1);
                }
            }
            if (!brokenByDamage.booleanValue()) {
                if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerReflexive, (class_1309)player)) {
                    HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.MIGHT, 40, 1, 20);
                    HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.MARKSMANSHIP, 40, 1, 20);
                }
                if (target != null && target instanceof class_1309) {
                    class_1309 livingTarget = (class_1309)target;
                    int deathmarkDuration = SimplySkills.rogueConfig.passiveRogueExploitationDeathMarkDuration;
                    int deathmarkStacks = SimplySkills.rogueConfig.passiveRogueExploitationDeathMarkStacks;
                    if (backstabBonus.booleanValue() && HelperMethods.isBehindTarget((class_1309)player, livingTarget)) {
                        if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueExploitation, (class_1309)player)) {
                            HelperMethods.incrementStatusEffect(livingTarget, EffectRegistry.DEATHMARK, deathmarkDuration, deathmarkStacks, 3);
                        }
                        if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueOpportunisticMastery, (class_1309)player)) {
                            RogueAbilities.passiveRogueOpportunisticMastery((class_1297)livingTarget, player);
                        }
                    }
                }
            }
            player.method_6016(EffectRegistry.STEALTH);
            player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.SOUNDEFFECT36, class_3419.field_15248, 0.7f, 1.4f);
            if (player.method_6059(class_1294.field_5905)) {
                player.method_6016(class_1294.field_5905);
            }
            player.method_6092(new class_1293(EffectRegistry.REVEALED, 180, 5, false, false, true));
        }
    }

    public static void passiveWayfarerGuarding(class_1657 player) {
        int barrierFrequency = SimplySkills.wayfarerConfig.passiveWayfarerGuardingBarrierFrequency;
        int barrierDuration = SimplySkills.wayfarerConfig.passiveWayfarerGuardingBarrierDuration;
        int barrierStacks = SimplySkills.wayfarerConfig.passiveWayfarerGuardingBarrierStacks;
        int barrierMaxStacks = SimplySkills.wayfarerConfig.passiveWayfarerGuardingBarrierMaxStacks;
        if (player.method_6079().method_7909() instanceof class_1764 && player.field_6012 % barrierFrequency == 0) {
            HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.BARRIER, barrierDuration, barrierStacks, barrierMaxStacks);
        }
    }

    public static void passiveWayfarerSlender(class_1657 player) {
        int slenderArmorThreshold = SimplySkills.wayfarerConfig.passiveWayfarerSlenderArmorThreshold;
        int frailArmorThreshold = SimplySkills.initiateConfig.passiveInitiateFrailArmorThreshold;
        if (player.field_6012 % 20 == 0) {
            int buffAmplifier;
            int armorValue = player.method_6096();
            if (armorValue < slenderArmorThreshold && (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.roguePath, (class_1309)player) || HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.rangerPath, (class_1309)player))) {
                buffAmplifier = (slenderArmorThreshold - armorValue) / 5;
                player.method_6092(new class_1293(EffectRegistry.AGILE, 25, buffAmplifier, false, false, false));
            }
            if (armorValue < frailArmorThreshold && HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wizardPath, (class_1309)player)) {
                buffAmplifier = (frailArmorThreshold - armorValue) / 5;
                player.method_6092(new class_1293(EffectRegistry.AGILE, 25, buffAmplifier, false, false, false));
            }
        }
    }

    public static boolean passiveWayfarerStealth(class_1657 player) {
        return HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerStealth, (class_1309)player) && player.method_5715() && !player.method_6059(EffectRegistry.REVEALED) && !WayfarerAbilities.isPlayerTargeted(player, 20);
    }

    public static boolean isPlayerTargeted(class_1657 player, int radius) {
        class_1937 world = player.method_37908();
        class_238 box = new class_238(player.method_23317() - (double)radius, player.method_23318() - (double)radius, player.method_23321() - (double)radius, player.method_23317() + (double)radius, player.method_23318() + (double)radius, player.method_23321() + (double)radius);
        for (class_1297 entity2 : world.method_8333((class_1297)player, box, entity -> entity instanceof class_1308)) {
            class_1308 mobEntity;
            class_1309 target;
            if (!(entity2 instanceof class_1308) || (target = (mobEntity = (class_1308)entity2).method_5968()) != player) continue;
            return true;
        }
        for (class_1297 entity2 : world.method_8333((class_1297)player, box, entity -> entity instanceof class_1657)) {
            class_1657 otherPlayer;
            if (!(entity2 instanceof class_1657) || (otherPlayer = (class_1657)entity2) == player || !WayfarerAbilities.isInViewingAngle(otherPlayer, player)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInViewingAngle(class_1657 viewer, class_1657 target) {
        double threshold;
        class_243 viewerPos = viewer.method_19538();
        class_243 targetPos = target.method_19538();
        class_243 directionToTarget = targetPos.method_1020(viewerPos).method_1029();
        class_243 viewerLookVec = viewer.method_5828(1.0f).method_1029();
        double dotProduct = viewerLookVec.method_1026(directionToTarget);
        return dotProduct > (threshold = Math.cos(Math.toRadians(90.0)));
    }
}

