/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3966;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.particle.Particles;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.effects.instance.SimplyStatusEffectInstance;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class ClericAbilities {
    public static void passiveClericHealingWard(class_1657 player, List<class_1297> targets, class_2960 spellId) {
        int random = new Random().nextInt(100);
        int chance = 10;
        Spell spell = SpellRegistry.getSpell((class_2960)spellId);
        SpellSchool healingSchool = SpellSchools.HEALING;
        if (random < chance) {
            targets.forEach(target -> {
                if (target instanceof class_1309) {
                    class_1309 livingTarget = (class_1309)target;
                    if (spell.school == healingSchool) {
                        HelperMethods.incrementStatusEffect(livingTarget, EffectRegistry.BARRIER, 100, 1, 20);
                    }
                }
            });
        }
    }

    public static void passiveClericMutualMending(class_1657 player, class_2960 spellId, List<class_1297> targets) {
        int random = new Random().nextInt(100);
        int chance = 20;
        if (spellId.toString().contains("holy_beam")) {
            chance = 10;
        }
        Spell spell = SpellRegistry.getSpell((class_2960)spellId);
        SpellSchool healingSchool = SpellSchools.HEALING;
        if (random < chance && !targets.contains(player) && spell.school == healingSchool) {
            if (spellId.toString().contains("holy_beam")) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "paladins:heal", 10, (class_1297)player, null);
            } else {
                SignatureAbilities.castSpellEngineIndirectTarget(player, spellId.toString(), 10, (class_1297)player, null);
            }
        }
    }

    public static void passiveClericAltruism(class_1657 player) {
        int frequency = 600;
        if (player.method_6096() <= 10 && player.field_6012 % frequency == 0) {
            HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.SPELLFORGED, frequency + 5, 1, 2);
        }
    }

    public static boolean signatureClericDivineIntervention(String clericSkillTree, class_1657 player) {
        class_243 blockpos = null;
        boolean success = false;
        int divineInterventionRange = 25;
        if (HelperMethods.getTargetedEntity((class_1297)player, divineInterventionRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((class_1297)player, divineInterventionRange).method_19538();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getPositionLookingAt(player, divineInterventionRange);
        }
        if (blockpos != null) {
            int xpos = (int)blockpos.method_10216();
            int ypos = (int)blockpos.method_10214();
            int zpos = (int)blockpos.method_10215();
            class_2338 searchArea = new class_2338(xpos, ypos, zpos);
            class_238 box = HelperMethods.createBoxAtBlock(searchArea, 3);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                class_1309 le;
                if (entities == null || !(entities instanceof class_1309) || HelperMethods.checkFriendlyFire(le = (class_1309)entities, player)) continue;
                success = true;
                if (HelperMethods.isUnlocked(clericSkillTree, SkillReferencePosition.clericSpecialisationDivineInterventionFireResistance, (class_1309)player)) {
                    HelperMethods.incrementStatusEffect(le, class_1294.field_5918, 240, 1, 5);
                }
                if (HelperMethods.isUnlocked(clericSkillTree, SkillReferencePosition.clericSpecialisationDivineInterventionMight, (class_1309)player)) {
                    HelperMethods.incrementStatusEffect(le, EffectRegistry.MIGHT, 240, 3, 10);
                }
                if (HelperMethods.isUnlocked(clericSkillTree, SkillReferencePosition.clericSpecialisationDivineInterventionSpellforged, (class_1309)player)) {
                    HelperMethods.incrementStatusEffect(le, EffectRegistry.SPELLFORGED, 240, 3, 10);
                }
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:divine_intervention", 15, (class_1297)le, HelperMethods.getBlockLookingAt(player, 256));
                break;
            }
        }
        return success;
    }

    public static boolean signatureClericSacredOrb(String clericSkillTree, class_1657 player) {
        SignatureAbilities.castSpellEngineDumbFire(player, "simplyskills:sacred_orb");
        return true;
    }

    public static void signatureClericSacredOrbHoming(SpellProjectile spellProjectile, class_2960 spellId) {
        if (spellProjectile.getSpell() != null && spellId != null && spellId.toString().equals("simplyskills:sacred_orb") && spellProjectile.field_6012 > 20 && spellProjectile.getFollowedTarget() == null) {
            class_238 box = HelperMethods.createBox((class_1297)spellProjectile, 6);
            for (class_1297 entities : spellProjectile.method_37908().method_8333((class_1297)spellProjectile, box, class_1301.field_6157)) {
                class_1657 playerOwner;
                if (!(entities instanceof class_1309)) continue;
                class_1309 le = (class_1309)entities;
                class_1297 class_12972 = spellProjectile.method_24921();
                if (!(class_12972 instanceof class_1657) || HelperMethods.checkFriendlyFire(le, playerOwner = (class_1657)class_12972)) continue;
                spellProjectile.setFollowedTarget((class_1297)le);
                break;
            }
        }
    }

    public static void signatureClericSacredOrbImpact(class_3966 entityHitResult, class_2960 spellId, class_1297 ownerEntity, SpellProjectile spellProjectile) {
        class_1297 class_12972;
        if (spellProjectile.getSpell() != null && spellId != null && spellId.toString().equals("simplyskills:sacred_orb") && entityHitResult.method_17782() != null && (class_12972 = entityHitResult.method_17782()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            if (ownerEntity instanceof class_1309) {
                class_1309 livingOwner = (class_1309)ownerEntity;
                SimplyStatusEffectInstance vitalityBond = new SimplyStatusEffectInstance(EffectRegistry.VITALITYBOND, 500, 0, false, false, true);
                SimplyStatusEffectInstance vitalityBond2 = new SimplyStatusEffectInstance(EffectRegistry.VITALITYBOND, 500, 0, false, false, true);
                vitalityBond.setSourceEntity(livingOwner);
                vitalityBond2.setSourceEntity(livingOwner);
                livingEntity.method_6092((class_1293)vitalityBond);
                livingOwner.method_6092((class_1293)vitalityBond2);
            }
        }
    }

    public static boolean signatureClericAnointWeapon(class_1657 player) {
        player.method_6092(new class_1293(EffectRegistry.ANOINTED, 400, 0, false, false, true));
        return true;
    }

    public static void signatureClericAnointWeaponCleanse(class_1657 player) {
        int frequency = 20;
        if (player.field_6012 % frequency == 0) {
            HelperMethods.buffSteal((class_1309)player, (class_1309)player, true, true, true, true);
        }
    }

    public static void signatureClericAnointWeaponUndying(class_1657 player) {
        float playerHealthPercent = player.method_6032() / player.method_6063() * 100.0f;
        int roll = player.method_6051().method_43048(100);
        int chance = 15;
        if (playerHealthPercent < 30.0f && roll < chance) {
            player.method_6092(new class_1293(EffectRegistry.UNDYING, 120, 0, false, false, true));
        }
    }

    public static void signatureClericAnointWeaponEffect(class_1657 player) {
        int radius = 4;
        float damageMultiplier = 2.2f;
        class_238 box = HelperMethods.createBox((class_1297)player, radius);
        ArrayList<class_1309> targets = new ArrayList<class_1309>();
        ArrayList<class_1309> hostileTargets = new ArrayList<class_1309>();
        for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
            if (!(entities instanceof class_1309)) continue;
            class_1309 le = (class_1309)entities;
            if (!HelperMethods.checkFriendlyFire(le, player)) {
                targets.add(le);
                continue;
            }
            if (!HelperMethods.checkFriendlyFire(le, player)) continue;
            hostileTargets.add(le);
        }
        class_2960 spellId = new class_2960("simplyskills:paladins_flash_heal");
        SpellCast.Action action = SpellCast.Action.CHANNEL;
        class_1282 damageSource = player.method_48923().method_48815((class_1297)player, (class_1297)player);
        SpellHelper.performSpell((class_1937)player.method_37908(), (class_1657)player, (class_2960)spellId, targets, (SpellCast.Action)action, (float)20.0f);
        float amount = (float)(SpellPower.getSpellPower((SpellSchool)SpellSchools.HEALING, (class_1309)player).randomValue() * (double)damageMultiplier) / (float)hostileTargets.size();
        hostileTargets.forEach(entity -> {
            class_1308 mobEntity;
            entity.field_6008 = 0;
            entity.method_5643(damageSource, amount);
            entity.field_6008 = 0;
            if (entity instanceof class_1308 && (mobEntity = (class_1308)entity).method_5999()) {
                HelperMethods.incrementStatusEffect((class_1309)mobEntity, class_1294.field_5909, 40, 1, 4);
            }
            for (int i = 6; i > 0; --i) {
                HelperMethods.spawnParticle(player.method_37908(), (class_2394)Particles.holy_spark_mini.particleType, entity.method_23317(), entity.method_23318(), entity.method_23321(), 0.1, 0.1 + (double)i, 0.2);
                HelperMethods.spawnParticle(player.method_37908(), (class_2394)Particles.holy_spark_mini.particleType, entity.method_23317(), entity.method_23318(), entity.method_23321(), 0.2, 0.2 + (double)i, 0.1);
                HelperMethods.spawnParticle(player.method_37908(), (class_2394)Particles.holy_hit.particleType, entity.method_23317(), entity.method_23318(), entity.method_23321(), 0.1, 0.2 * (double)i, 0.2);
            }
        });
        if (HelperMethods.isUnlocked("simplyskills:cleric", SkillReferencePosition.clericSpecialisationAnointWeaponResistance, (class_1309)player)) {
            HelperMethods.incrementStatusEffect((class_1309)player, class_1294.field_5907, 40, 1, 2);
        }
    }
}

