/*
 * Decompiled with CFR 0.152.
 */
package net.mcs3.basicnetherores.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.mcs3.basicnetherores.Constants;
import net.mcs3.basicnetherores.config.BasicNetherOresConfig;

public class FabricBasicNetherOresConfig {
    private static final Common COMMON = new Common();

    public static void setup() {
        try {
            Files.createDirectory(Paths.get("config", new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            Constants.LOGGER.warn("Failed to make config dir", (Throwable)e);
        }
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        ConfigTree common = COMMON.configure(ConfigTree.builder());
        FabricBasicNetherOresConfig.setupConfig(common, Paths.get("config", "bno-common.json5"), serializer);
        BasicNetherOresConfig.setCommon(COMMON);
    }

    private static void setupConfig(ConfigTree config, Path p, JanksonValueSerializer serializer) {
        FabricBasicNetherOresConfig.writeDefaultConfig(config, p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)config, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            Constants.LOGGER.error("Error loading config from {}", (Object)p, (Object)e);
        }
    }

    private static void writeDefaultConfig(ConfigTree config, Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s2 = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)config, (OutputStream)s2, (ValueSerializer)serializer);
        }
        catch (FileAlreadyExistsException s2) {
        }
        catch (IOException e) {
            Constants.LOGGER.error("Error writing default config", (Throwable)e);
        }
    }

    private static class Common
    implements BasicNetherOresConfig.ConfigAccess {
        public final PropertyMirror<Boolean> emeraldGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> diamondGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> redstoneGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> lapisGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> coalGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> silverGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> ironGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> leadGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> nickelGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> copperGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> aluminumGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> tinGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> osmiumGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> uraniumGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> zincGeneration = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> piglinGuard = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> silkEffect = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Integer> protectionRange = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<List<String>> protectedBlocks = PropertyMirror.create((ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING));

        private Common() {
        }

        public ConfigTree configure(ConfigTreeBuilder builder) {
            builder.fork("emeraldGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Generate Emerald Ore").finishValue(arg_0 -> this.emeraldGeneration.mirror(arg_0)).finishBranch().fork("diamondGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Generate Diamond Ore").finishValue(arg_0 -> this.diamondGeneration.mirror(arg_0)).finishBranch().fork("redstoneGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Generate Restone Ore").finishValue(arg_0 -> this.redstoneGeneration.mirror(arg_0)).finishBranch().fork("lapisGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Generate Lapis Ore").finishValue(arg_0 -> this.lapisGeneration.mirror(arg_0)).finishBranch().fork("coalGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Generate Coal Ore").finishValue(arg_0 -> this.coalGeneration.mirror(arg_0)).finishBranch().fork("silverGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Generate Silver Ore").finishValue(arg_0 -> this.silverGeneration.mirror(arg_0)).finishBranch().fork("ironGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Generate Iron Ore").finishValue(arg_0 -> this.ironGeneration.mirror(arg_0)).finishBranch().fork("leadGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Generate Lead Ore").finishValue(arg_0 -> this.leadGeneration.mirror(arg_0)).finishBranch().fork("nickelGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Generate Nickel Ore").finishValue(arg_0 -> this.nickelGeneration.mirror(arg_0)).finishBranch().fork("copperGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Generate Copper Ore").finishValue(arg_0 -> this.copperGeneration.mirror(arg_0)).finishBranch().fork("aluminumGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Generate Aluminum Ore").finishValue(arg_0 -> this.aluminumGeneration.mirror(arg_0)).finishBranch().fork("tinGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Generate Tin Ore").finishValue(arg_0 -> this.tinGeneration.mirror(arg_0)).finishBranch().fork("osmiumGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Generate Osmium Ore").finishValue(arg_0 -> this.osmiumGeneration.mirror(arg_0)).finishBranch().fork("uraniumGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Generate Uranium Ore").finishValue(arg_0 -> this.uraniumGeneration.mirror(arg_0)).finishBranch().fork("zincGeneration").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Generate Zinc Ore").finishValue(arg_0 -> this.zincGeneration.mirror(arg_0)).finishBranch().fork("piglinGuard").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("If set to 'true' Piglins will protect Nether Ores").finishValue(arg_0 -> this.piglinGuard.mirror(arg_0)).finishBranch().fork("silkEffect").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set to false if you want the Piglins to attack when using Silk Touch Tools").finishValue(arg_0 -> this.silkEffect.mirror(arg_0)).finishBranch().fork("protectionRange").beginValue("range", (ConfigType)ConfigTypes.INTEGER, (Object)16).withComment("Set range that Piglins will aggro when mining ores(Default = 16)").finishValue(arg_0 -> this.protectionRange.mirror(arg_0)).finishBranch().fork("protectedBlocks").beginValue("blocks", (ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING), Arrays.asList("bno:nether_emerald_ore", "bno:nether_diamond_ore", "bno:nether_lapis_ore", "bno:nether_redstone_ore", "minecraft:nether_gold_ore", "bno:nether_silver_ore", "bno:nether_iron_ore", "bno:nether_lead_ore", "bno:nether_nickel_ore", "bno:nether_coal_ore", "bno:nether_copper_ore", "bno:nether_aluminum_ore", "bno:nether_tin_ore", "bno:nether_osmium_ore", "bno:nether_uranium_ore", "bno:nether_zinc_ore", "minecraft:glowstone", "minecraft:nether_quartz_ore")).withComment("Add Blocks to be protected by Piglins (Example: 'minecraft:glowstone')").finishValue(arg_0 -> this.protectedBlocks.mirror(arg_0)).finishBranch();
            return builder.build();
        }

        @Override
        public boolean emeraldGeneration() {
            return (Boolean)this.emeraldGeneration.getValue();
        }

        @Override
        public boolean diamondGeneration() {
            return (Boolean)this.diamondGeneration.getValue();
        }

        @Override
        public boolean redstoneGeneration() {
            return (Boolean)this.redstoneGeneration.getValue();
        }

        @Override
        public boolean lapisGeneration() {
            return (Boolean)this.lapisGeneration.getValue();
        }

        @Override
        public boolean coalGeneration() {
            return (Boolean)this.coalGeneration.getValue();
        }

        @Override
        public boolean silverGeneration() {
            return (Boolean)this.silverGeneration.getValue();
        }

        @Override
        public boolean ironGeneration() {
            return (Boolean)this.ironGeneration.getValue();
        }

        @Override
        public boolean leadGeneration() {
            return (Boolean)this.leadGeneration.getValue();
        }

        @Override
        public boolean nickelGeneration() {
            return (Boolean)this.nickelGeneration.getValue();
        }

        @Override
        public boolean copperGeneration() {
            return (Boolean)this.copperGeneration.getValue();
        }

        @Override
        public boolean aluminumGeneration() {
            return (Boolean)this.aluminumGeneration.getValue();
        }

        @Override
        public boolean tinGeneration() {
            return (Boolean)this.tinGeneration.getValue();
        }

        @Override
        public boolean osmiumGeneration() {
            return (Boolean)this.osmiumGeneration.getValue();
        }

        @Override
        public boolean uraniumGeneration() {
            return (Boolean)this.uraniumGeneration.getValue();
        }

        @Override
        public boolean zincGeneration() {
            return (Boolean)this.zincGeneration.getValue();
        }

        @Override
        public boolean piglinGuard() {
            return (Boolean)this.piglinGuard.getValue();
        }

        @Override
        public boolean silkEffect() {
            return (Boolean)this.silkEffect.getValue();
        }

        @Override
        public int protectionRange() {
            return (Integer)this.protectionRange.getValue();
        }

        @Override
        public List<? extends String> protectedBlocks() {
            return (List)this.protectedBlocks.getValue();
        }
    }
}

