/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.util;

import com.google.common.base.Suppliers;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3765;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public record TextKey(int index, List<String> args) {
    static final Map<String, Integer> keyMap = new HashMap<String, Integer>();
    static final Map<Integer, String> keyReverseMap = new HashMap<Integer, String>();
    static final Map<Integer, Function<TextKey, class_2561>> keyTextBuilderMap = new HashMap<Integer, Function<TextKey, class_2561>>();
    static final Map<Integer, BiFunction<class_1799, class_1937, List<class_1799>>> processorMap = new HashMap<Integer, BiFunction<class_1799, class_1937, List<class_1799>>>();
    static final Map<Integer, class_2960> keySpriteIdMap = new HashMap<Integer, class_2960>();
    static final Function<TextKey, class_2561> DEFAULT_FUNCTION = key -> LText.translatable("emi_loot.missing_key");
    static final BiFunction<class_1799, class_1937, List<class_1799>> DEFAULT_PROCESSOR = (stack, world) -> List.of(stack);
    static final class_2960 EMPTY = new class_2960("emi_loot", "textures/gui/empty.png");
    static int curDynamicIndex = 1000;
    public static final Supplier<List<class_3545<Integer, class_2561>>> noConditionsList = Suppliers.memoize(() -> {
        ArrayList<class_3545> list = new ArrayList<class_3545>();
        list.add(new class_3545((Object)TextKey.getIndex("emi_loot.no_conditions"), (Object)LText.translatable("emi_loot.no_conditions")));
        return list;
    });
    public static final Set<String> defaultSkips = Set.of("emi_loot.function.set_count_add", "emi_loot.function.set_count_set", "emi_loot.function.fill_player_head", "emi_loot.function.limit_count", "emi_loot.no_conditions");

    private static void mapBuilder(int index, String key, Function<TextKey, class_2561> function, class_2960 spriteId) {
        keyMap.put(key, index);
        keyReverseMap.put(index, key);
        keyTextBuilderMap.put(index, function);
        keySpriteIdMap.put(index, spriteId);
    }

    private static void mapBuilder(int index, String key, Function<TextKey, class_2561> function, class_2960 spriteId, BiFunction<class_1799, class_1937, List<class_1799>> processor) {
        keyMap.put(key, index);
        keyReverseMap.put(index, key);
        keyTextBuilderMap.put(index, function);
        keySpriteIdMap.put(index, spriteId);
        processorMap.put(index, processor);
    }

    public static void register(String key, int args, class_2960 sprite, BiFunction<class_1799, class_1937, List<class_1799>> processor) {
        if (keyMap.containsKey(key)) {
            throw new IllegalArgumentException("Text key [" + key + "] already registered!");
        }
        if (!sprite.toString().contains(".png")) {
            throw new IllegalArgumentException("Text key [" + key + "] registered with sprite identifier [" + String.valueOf(sprite) + "] that isn't a png!)");
        }
        int index = curDynamicIndex++;
        switch (args) {
            case 0: {
                TextKey.mapBuilder(index, key, tk -> TextKey.getBasicText(index), sprite, processor);
                break;
            }
            case 1: {
                TextKey.mapBuilder(index, key, tk -> TextKey.getOneArgText(index, tk), sprite, processor);
                break;
            }
            case 2: {
                TextKey.mapBuilder(index, key, tk -> TextKey.getTwoArgText(index, tk), sprite, processor);
                break;
            }
            default: {
                TextKey.mapBuilder(index, key, TextKey::getAnyOfText, sprite, processor);
            }
        }
    }

    public static void register(String key, int args, class_2960 sprite) {
        if (keyMap.containsKey(key)) {
            throw new IllegalArgumentException("Text key [" + key + "] already registered!");
        }
        if (!sprite.toString().contains(".png")) {
            throw new IllegalArgumentException("Text key [" + key + "] registered with sprite identifier [" + String.valueOf(sprite) + "] that isn't a png!)");
        }
        int index = curDynamicIndex++;
        switch (args) {
            case 0: {
                TextKey.mapBuilder(index, key, tk -> TextKey.getBasicText(index), sprite);
                break;
            }
            case 1: {
                TextKey.mapBuilder(index, key, tk -> TextKey.getOneArgText(index, tk), sprite);
                break;
            }
            case 2: {
                TextKey.mapBuilder(index, key, tk -> TextKey.getTwoArgText(index, tk), sprite);
                break;
            }
            default: {
                TextKey.mapBuilder(index, key, TextKey::getAnyOfText, sprite);
            }
        }
    }

    private static class_2561 getBasicText(int index) {
        String translationKey = keyReverseMap.getOrDefault(index, "emi_loot.missing_key");
        return LText.translatable(translationKey);
    }

    private static class_2561 getOneArgText(int index, TextKey key) {
        String arg;
        String translationKey = keyReverseMap.getOrDefault(index, "emi_loot.missing_key");
        try {
            arg = key.args.get(0);
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Couldn't get one-arg text");
            e.printStackTrace();
            arg = "Missing";
        }
        return LText.translatable(translationKey, arg);
    }

    private static class_2561 getTwoArgText(int index, TextKey key) {
        String arg2;
        String arg1;
        String translationKey = keyReverseMap.getOrDefault(index, "emi_loot.missing_key");
        try {
            arg1 = key.args.get(0);
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Couldn't get first arg of two-arg text");
            e.printStackTrace();
            arg1 = "Missing";
        }
        try {
            arg2 = key.args.get(1);
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Couldn't get second arg of two-arg text");
            e.printStackTrace();
            arg2 = "Missing";
        }
        return LText.translatable(translationKey, arg1, arg2);
    }

    private static class_2561 getAnyOfText(TextKey key) {
        List<String> args = key.args;
        int size = args.size();
        if (size == 1) {
            return LText.translatable("emi_loot.condition.any_of", args.get(0));
        }
        if (size == 2) {
            return LText.translatable("emi_loot.condition.any_of_2", args.get(0), args.get(1));
        }
        class_5250 finalText = LText.empty();
        for (int i = 0; i < size; ++i) {
            String arg = args.get(i);
            if (i == size - 2) {
                finalText.method_10852((class_2561)LText.translatable("emi_loot.condition.any_of_3a", arg));
                continue;
            }
            if (i == size - 1) {
                finalText.method_10852((class_2561)LText.translatable("emi_loot.condition.any_of", arg));
                continue;
            }
            finalText.method_10852((class_2561)LText.translatable("emi_loot.condition.any_of_3", arg));
        }
        return finalText;
    }

    private static class_2561 getAllOfText(TextKey key) {
        List<String> args = key.args;
        int size = args.size();
        if (size == 1) {
            return LText.translatable("emi_loot.condition.all_of", args.get(0));
        }
        if (size == 2) {
            return LText.translatable("emi_loot.condition.all_of_2", args.get(0), args.get(1));
        }
        class_5250 finalText = LText.empty();
        for (int i = 0; i < size; ++i) {
            String arg = args.get(i);
            if (i == size - 2) {
                finalText.method_10852((class_2561)LText.translatable("emi_loot.condition.all_of_3a", arg));
                continue;
            }
            if (i == size - 1) {
                finalText.method_10852((class_2561)LText.translatable("emi_loot.condition.all_of", arg));
                continue;
            }
            finalText.method_10852((class_2561)LText.translatable("emi_loot.condition.all_of_3", arg));
        }
        return finalText;
    }

    private static class_2561 getInvertedText(int index, TextKey key) {
        String arg;
        String translationKey = keyReverseMap.getOrDefault(index, "emi_loot.missing_key");
        try {
            arg = key.args.get(0);
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Couldn't get inverted text");
            e.printStackTrace();
            arg = "Missing";
        }
        return LText.translatable(translationKey, arg).method_27692(class_124.field_1061);
    }

    public boolean isNotEmpty() {
        return this.index != 0;
    }

    public static Set<String> keys() {
        return keyMap.keySet();
    }

    public static int getIndex(String key) {
        return keyMap.getOrDefault(key, -1);
    }

    public static String getKey(int index) {
        return keyReverseMap.getOrDefault(index, "emi_loot.function.empty");
    }

    public static class_2960 getSpriteId(int index) {
        return keySpriteIdMap.getOrDefault(index, EMPTY);
    }

    public static TextKey empty() {
        return new TextKey(0, new LinkedList<String>());
    }

    public static TextKey of(String key, String ... args) {
        if (keyMap.containsKey(key)) {
            return new TextKey(keyMap.get(key), Arrays.stream(args).toList());
        }
        return new TextKey(0, new LinkedList<String>());
    }

    public static TextKey of(String key, List<String> args) {
        if (keyMap.containsKey(key)) {
            return new TextKey(keyMap.get(key), args);
        }
        EMILoot.LOGGER.error("Couldn't parse TextKey with key: {}and args: {}", (Object)key, args);
        return new TextKey(0, new LinkedList<String>());
    }

    public static TextKey of(String key) {
        return TextKey.of(key, new LinkedList<String>());
    }

    public static TextKey of(String key, String arg) {
        return TextKey.of(key, Collections.singletonList(arg));
    }

    public static String symbolKey(int index) {
        return String.valueOf((char)(59136 + index));
    }

    public class_2561 processText() {
        return keyTextBuilderMap.getOrDefault(this.index, DEFAULT_FUNCTION).apply(this);
    }

    public List<class_1799> processStack(class_1799 stack, @Nullable class_1937 world) {
        BiFunction<class_1799, class_1937, List<class_1799>> processor = processorMap.getOrDefault(this.index, DEFAULT_PROCESSOR);
        return processor.apply(stack, world);
    }

    public TextKeyResult process(class_1799 stack, @Nullable class_1937 world) {
        BiFunction<class_1799, class_1937, List<class_1799>> processor = processorMap.getOrDefault(this.index, DEFAULT_PROCESSOR);
        List<class_1799> finalStacks = processor.apply(stack, world);
        class_2561 text = keyTextBuilderMap.getOrDefault(this.index, DEFAULT_FUNCTION).apply(this);
        return new TextKeyResult(text, finalStacks);
    }

    public boolean skip() {
        return EMILoot.config.skippedKeys.contains(TextKey.getKey(this.index));
    }

    public static TextKey fromBuf(class_2540 buf) {
        int key = buf.method_10816();
        int size = buf.readByte();
        LinkedList<String> args = new LinkedList<String>();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                args.add(buf.method_19772());
            }
        }
        return new TextKey(key, args);
    }

    public void toBuf(class_2540 buf) {
        buf.method_10804(this.index);
        if (this.args.isEmpty()) {
            buf.writeByte(0);
        } else {
            int argSize = Math.min(127, this.args.size());
            buf.writeByte(this.args.size());
            for (int i = 0; i < argSize; ++i) {
                String string = this.args.get(i);
                buf.method_10814(string);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextKey textKey = (TextKey)o;
        return this.index == textKey.index && this.args.equals(textKey.args);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.args);
    }

    static {
        BiFunction<class_1799, class_1937, List<class_1799>> smeltProcessor = (stack, world) -> {
            LinkedList<class_1799> finalStacks = new LinkedList<class_1799>();
            if (world != null) {
                Optional opt = world.method_8433().method_8132(class_3956.field_17546, (class_1263)new class_1277(new class_1799[]{stack}), world);
                if (opt.isPresent()) {
                    class_1799 tempStack = ((class_3861)opt.get()).method_8110(world.method_30349());
                    if (!tempStack.method_7960()) {
                        finalStacks.add(tempStack.method_7972());
                    }
                } else {
                    finalStacks.add((class_1799)stack);
                }
            } else {
                finalStacks.add((class_1799)stack);
            }
            return finalStacks;
        };
        BiFunction<class_1799, class_1937, List<class_1799>> ominousProcessor = (stack, world) -> List.of(class_3765.method_16515());
        TextKey.mapBuilder(0, "emi_loot.function.empty", key -> LText.empty(), EMPTY);
        TextKey.mapBuilder(1, "emi_loot.function.bonus", key -> TextKey.getOneArgText(1, key), new class_2960("emi_loot", "textures/gui/bonus.png"));
        TextKey.mapBuilder(2, "emi_loot.function.potion", key -> TextKey.getOneArgText(2, key), new class_2960("emi_loot", "textures/gui/potion.png"));
        TextKey.mapBuilder(3, "emi_loot.function.set_count_add", key -> TextKey.getBasicText(3), new class_2960("emi_loot", "textures/gui/set_count_add.png"));
        TextKey.mapBuilder(4, "emi_loot.function.set_count_set", key -> TextKey.getBasicText(4), new class_2960("emi_loot", "textures/gui/set_count_add.png"));
        TextKey.mapBuilder(5, "emi_loot.function.randomly_enchanted_book", key -> TextKey.getBasicText(5), new class_2960("emi_loot", "textures/gui/random_book.png"));
        TextKey.mapBuilder(6, "emi_loot.function.randomly_enchanted_item", key -> TextKey.getBasicText(6), new class_2960("emi_loot", "textures/gui/random_item.png"));
        TextKey.mapBuilder(7, "emi_loot.function.set_enchant_book", key -> TextKey.getBasicText(7), new class_2960("emi_loot", "textures/gui/set_book.png"));
        TextKey.mapBuilder(8, "emi_loot.function.set_enchant_item", key -> TextKey.getBasicText(8), new class_2960("emi_loot", "textures/gui/set_item.png"));
        TextKey.mapBuilder(9, "emi_loot.function.smelt", key -> TextKey.getBasicText(9), new class_2960("emi_loot", "textures/gui/smelt.png"), smeltProcessor);
        TextKey.mapBuilder(10, "emi_loot.function.looting", key -> TextKey.getBasicText(10), new class_2960("emi_loot", "textures/gui/looting.png"));
        TextKey.mapBuilder(11, "emi_loot.function.map", key -> TextKey.getOneArgText(11, key), new class_2960("emi_loot", "textures/gui/map.png"));
        TextKey.mapBuilder(12, "emi_loot.function.set_contents", key -> TextKey.getBasicText(12), new class_2960("emi_loot", "textures/gui/set_contents.png"));
        TextKey.mapBuilder(13, "emi_loot.function.damage", key -> TextKey.getOneArgText(13, key), new class_2960("emi_loot", "textures/gui/damage.png"));
        TextKey.mapBuilder(14, "emi_loot.function.copy_state", key -> TextKey.getBasicText(14), new class_2960("emi_loot", "textures/gui/copy.png"));
        TextKey.mapBuilder(15, "emi_loot.function.copy_name", key -> TextKey.getOneArgText(15, key), new class_2960("emi_loot", "textures/gui/copy.png"));
        TextKey.mapBuilder(16, "emi_loot.function.copy_nbt", key -> TextKey.getBasicText(16), new class_2960("emi_loot", "textures/gui/nbt.png"));
        TextKey.mapBuilder(17, "emi_loot.function.decay", key -> TextKey.getBasicText(17), new class_2960("emi_loot", "textures/gui/tnt.png"));
        TextKey.mapBuilder(18, "emi_loot.function.fill_player_head", key -> TextKey.getBasicText(18), new class_2960("emi_loot", "textures/gui/fzzy.png"));
        TextKey.mapBuilder(19, "emi_loot.function.limit_count", key -> TextKey.getOneArgText(19, key), new class_2960("emi_loot", "textures/gui/limit_count.png"));
        TextKey.mapBuilder(20, "emi_loot.function.set_attributes", key -> TextKey.getOneArgText(20, key), new class_2960("emi_loot", "textures/gui/set_attributes.png"));
        TextKey.mapBuilder(21, "emi_loot.function.banner", key -> TextKey.getBasicText(21), new class_2960("emi_loot", "textures/gui/banner.png"));
        TextKey.mapBuilder(22, "emi_loot.function.lore", key -> TextKey.getBasicText(22), new class_2960("emi_loot", "textures/gui/lore.png"));
        TextKey.mapBuilder(23, "emi_loot.function.set_stew", key -> TextKey.getOneArgText(23, key), new class_2960("emi_loot", "textures/gui/stew.png"));
        TextKey.mapBuilder(24, "emi_loot.function.set_nbt", key -> TextKey.getBasicText(24), new class_2960("emi_loot", "textures/gui/nbt.png"));
        TextKey.mapBuilder(25, "emi_loot.function.set_loot_table", key -> TextKey.getOneArgText(25, key), new class_2960("emi_loot", "textures/gui/chest.png"));
        TextKey.mapBuilder(26, "emi_loot.function.reference", key -> TextKey.getOneArgText(25, key), new class_2960("emi_loot", "textures/gui/reference.png"));
        TextKey.mapBuilder(34, "emi_loot.condition.survives_explosion", key -> TextKey.getBasicText(34), new class_2960("emi_loot", "textures/gui/tnt.png"));
        TextKey.mapBuilder(35, "emi_loot.condition.blockstate", key -> TextKey.getOneArgText(35, key), new class_2960("emi_loot", "textures/gui/blockstate.png"));
        TextKey.mapBuilder(36, "emi_loot.condition.table_bonus", key -> TextKey.getOneArgText(36, key), new class_2960("emi_loot", "textures/gui/percent.png"));
        TextKey.mapBuilder(37, "emi_loot.condition.invert", key -> TextKey.getInvertedText(37, key), new class_2960("emi_loot", "textures/gui/invert.png"));
        TextKey.mapBuilder(39, "emi_loot.condition.any_of", TextKey::getAnyOfText, new class_2960("emi_loot", "textures/gui/or.png"));
        TextKey.mapBuilder(40, "emi_loot.condition.all_of", TextKey::getAllOfText, new class_2960("emi_loot", "textures/gui/or.png"));
        TextKey.mapBuilder(41, "emi_loot.condition.killed_player", key -> TextKey.getBasicText(41), new class_2960("emi_loot", "textures/gui/steve.png"));
        TextKey.mapBuilder(42, "emi_loot.condition.chance", key -> TextKey.getOneArgText(42, key), new class_2960("emi_loot", "textures/gui/percent.png"));
        TextKey.mapBuilder(43, "emi_loot.condition.chance_looting", key -> TextKey.getTwoArgText(43, key), new class_2960("emi_loot", "textures/gui/chance_looting.png"));
        TextKey.mapBuilder(44, "emi_loot.condition.damage_source", key -> TextKey.getOneArgText(44, key), new class_2960("emi_loot", "textures/gui/tiny_cactus.png"));
        TextKey.mapBuilder(45, "emi_loot.condition.location", key -> TextKey.getOneArgText(45, key), new class_2960("emi_loot", "textures/gui/location.png"));
        TextKey.mapBuilder(46, "emi_loot.condition.entity_props", key -> TextKey.getOneArgText(46, key), new class_2960("emi_loot", "textures/gui/entity_props.png"));
        TextKey.mapBuilder(47, "emi_loot.condition.match_tool", key -> TextKey.getOneArgText(47, key), new class_2960("emi_loot", "textures/gui/match_tool.png"));
        TextKey.mapBuilder(48, "emi_loot.condition.entity_scores", key -> TextKey.getBasicText(48), new class_2960("emi_loot", "textures/gui/score.png"));
        TextKey.mapBuilder(49, "emi_loot.condition.reference", key -> TextKey.getOneArgText(49, key), new class_2960("emi_loot", "textures/gui/reference.png"));
        TextKey.mapBuilder(50, "emi_loot.condition.time_check", key -> TextKey.getOneArgText(50, key), new class_2960("emi_loot", "textures/gui/time.png"));
        TextKey.mapBuilder(51, "emi_loot.condition.value_check", key -> TextKey.getTwoArgText(51, key), new class_2960("emi_loot", "textures/gui/value.png"));
        TextKey.mapBuilder(52, "emi_loot.condition.raining_true", key -> TextKey.getBasicText(52), new class_2960("emi_loot", "textures/gui/raining.png"));
        TextKey.mapBuilder(53, "emi_loot.condition.raining_false", key -> TextKey.getBasicText(53), new class_2960("emi_loot", "textures/gui/sunny.png"));
        TextKey.mapBuilder(54, "emi_loot.condition.thundering_true", key -> TextKey.getBasicText(54), new class_2960("emi_loot", "textures/gui/thundering.png"));
        TextKey.mapBuilder(55, "emi_loot.condition.thundering_false", key -> TextKey.getBasicText(55), new class_2960("emi_loot", "textures/gui/not_thundering.png"));
        TextKey.mapBuilder(62, "emi_loot.pickaxe.wood", key -> TextKey.getBasicText(62), new class_2960("emi_loot", "textures/gui/pickaxe_wood.png"));
        TextKey.mapBuilder(63, "emi_loot.pickaxe.stone", key -> TextKey.getBasicText(63), new class_2960("emi_loot", "textures/gui/pickaxe_stone.png"));
        TextKey.mapBuilder(64, "emi_loot.pickaxe.iron", key -> TextKey.getBasicText(64), new class_2960("emi_loot", "textures/gui/pickaxe_iron.png"));
        TextKey.mapBuilder(65, "emi_loot.pickaxe.diamond", key -> TextKey.getBasicText(65), new class_2960("emi_loot", "textures/gui/pickaxe_diamond.png"));
        TextKey.mapBuilder(66, "emi_loot.pickaxe.netherite", key -> TextKey.getBasicText(66), new class_2960("emi_loot", "textures/gui/pickaxe_netherite.png"));
        TextKey.mapBuilder(77, "emi_loot.axe.wood", key -> TextKey.getBasicText(77), new class_2960("emi_loot", "textures/gui/axe_wood.png"));
        TextKey.mapBuilder(78, "emi_loot.axe.stone", key -> TextKey.getBasicText(78), new class_2960("emi_loot", "textures/gui/axe_stone.png"));
        TextKey.mapBuilder(79, "emi_loot.axe.iron", key -> TextKey.getBasicText(79), new class_2960("emi_loot", "textures/gui/axe_iron.png"));
        TextKey.mapBuilder(80, "emi_loot.axe.diamond", key -> TextKey.getBasicText(80), new class_2960("emi_loot", "textures/gui/axe_diamond.png"));
        TextKey.mapBuilder(81, "emi_loot.axe.netherite", key -> TextKey.getBasicText(81), new class_2960("emi_loot", "textures/gui/axe_netherite.png"));
        TextKey.mapBuilder(92, "emi_loot.shovel.wood", key -> TextKey.getBasicText(92), new class_2960("emi_loot", "textures/gui/shovel_wood.png"));
        TextKey.mapBuilder(93, "emi_loot.shovel.stone", key -> TextKey.getBasicText(93), new class_2960("emi_loot", "textures/gui/shovel_stone.png"));
        TextKey.mapBuilder(94, "emi_loot.shovel.iron", key -> TextKey.getBasicText(94), new class_2960("emi_loot", "textures/gui/shovel_iron.png"));
        TextKey.mapBuilder(95, "emi_loot.shovel.diamond", key -> TextKey.getBasicText(95), new class_2960("emi_loot", "textures/gui/shovel_diamond.png"));
        TextKey.mapBuilder(96, "emi_loot.shovel.netherite", key -> TextKey.getBasicText(96), new class_2960("emi_loot", "textures/gui/shovel_netherite.png"));
        TextKey.mapBuilder(107, "emi_loot.hoe.wood", key -> TextKey.getBasicText(107), new class_2960("emi_loot", "textures/gui/hoe_wood.png"));
        TextKey.mapBuilder(108, "emi_loot.hoe.stone", key -> TextKey.getBasicText(108), new class_2960("emi_loot", "textures/gui/hoe_stone.png"));
        TextKey.mapBuilder(109, "emi_loot.hoe.iron", key -> TextKey.getBasicText(109), new class_2960("emi_loot", "textures/gui/hoe_iron.png"));
        TextKey.mapBuilder(110, "emi_loot.hoe.diamond", key -> TextKey.getBasicText(110), new class_2960("emi_loot", "textures/gui/hoe_diamond.png"));
        TextKey.mapBuilder(111, "emi_loot.hoe.netherite", key -> TextKey.getBasicText(111), new class_2960("emi_loot", "textures/gui/hoe_netherite.png"));
        TextKey.mapBuilder(124, "emi_loot.condition.sequence", key -> TextKey.getBasicText(124), new class_2960("emi_loot", "textures/gui/sequence.png"));
        TextKey.mapBuilder(125, "emi_loot.condition.direct_drop", key -> TextKey.getBasicText(125), new class_2960("emi_loot", "textures/gui/direct_drops.png"));
        TextKey.mapBuilder(126, "emi_loot.condition.spawns_with", key -> TextKey.getBasicText(126), new class_2960("emi_loot", "textures/gui/spawns_with.png"));
        TextKey.mapBuilder(127, "emi_loot.condition.creeper", key -> TextKey.getBasicText(127), new class_2960("emi_loot", "textures/gui/creeper.png"));
        TextKey.mapBuilder(128, "emi_loot.condition.wither_kill", key -> TextKey.getBasicText(128), new class_2960("emi_loot", "textures/gui/wither.png"));
        TextKey.mapBuilder(129, "emi_loot.function.set_any_damage", key -> TextKey.getBasicText(129), new class_2960("emi_loot", "textures/gui/damage.png"));
        TextKey.mapBuilder(130, "emi_loot.function.ominous_banner", key -> TextKey.getBasicText(130), new class_2960("emi_loot", "textures/gui/ominous.png"), ominousProcessor);
        TextKey.mapBuilder(150, "emi_loot.no_conditions", key -> TextKey.getBasicText(150), EMPTY);
    }

    public record TextKeyResult(class_2561 text, List<class_1799> stacks) {
    }
}

