/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.globalxp.xpblock;

import bl4ckscor3.mod.globalxp.GlobalXP;
import bl4ckscor3.mod.globalxp.XPUtils;
import bl4ckscor3.mod.globalxp.xpblock.XPBlock;
import com.google.common.math.IntMath;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class XPBlockEntity
extends class_2586
implements class_1275 {
    private class_2561 name;
    private int storedXP = 0;
    private float storedLevels = 0.0f;

    public XPBlockEntity(class_2338 pos, class_2680 state) {
        super(GlobalXP.XP_BLOCK_ENTITY_TYPE, pos, state);
    }

    public int addXP(int amount) {
        int space = Integer.MAX_VALUE - this.storedXP;
        this.storedXP = IntMath.saturatedAdd((int)this.storedXP, (int)amount);
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        if (amount > space) {
            return amount - space;
        }
        return 0;
    }

    public int removeXP(int amount) {
        int amountRemoved = Math.min(amount, this.storedXP);
        if (amountRemoved <= 0) {
            return 0;
        }
        this.storedXP -= amountRemoved;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.method_5431();
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        return amountRemoved;
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void setStoredXP(int xp) {
        this.storedXP = xp;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public int getStoredXP() {
        return this.storedXP;
    }

    public float getStoredLevels() {
        return this.storedLevels;
    }

    public void method_11007(class_2487 tag) {
        tag.method_10569("stored_xp", this.storedXP);
        if (this.name != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.name));
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.setStoredXP(tag.method_10550("stored_xp"));
        if (tag.method_10573("CustomName", 8)) {
            this.name = class_2561.class_2562.method_10877((String)tag.method_10558("CustomName"));
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, XPBlockEntity be) {
        if (level.method_8510() % 5L == 0L && GlobalXP.CONFIG.pickupXP && !((Boolean)state.method_11654((class_2769)XPBlock.POWERED)).booleanValue()) {
            be.pickupDroppedXP();
        }
    }

    private void pickupDroppedXP() {
        for (class_1303 orb : this.field_11863.method_8390(class_1303.class, this.getPickupArea(), class_1301.field_6154.and(e -> !e.method_5752().contains("GlobalXPMarker")))) {
            int amount = orb.method_5919();
            if (this.getStoredXP() + amount > this.getCapacity()) continue;
            int unused = this.addXP(amount);
            orb.method_31472();
            if (unused <= 0) continue;
            this.field_11863.method_8649((class_1297)new class_1303(this.field_11863, orb.method_23317(), orb.method_23318(), orb.method_23321(), unused));
        }
    }

    private class_238 getPickupArea() {
        double x = (double)this.method_11016().method_10263() + 0.5;
        double y = (double)this.method_11016().method_10264() + 0.5;
        double z = (double)this.method_11016().method_10260() + 0.5;
        double range = GlobalXP.CONFIG.pickupRange + 0.5;
        return new class_238(x - range, y - range, z - range, x + range, y + range, z + range);
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    public void setCustomName(class_2561 name) {
        this.name = name;
    }

    public class_2561 method_5477() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public class_2561 method_5797() {
        return this.name;
    }

    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)GlobalXP.XP_BLOCK.method_9539());
    }
}

