/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;

public class RepeatingBehaviour<E extends class_1309>
extends ExtendedBehaviour<E> {
    protected final ExtendedBehaviour<E> child;
    protected Predicate<E> shouldRepeat = entity -> true;
    protected ToIntFunction<E> repeatCountProvider = entity -> Integer.MAX_VALUE;
    protected int repeats;

    public RepeatingBehaviour(ExtendedBehaviour<E> child) {
        this.child = child;
        this.noTimeout();
    }

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return this.child.getMemoryRequirements();
    }

    public RepeatingBehaviour<E> repeatingWhen(Predicate<E> predicate) {
        this.shouldRepeat = predicate;
        return this;
    }

    public RepeatingBehaviour<E> repeatNTimes(int repeats) {
        return this.repeatNTimes(entity -> repeats);
    }

    public RepeatingBehaviour<E> repeatNTimes(ToIntFunction<E> function) {
        this.repeatCountProvider = function;
        return this;
    }

    @Override
    protected boolean doStartCheck(class_3218 level, E entity, long gameTime) {
        return super.doStartCheck(level, entity, gameTime) && this.child.method_18922(level, entity, gameTime);
    }

    @Override
    protected void method_18920(class_3218 level, E entity, long gameTime) {
        super.method_18920(level, entity, gameTime);
        this.repeats = this.repeatCountProvider.applyAsInt(entity);
    }

    @Override
    protected boolean method_18927(class_3218 level, E entity, long gameTime) {
        return this.child.method_18921() != class_4097.class_4098.field_18337 || this.repeats > 0;
    }

    @Override
    protected void method_18924(class_3218 level, E entity, long gameTime) {
        super.method_18924(level, entity, gameTime);
        if (this.child.method_18921() != class_4097.class_4098.field_18337) {
            this.child.method_18923(level, (class_1309)entity, gameTime);
            return;
        }
        if (this.repeats > 0 && this.shouldRepeat.test(entity) && this.child.method_18922(level, entity, gameTime)) {
            --this.repeats;
        }
    }

    @Override
    protected void method_18926(class_3218 level, E entity, long gameTime) {
        super.method_18926(level, entity, gameTime);
        if (this.child.method_18921() != class_4097.class_4098.field_18337) {
            this.child.method_18925(level, (class_1309)entity, gameTime);
        }
    }
}

