/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftbquests.quest.reward.AdvancementReward;
import dev.ftb.mods.ftbquests.quest.reward.AllTableReward;
import dev.ftb.mods.ftbquests.quest.reward.ChoiceReward;
import dev.ftb.mods.ftbquests.quest.reward.CommandReward;
import dev.ftb.mods.ftbquests.quest.reward.CustomReward;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.LootReward;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.StageReward;
import dev.ftb.mods.ftbquests.quest.reward.ToastReward;
import dev.ftb.mods.ftbquests.quest.reward.XPLevelsReward;
import dev.ftb.mods.ftbquests.quest.reward.XPReward;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public interface RewardTypes {
    public static final Map<class_2960, RewardType> TYPES = new LinkedHashMap<class_2960, RewardType>();
    public static final RewardType ITEM = RewardTypes.register(new class_2960("ftbquests", "item"), ItemReward::new, () -> Icon.getIcon((String)"minecraft:item/diamond"));
    public static final RewardType CHOICE = RewardTypes.register(new class_2960("ftbquests", "choice"), ChoiceReward::new, () -> Icons.COLOR_RGB).setExcludeFromListRewards(true);
    public static final RewardType ALL_TABLE = RewardTypes.register(new class_2960("ftbquests", "all_table"), AllTableReward::new, () -> Icons.COLOR_HSB).setExcludeFromListRewards(true);
    public static final RewardType RANDOM = RewardTypes.register(new class_2960("ftbquests", "random"), RandomReward::new, () -> Icons.DICE).setExcludeFromListRewards(true);
    public static final RewardType LOOT = RewardTypes.register(new class_2960("ftbquests", "loot"), LootReward::new, () -> Icons.MONEY_BAG).setExcludeFromListRewards(true);
    public static final RewardType COMMAND = RewardTypes.register(new class_2960("ftbquests", "command"), CommandReward::new, () -> Icon.getIcon((String)"minecraft:block/command_block_back"));
    public static final RewardType CUSTOM = RewardTypes.register(new class_2960("ftbquests", "custom"), CustomReward::new, () -> Icons.COLOR_HSB);
    public static final RewardType XP = RewardTypes.register(new class_2960("ftbquests", "xp"), XPReward::new, () -> Icon.getIcon((String)"minecraft:item/experience_bottle"));
    public static final RewardType XP_LEVELS = RewardTypes.register(new class_2960("ftbquests", "xp_levels"), XPLevelsReward::new, () -> Icon.getIcon((String)"minecraft:item/experience_bottle"));
    public static final RewardType ADVANCEMENT = RewardTypes.register(new class_2960("ftbquests", "advancement"), AdvancementReward::new, () -> Icon.getIcon((String)"minecraft:item/wheat"));
    public static final RewardType TOAST = RewardTypes.register(new class_2960("ftbquests", "toast"), ToastReward::new, () -> Icon.getIcon((String)"minecraft:item/oak_sign"));
    public static final RewardType STAGE = RewardTypes.register(new class_2960("ftbquests", "gamestage"), StageReward::new, () -> Icons.CONTROLLER);

    public static RewardType register(class_2960 name, RewardType.Provider p, Supplier<Icon> i) {
        return TYPES.computeIfAbsent(name, id -> new RewardType((class_2960)id, p, i));
    }

    public static void init() {
    }
}

