/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.net.MoveChapterResponseMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.util.NetUtils;
import net.minecraft.class_2540;

public class MoveChapterMessage
extends BaseC2SMessage {
    private final long id;
    private final boolean movingUp;

    public MoveChapterMessage(class_2540 buffer) {
        this.id = buffer.readLong();
        this.movingUp = buffer.readBoolean();
    }

    public MoveChapterMessage(long id, boolean movingUp) {
        this.id = id;
        this.movingUp = movingUp;
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.MOVE_CHAPTER;
    }

    public void write(class_2540 buffer) {
        buffer.writeLong(this.id);
        buffer.writeBoolean(this.movingUp);
    }

    public void handle(NetworkManager.PacketContext context) {
        Chapter chapter;
        if (NetUtils.canEdit(context) && (chapter = ServerQuestFile.INSTANCE.getChapter(this.id)) != null && chapter.getGroup().moveChapterWithinGroup(chapter, this.movingUp)) {
            chapter.file.clearCachedData();
            new MoveChapterResponseMessage(this.id, this.movingUp).sendToAll(ServerQuestFile.INSTANCE.server);
            chapter.file.markDirty();
        }
    }
}

