/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.network.packet;

import com.nine.travelerscompass.common.item.CompassData;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class HUDButtonPacket
extends class_2540 {
    public static final class_2960 ID = new class_2960("travelerscompass", "button_hud_press");

    public HUDButtonPacket(int value, boolean controlPressed, boolean shiftPressed) {
        super(Unpooled.buffer());
        this.writeInt(value);
        this.writeBoolean(controlPressed);
        this.writeBoolean(shiftPressed);
    }

    public static void onMessage(MinecraftServer server, class_3222 player, class_3244 serverGamePacketListener, class_2540 buf, PacketSender packetSender) {
        int id = buf.readInt();
        boolean controlPressed = buf.readBoolean();
        boolean shiftPressed = buf.readBoolean();
        server.execute(() -> {
            class_1799 stack = Objects.requireNonNull(player).method_6047();
            int amount = (shiftPressed ? -1 : 1) * (controlPressed ? 5 : 1);
            class_1792 patt1617$temp = stack.method_7909();
            if (patt1617$temp instanceof TravelersCompassItem) {
                TravelersCompassItem travelersCompassItem = (TravelersCompassItem)patt1617$temp;
                switch (id) {
                    case 1: {
                        if (travelersCompassItem.hudMode(stack)) {
                            travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW);
                            break;
                        }
                        if (travelersCompassItem.hudModeRequiresHeld(stack)) {
                            travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW_HAND);
                            travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW);
                            break;
                        }
                        travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW_HAND);
                        break;
                    }
                    case 2: {
                        if (travelersCompassItem.getXHudPos(stack) + amount < -5) break;
                        travelersCompassItem.setHudPos(stack, travelersCompassItem.getXHudPos(stack) + amount, travelersCompassItem.getYHudPos(stack));
                        break;
                    }
                    case 3: {
                        if (travelersCompassItem.getYHudPos(stack) + amount < -5) break;
                        travelersCompassItem.setHudPos(stack, travelersCompassItem.getXHudPos(stack), travelersCompassItem.getYHudPos(stack) + amount);
                        break;
                    }
                    case 4: {
                        travelersCompassItem.setHudWithChatMode(stack, !travelersCompassItem.hudWithChatMode(stack));
                        break;
                    }
                    case 5: {
                        if (!travelersCompassItem.hudWithChatMode(stack)) {
                            travelersCompassItem.setHudWithChatMode(stack, !travelersCompassItem.hudWithChatMode(stack));
                        }
                        travelersCompassItem.setHudPos(stack, 0, 0);
                        travelersCompassItem.setHudAlign(stack, 0);
                        travelersCompassItem.setHudType(stack, 0);
                        break;
                    }
                    case 6: {
                        int currentPreset = travelersCompassItem.getHudAlign(stack);
                        int preset = currentPreset == 0 || currentPreset == 1 ? currentPreset + 1 : 0;
                        travelersCompassItem.setHudAlign(stack, preset);
                        break;
                    }
                    case 7: {
                        int currentType = travelersCompassItem.getHudType(stack);
                        int type = currentType == 0 ? currentType + 1 : 0;
                        travelersCompassItem.setHudType(stack, type);
                    }
                }
            }
        });
    }
}

