/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.item;

import com.nine.travelerscompass.TravelersCompass;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.common.item.CompassData;
import com.nine.travelerscompass.common.utils.ConfigUtils;
import com.nine.travelerscompass.common.utils.PositionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

public class TravelersCompassItem
extends class_1792 {
    public TravelersCompassItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        final class_1799 stack = player.method_5998(hand);
        CompassContainer compassContainer = CompassContainer.container(stack);
        if (hand != class_1268.field_5808) {
            return class_1271.method_22430((Object)player.method_5998(hand));
        }
        if (player.method_5715()) {
            class_1799 clickedStack;
            class_243 lookVector = player.method_5720();
            class_243 eyePosition = player.method_5836(1.0f);
            class_243 traceEnd = eyePosition.method_1031(lookVector.field_1352 * 5.0, lookVector.field_1351 * 5.0, lookVector.field_1350 * 5.0);
            class_3965 hitResult = level.method_17742(new class_3959(eyePosition, traceEnd, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
            class_2338 blockPos = hitResult.method_17777();
            if (!level.field_9236 && !compassContainer.hasAny(clickedStack = level.method_8320(blockPos).method_26204().method_8389().method_7854()) && ConfigUtils.isAllowedToSearch(clickedStack)) {
                compassContainer.method_5447(compassContainer.getFirstEmptySlot(), clickedStack);
                level.method_8396(null, player.method_23312(), class_3417.field_23199, class_3419.field_15248, 1.0f, 1.0f);
                return class_1271.method_22427((Object)player.method_5998(hand));
            }
        }
        if (!level.field_9236) {
            this.checkForbiddenItems(compassContainer);
            this.checkForbiddenOptions(stack);
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                }

                public class_2561 method_5476() {
                    return stack.method_7964();
                }

                @NotNull
                public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                    return new CompassMenu(i, inventory, CompassContainer.container(stack));
                }
            });
        }
        return class_1271.method_22427((Object)stack);
    }

    public class_1269 method_7847(class_1799 itemStack, class_1657 player, class_1309 living, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            class_1799 eggStack;
            class_1308 mob;
            CompassContainer compassContainer = CompassContainer.container(stack);
            if (player.method_5715() && living instanceof class_1308 && class_1826.method_8019((class_1299)(mob = (class_1308)living).method_5864()) != null && !compassContainer.hasAny(eggStack = Objects.requireNonNull(class_1826.method_8019((class_1299)mob.method_5864())).method_7854()) && ConfigUtils.isAllowedToSearch(eggStack) && ConfigUtils.isAllowedToSearch(living)) {
                compassContainer.method_5447(compassContainer.getFirstEmptySlot(), eggStack);
                player.method_37908().method_8396(null, player.method_23312(), class_3417.field_23199, class_3419.field_15248, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public void updateBlockPosition(class_1937 level, class_1297 entity, class_1799 stack, boolean wideSearch) {
        CompassContainer compassContainer = CompassContainer.container(stack);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof TravelersCompassItem) {
            TravelersCompassItem compassItem = (TravelersCompassItem)class_17922;
            if (compassContainer.method_5442()) {
                compassItem.addBlockPositionTags(null, stack, level, entity);
                return;
            }
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (!TravelersCompassItem.canSearch(player)) {
                    return;
                }
                compassItem.addBlockPositionTags(PositionUtils.getNearestLocation(level, entity, compassItem, compassContainer, stack, wideSearch), stack, level, entity);
            }
        }
    }

    public static class_2338 getFoundPosition(@NotNull class_1799 stack) {
        if (!stack.method_7948().method_10577("found")) {
            return null;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof TravelersCompassItem) {
            TravelersCompassItem compassItem = (TravelersCompassItem)class_17922;
            return class_2512.method_10691((class_2487)stack.method_7911("foundPos"));
        }
        return class_2512.method_10691((class_2487)stack.method_7911("foundPos"));
    }

    public void addBlockPositionTags(PositionUtils.LocationData data, class_1799 stack, class_1937 level, class_1297 entity) {
        boolean shouldPing = false;
        class_2487 compoundTag = stack.method_7948();
        if (data == null || data.getBlockPos() == null) {
            if (compoundTag.method_10577("found")) {
                compoundTag.method_10556("found", false);
            }
            return;
        }
        class_2338 blockPos = data.getBlockPos();
        if (!compoundTag.method_10577("found")) {
            shouldPing = true;
            compoundTag.method_10556("found", true);
        }
        if (this.sound(stack)) {
            if (!Objects.equals(this.foundTarget(stack), data.getName())) {
                shouldPing = true;
            }
            if (shouldPing) {
                if (data.hasAnyFavorite()) {
                    level.method_8396(null, entity.method_24515(), class_3417.field_14627, class_3419.field_15248, 0.3f, 0.3f);
                }
                level.method_8396(null, entity.method_24515(), class_3417.field_14627, class_3419.field_15248, 0.1f, 0.44f + level.field_9229.method_43057() / 10.0f);
                level.method_8396(null, entity.method_24515(), class_3417.field_14627, class_3419.field_15248, 0.1f, 1.0f);
            }
        }
        if (data.getName() != null) {
            this.writeFoundTarget(stack, data.getName());
        } else {
            this.writeFoundTarget(stack, "Null");
        }
        compoundTag.method_10566("foundPos", (class_2520)class_2512.method_10692((class_2338)blockPos));
    }

    public static void xpDrain(class_1657 player) {
        if (!player.method_7337() && !player.method_7325()) {
            int currentExp = player.field_7495;
            if (currentExp - TravelersCompass.CONFIG.xpCost > 0) {
                player.method_7255(-TravelersCompass.CONFIG.xpCost);
            } else {
                player.field_7520 = 0;
                player.field_7510 = 0.0f;
                player.field_7495 = 0;
            }
        }
    }

    public static boolean canSearch(class_1657 player) {
        if (!TravelersCompass.CONFIG.xpDrain) {
            return true;
        }
        if (!player.method_7337() && !player.method_7325()) {
            int currentExp = player.field_7495;
            return currentExp > 0;
        }
        return true;
    }

    public void checkForbiddenItems(CompassContainer compassContainer) {
        for (int index = 0; index < 9; ++index) {
            if (ConfigUtils.isAllowedToSearch(compassContainer.method_5438(index))) continue;
            compassContainer.method_5434(index, 1);
        }
    }

    public void checkForbiddenOptions(class_1799 stack) {
        if (this.isSearchingEntitiesInv(stack) && !TravelersCompass.CONFIG.enableMobsInventorySearch) {
            this.writeCompassData(stack, CompassData.SEARCHING_ENTITIES_INV);
        }
        if (this.isSearchingBlocks(stack) && !TravelersCompass.CONFIG.enableBlockSearch) {
            this.writeCompassData(stack, CompassData.SEARCHING_BLOCKS);
        }
        if (this.isSearchingFluids(stack) && !TravelersCompass.CONFIG.enableFluidSearch) {
            this.writeCompassData(stack, CompassData.SEARCHING_FLUIDS);
        }
        if (this.isSearchingItemEntities(stack) && !TravelersCompass.CONFIG.enableItemEntitiesSearch) {
            this.writeCompassData(stack, CompassData.SEARCHING_DROPPED_ITEMS);
        }
        if (this.isSearchingVillagers(stack) && !TravelersCompass.CONFIG.enableVillagersSearch) {
            this.writeCompassData(stack, CompassData.SEARCHING_VILLAGERS);
        }
        if (this.isSearchingDrops(stack) && !TravelersCompass.CONFIG.enableDropSearch) {
            this.writeCompassData(stack, CompassData.SEARCHING_ENTITIES_DROP);
        }
        if (this.isSearchingMobs(stack) && !TravelersCompass.CONFIG.enableMobSearch) {
            this.writeCompassData(stack, CompassData.SEARCHING_MOBS);
        }
        if (this.isSearchingContainers(stack) && !TravelersCompass.CONFIG.enableContainerSearch) {
            this.writeCompassData(stack, CompassData.SEARCHING_CONTAINERS);
        }
        if (this.isSearchingMobsInv(stack) && !TravelersCompass.CONFIG.enableMobsInventorySearch) {
            this.writeCompassData(stack, CompassData.SEARCHING_MOBS_INV);
        }
        if (this.isSearchingSpawners(stack) && !TravelersCompass.CONFIG.enableSpawnerSearch) {
            this.writeCompassData(stack, CompassData.SEARCHING_SPAWNERS);
        }
        if (!this.isLazyModeOn(stack) && TravelersCompass.CONFIG.forcedLazySearchMode) {
            this.writeCompassData(stack, CompassData.LAZY_MODE);
        }
        if ((this.hudMode(stack) || this.hudModeRequiresHeld(stack)) && !TravelersCompass.CONFIG.enableHud) {
            this.writeCompassData(stack, this.hudMode(stack) ? CompassData.HUD_SHOW : CompassData.HUD_SHOW_HAND);
        }
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 pLevel, @NotNull class_1297 pEntity, int pItemSlot, boolean pIsSelected) {
        if (pEntity instanceof class_1657) {
            class_1657 player = (class_1657)pEntity;
            class_2338 targetBlockPos = TravelersCompassItem.getFoundPosition(stack);
            boolean lazyCheck = true;
            CompassContainer compassContainer = CompassContainer.container(stack);
            if (compassContainer.method_5442() && targetBlockPos == null) {
                if (this.positionRelativeToTarget(stack) != 6) {
                    this.setPositionRelativeToTarget(stack, 6);
                }
                return;
            }
            if (player.field_6012 % 20 == 0) {
                this.checkPossibleResourceRecovery(player, stack, compassContainer);
            }
            if (!TravelersCompassItem.canSearch(player)) {
                if (this.positionRelativeToTarget(stack) != 5) {
                    this.setPositionRelativeToTarget(stack, 5);
                }
                return;
            }
            int lazyBonus = 0;
            if (this.isLazyModeOn(stack) && targetBlockPos != null) {
                if (Math.sqrt(targetBlockPos.method_10262((class_2382)player.method_24515())) < 15.0) {
                    lazyCheck = false;
                }
                lazyBonus = TravelersCompass.CONFIG.searchRate * 2 * (1500 / (1 + (int)Math.sqrt(targetBlockPos.method_10262((class_2382)player.method_24515()))));
            }
            if (lazyCheck && (player.field_6012 % (TravelersCompass.CONFIG.searchRate + lazyBonus) == 0 && !pLevel.field_9236 && !this.isPaused(stack) || this.wideSearchSignal(stack))) {
                this.updateBlockPosition(pLevel, pEntity, stack, this.wideSearchSignal(stack));
                if (this.wideSearchSignal(stack)) {
                    this.writeCompassData(stack, CompassData.WIDE_SEARCH_SIGNAL);
                }
            }
            if (TravelersCompass.CONFIG.xpDrain && player.field_6012 % TravelersCompass.CONFIG.xpDrainRate == 0 && !this.isPaused(stack) && TravelersCompassItem.getFoundPosition(stack) != null) {
                TravelersCompassItem.xpDrain(player);
            }
            if (player.field_6012 % 40 == 0) {
                if (targetBlockPos == null) {
                    if (this.positionRelativeToTarget(stack) != 4) {
                        this.setPositionRelativeToTarget(stack, 4);
                    }
                    return;
                }
                class_2338 userPos = player.method_23312();
                double livingY = userPos.method_10264();
                double targetY = Objects.requireNonNull(targetBlockPos).method_10264();
                double point1 = targetY - livingY;
                if (this.showLabels(stack) && this.positionRelativeToTarget(stack) != -2) {
                    this.setPositionRelativeToTarget(stack, -2);
                }
                if (this.showLabels(stack)) {
                    return;
                }
                if (targetY == livingY || point1 <= 2.0 && point1 >= 1.0 && this.positionRelativeToTarget(stack) != 3) {
                    this.setPositionRelativeToTarget(stack, 3);
                } else if (!(!(targetY > livingY) || point1 <= 2.0 && point1 >= 1.0 || this.positionRelativeToTarget(stack) == 2)) {
                    this.setPositionRelativeToTarget(stack, 2);
                } else if (targetY < livingY && this.positionRelativeToTarget(stack) != 1) {
                    this.setPositionRelativeToTarget(stack, 1);
                }
            }
        }
    }

    private void checkPossibleResourceRecovery(class_1657 player, class_1799 stack, CompassContainer compassContainer) {
        List<class_1792> list = compassContainer.getList();
        int k = 0;
        for (int i = 0; i < 9; ++i) {
            class_1792 item = compassContainer.method_5438(i).method_7909();
            if (i == 4 && item.equals(class_1802.field_8251)) {
                ++k;
            }
            if (i == 7 && item.equals(class_1802.field_23256)) {
                ++k;
                continue;
            }
            if (i == 7 || i == 4 || !item.equals(class_1802.field_8620)) continue;
            ++k;
        }
        if (k == 9) {
            for (class_1792 item : list) {
                class_1542 itementity = new class_1542(player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), item.method_7854());
                player.method_37908().method_8649((class_1297)itementity);
            }
            stack.method_7934(1);
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof CompassMenu) {
                CompassMenu menu = (CompassMenu)class_17032;
                player.method_7346();
            }
        }
    }

    public boolean isSearchingVillagers(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_VILLAGERS);
    }

    public boolean isSearchingItemEntities(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_DROPPED_ITEMS);
    }

    public boolean isSearchingVillagersGoods(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_VILLAGERS_GOODS);
    }

    public boolean isSearchingVillagersCost(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_VILLAGERS_COST);
    }

    public boolean isSearchingMobsInv(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_MOBS_INV);
    }

    public boolean isSearchingMinecartsInv(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_MINECARTS_INV);
    }

    public boolean isSearchingPlayersInv(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_PLAYERS_INV);
    }

    public boolean isSearchingFluids(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_FLUIDS);
    }

    public boolean isSearchingSpawners(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_SPAWNERS);
    }

    public boolean isSearchingEntitiesInv(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_ENTITIES_INV);
    }

    public boolean isSearchingContainers(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_CONTAINERS);
    }

    public boolean isSearchingDrops(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_ENTITIES_DROP);
    }

    public boolean isSearchingBlocks(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_BLOCKS);
    }

    public boolean isSearchingMobs(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_MOBS);
    }

    public boolean isLazyModeOn(class_1799 stack) {
        return this.getCompassData(stack, CompassData.LAZY_MODE);
    }

    public boolean sound(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SOUND);
    }

    public boolean isPaused(class_1799 stack) {
        return this.getCompassData(stack, CompassData.PAUSED);
    }

    public boolean wideSearchSignal(class_1799 stack) {
        return this.getCompassData(stack, CompassData.WIDE_SEARCH_SIGNAL);
    }

    public boolean showLabels(class_1799 stack) {
        return this.getCompassData(stack, CompassData.SHOW_LABELS);
    }

    public boolean priorityMode(class_1799 stack) {
        return !this.getCompassData(stack, CompassData.PRIORITY_MODE);
    }

    public boolean hudMode(class_1799 stack) {
        return this.getCompassData(stack, CompassData.HUD_SHOW);
    }

    public boolean hudModeRequiresHeld(class_1799 stack) {
        return this.getCompassData(stack, CompassData.HUD_SHOW_HAND);
    }

    public boolean getCompassData(class_1799 stack, CompassData mode) {
        int id = mode.getID();
        ArrayList<Integer> modeValues = this.integerArrayList(stack, "compass_data");
        return modeValues.contains(id);
    }

    public void writeCompassData(class_1799 stack, CompassData mode) {
        int id = mode.getID();
        this.putIntArray(stack, id, "compass_data");
    }

    public void markFavoriteItem(class_1799 stack, boolean mode) {
        stack.method_7948().method_10556("favorite", mode);
    }

    public boolean hasFavoriteItem(class_1799 stack) {
        return stack.method_7948().method_10577("favorite");
    }

    public void addFavoriteSlot(class_1799 stack, int slot) {
        this.putIntArray(stack, slot, "favoriteSlots");
    }

    public ArrayList<Integer> favoriteSlots(class_1799 stack) {
        return this.integerArrayList(stack, "favoriteSlots");
    }

    public ArrayList<Integer> selectedModes(class_1799 stack) {
        return this.integerArrayList(stack, "compass_data");
    }

    public void setConfigMode(class_1799 stack, boolean mode) {
        stack.method_7948().method_10556("configMode", mode);
    }

    public boolean configMode(class_1799 stack) {
        return stack.method_7948().method_10577("configMode");
    }

    public void writeFoundTarget(class_1799 stack, String target) {
        stack.method_7948().method_10582("targetData", target);
    }

    public String foundTarget(class_1799 stack) {
        return stack.method_7948().method_10558("targetData");
    }

    public void setPositionRelativeToTarget(class_1799 stack, int pos) {
        stack.method_7948().method_10569("pos_to_target", pos);
    }

    public int positionRelativeToTarget(class_1799 stack) {
        return stack.method_7948().method_10550("pos_to_target");
    }

    public int blockSearchRadius(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("block_search_radius", 3)) {
            return tag.method_10550("block_search_radius");
        }
        return (int)((float)TravelersCompass.CONFIG.blockSearchRadius * 0.5f);
    }

    public void setBlockSearchRadius(class_1799 stack, int radius) {
        stack.method_7948().method_10569("block_search_radius", radius);
    }

    public int containerSearchRadius(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("container_search_radius", 3)) {
            return tag.method_10550("container_search_radius");
        }
        return (int)((float)TravelersCompass.CONFIG.containerSearchRadius * 0.5f);
    }

    public void setContainerSearchRadius(class_1799 stack, int radius) {
        stack.method_7948().method_10569("container_search_radius", radius);
    }

    public int entitySearchRadius(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("entity_search_radius", 3)) {
            return tag.method_10550("entity_search_radius");
        }
        return (int)((float)TravelersCompass.CONFIG.entitySearchRadius * 0.5f);
    }

    public void setEntitySearchRadius(class_1799 stack, int radius) {
        stack.method_7948().method_10569("entity_search_radius", radius);
    }

    public int wideSearchRadius(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("wide_search_radius", 3)) {
            return tag.method_10550("wide_search_radius");
        }
        return (int)((float)TravelersCompass.CONFIG.wideSearchRadius * 0.5f);
    }

    public void setWideSearchRadius(class_1799 stack, int radius) {
        stack.method_7948().method_10569("wide_search_radius", radius);
    }

    public void setHudWithChatMode(class_1799 stack, boolean mode) {
        stack.method_7948().method_10556("hud_chat", mode);
    }

    public boolean hudWithChatMode(class_1799 stack) {
        return stack.method_7948().method_10577("hud_chat");
    }

    public void setHudPos(class_1799 stack, int x, int y) {
        int[] data = new int[4];
        data[0] = x;
        data[1] = y;
        if (stack.method_7909() instanceof TravelersCompassItem) {
            data[2] = this.getHudAlign(stack);
            data[3] = this.getHudType(stack);
        }
        stack.method_7948().method_10539("hud_data", data);
    }

    public void setHudAlign(class_1799 stack, int type) {
        int[] data = new int[4];
        data[2] = type;
        data[0] = this.getXHudPos(stack);
        data[1] = this.getYHudPos(stack);
        data[3] = this.getHudType(stack);
        stack.method_7948().method_10539("hud_data", data);
    }

    public void setHudType(class_1799 stack, int type) {
        int[] data = new int[4];
        data[2] = this.getHudAlign(stack);
        data[0] = this.getXHudPos(stack);
        data[1] = this.getYHudPos(stack);
        data[3] = type;
        stack.method_7948().method_10539("hud_data", data);
    }

    public int getHudAlign(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("hud_data", 11)) {
            return stack.method_7948().method_10561("hud_data")[2];
        }
        return 0;
    }

    public int getHudType(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("hud_data", 11)) {
            return stack.method_7948().method_10561("hud_data")[3];
        }
        return 0;
    }

    public int getXHudPos(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("hud_data", 11)) {
            return stack.method_7948().method_10561("hud_data")[0];
        }
        return 0;
    }

    public int getYHudPos(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("hud_data", 11)) {
            return stack.method_7948().method_10561("hud_data")[1];
        }
        return 0;
    }

    public void putIntArray(class_1799 stack, int slot, String tag) {
        int[] existingSlots = stack.method_7948().method_10561(tag);
        ArrayList<Integer> slotsList = new ArrayList<Integer>();
        for (int existingSlot : existingSlots) {
            slotsList.add(existingSlot);
        }
        if (slotsList.contains(slot)) {
            slotsList.remove((Object)slot);
        } else {
            slotsList.add(slot);
        }
        int[] newSlots = new int[slotsList.size()];
        for (int i = 0; i < slotsList.size(); ++i) {
            newSlots[i] = (Integer)slotsList.get(i);
        }
        stack.method_7948().method_10539(tag, newSlots);
    }

    public ArrayList<Integer> integerArrayList(class_1799 stack, String tag) {
        int[] slotsArray = stack.method_7948().method_10561(tag);
        ArrayList<Integer> slotsList = new ArrayList<Integer>();
        for (int slot : slotsArray) {
            slotsList.add(slot);
        }
        return slotsList;
    }
}

