/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.render.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_6395;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CustomAnglePredicateProvider
implements class_6395 {
    public static final int field_38798 = 0;
    private final AngleInterpolator aimedInterpolator = new AngleInterpolator();
    private final AngleInterpolator aimlessInterpolator = new AngleInterpolator();
    public final CompassTarget compassTarget;

    public CustomAnglePredicateProvider(CompassTarget compassTarget) {
        this.compassTarget = compassTarget;
    }

    public float unclampedCall(class_1799 itemStack, @Nullable class_638 clientLevel, @Nullable class_1309 livingEntity, int i) {
        class_1309 entity = livingEntity != null ? livingEntity : itemStack.method_27319();
        class_1309 entity2 = entity;
        if (entity == null) {
            return 0.0f;
        }
        if ((clientLevel = this.getClientLevel((class_1297)entity, clientLevel)) == null) {
            return 0.0f;
        }
        return this.getAngle(itemStack, clientLevel, i, (class_1297)entity);
    }

    private float getAngle(class_1799 stack, class_638 world, int seed, class_1297 entity) {
        class_2338 blockPos = this.compassTarget.getPos(world, stack, entity);
        long l = world.method_8510();
        if (!this.canPointTo(entity, blockPos)) {
            return this.getAimlessAngle(seed, l);
        }
        return this.getAngleTo(entity, l, blockPos);
    }

    private float getAimlessAngle(int seed, long time) {
        if (this.aimlessInterpolator.shouldUpdate(time)) {
            this.aimlessInterpolator.update(time, Math.random());
        }
        double d = this.aimlessInterpolator.value + (double)((float)this.scatter(seed) / 2.1474836E9f);
        return class_3532.method_15341((float)((float)d), (float)1.0f);
    }

    private float getAngleTo(class_1297 entity, long time, class_2338 pos) {
        double f;
        class_1657 playerEntity;
        double d = this.getAngleTo(entity, pos);
        double e = this.getBodyYaw(entity);
        if (entity instanceof class_1657 && (playerEntity = (class_1657)entity).method_7340()) {
            if (this.aimedInterpolator.shouldUpdate(time)) {
                this.aimedInterpolator.update(time, 0.5 - (e - 0.25));
            }
            f = d + this.aimedInterpolator.value;
        } else {
            f = 0.5 - (e - 0.25 - d);
        }
        return class_3532.method_15341((float)((float)f), (float)1.0f);
    }

    @Nullable
    private class_638 getClientLevel(class_1297 entity, @Nullable class_638 world) {
        if (world == null && entity.method_37908() instanceof class_638) {
            return (class_638)entity.method_37908();
        }
        return world;
    }

    private boolean canPointTo(class_1297 entity, @Nullable class_2338 pos) {
        return pos != null && !(pos.method_10262((class_2382)entity.method_24515()) < (double)1.0E-5f);
    }

    private double getAngleTo(class_1297 entity, class_2338 pos) {
        class_243 vec3d = class_243.method_24953((class_2382)pos);
        return Math.atan2(vec3d.field_1350 - entity.method_23321(), vec3d.field_1352 - entity.method_23317()) / 6.2831854820251465;
    }

    private double getBodyYaw(class_1297 entity) {
        return class_3532.method_15367((double)(entity.method_36454() / 360.0f), (double)1.0);
    }

    private int scatter(int seed) {
        return seed * 1327217883;
    }

    @Environment(value=EnvType.CLIENT)
    static class AngleInterpolator {
        double value;
        private double speed;
        private long lastUpdateTime;

        AngleInterpolator() {
        }

        boolean shouldUpdate(long time) {
            return this.lastUpdateTime != time;
        }

        void update(long time, double target) {
            this.lastUpdateTime = time;
            double d = target - this.value;
            d = class_3532.method_15367((double)(d + 0.5), (double)1.0) - 0.5;
            this.speed += d * 0.1;
            this.speed *= 0.8;
            this.value = class_3532.method_15367((double)(this.value + this.speed), (double)1.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface CompassTarget {
        @Nullable
        public class_2338 getPos(class_638 var1, class_1799 var2, class_1297 var3);
    }
}

