/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class TCConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @SerializedName(value="Mobs search radius (in blocks)")
    public int entitySearchRadius = 200;
    @SerializedName(value="Block search radius (in blocks). Large values may result in lag issues")
    public int blockSearchRadius = 100;
    @SerializedName(value="Containers search radius (in blocks). Large values may result in lag issues")
    public int containerSearchRadius = 100;
    @SerializedName(value="Maximum wide search radius (in blocks). Large values may result in serious lag issues.")
    public int wideSearchRadius = 200;
    @SerializedName(value="Will experience be drained for using the compass?")
    public boolean xpDrain = false;
    @SerializedName(value="How often the compass search target will be updated. Low values can cause SERIOUS performance problems.")
    public int searchRate = 50;
    @SerializedName(value="How much XP will be drained from player when Compass is active?")
    public int xpCost = 2;
    @SerializedName(value="How often experience will be spent for using the compass?")
    public int xpDrainRate = 2;
    @SerializedName(value="Allows players to search for mobs based on their Spawn Eggs.")
    public boolean enableMobSearch = true;
    @SerializedName(value="Allows players to search for containers (chests, furnaces, etc.) based on their contents.")
    public boolean enableContainerSearch = true;
    @SerializedName(value="Allows players to search for blocks.")
    public boolean enableBlockSearch = true;
    @SerializedName(value="Allows players to search for Villagers based on their trade items.")
    public boolean enableVillagersSearch = true;
    @SerializedName(value="Allows players to search for mobs based on their drop.")
    public boolean enableDropSearch = true;
    @SerializedName(value="Allows players to search for items lying on the ground.")
    public boolean enableItemEntitiesSearch = true;
    @SerializedName(value="Allows players to search for fluids based on their buckets.")
    public boolean enableFluidSearch = true;
    @SerializedName(value="Allows players to search for spawners.")
    public boolean enableSpawnerSearch = true;
    @SerializedName(value="Allows players to search for entities based on their inventories.")
    public boolean enableMobsInventorySearch = true;
    @SerializedName(value="Allows the player to use a search function that has a wider search radius.")
    public boolean enableWiderSearch = true;
    @SerializedName(value="Setting the value to true will make the compass search for all objects except those specified in the list.\nSetting it to false will make the compass search only for objects listed in the list.")
    public boolean blackListFilter = true;
    @SerializedName(value="Enables the slow search mode forcibly. It cannot be disabled in the game")
    public boolean forcedLazySearchMode = false;
    @SerializedName(value="Will the player in the game be able to access the HUD that displays information about the found object?")
    public boolean enableHud = true;
    @SerializedName(value="Items and blocks in this list will be filtered based on the filtering mode set above.\nExample: [\"minecraft.diamond_block\", \"minecraft.carrot\", \"twilightforest.cicada\"]")
    public List<String> filteredItemList = new ArrayList<String>();
    @SerializedName(value="Items and blocks in this list will be filtered based on their tags.\nExample: [\"forge:stone\"]")
    public List<String> filteredTagItemList = new ArrayList<String>();
    @SerializedName(value="Anything related to the mods in the list below will (not) be searched by compass.\nExample: [\"alexscaves\", \"ae2\", \"minecraft\"]")
    public List<String> filteredModList = new ArrayList<String>();
    @SerializedName(value="Entities in this list will be filtered based on what mod they are from.\nExample: [\"creeperoverhaul\", \"deeperdarker\", \"minecraft\"]")
    public List<String> filteredModListEntities = new ArrayList<String>();
    @SerializedName(value="All items and blocks will (not) be searched if the mod they belong to is in the list below")
    public List<String> filteredModListItems = new ArrayList<String>();
    @SerializedName(value="Entities in this list will be filtered based on their names.\nExample: [\"entity.minecraft.trader_llama\", \"entity.mowziesmobs.foliaath\"]")
    public List<String> filteredEntities = new ArrayList<String>();
    @SerializedName(value="Enable interaction with the REI panel")
    public boolean REICompatibility = true;
    @SerializedName(value="Enable interaction with the JEI panel")
    public boolean JEICompatibility = true;
    @SerializedName(value="Enable the search for the contents of chests and minecarts from the Lootr mod that have not yet been opened by the player")
    public boolean LootrCompatibility = true;
    @SerializedName(value="Allows to show TOP tooltips regarding blocks/entities that you can/can't search for")
    public boolean TheOneProbeCompatibility = true;
    @SerializedName(value="Allows to show Jade tooltips regarding blocks/entities that you can/can't search for")
    public boolean JadeCompatibility = true;
    @SerializedName(value="Prevents players from searching items lying on the ground. Default Value - false")
    public boolean disableItemEntitiesSearch = false;

    public static TCConfig loadConfig(File file) {
        TCConfig config;
        block18: {
            if (file.exists() && file.isFile()) {
                try (FileInputStream fileInputStream = new FileInputStream(file);
                     InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    config = (TCConfig)GSON.fromJson((Reader)bufferedReader, TCConfig.class);
                    break block18;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load config", e);
                }
            }
            config = new TCConfig();
        }
        config.saveConfig(file);
        return config;
    }

    public void saveConfig(File configFile) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(configFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config", e);
        }
    }
}

