/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.FTBChunksProperties;
import dev.ftb.mods.ftbchunks.client.VisibleClientPlayers;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PlayerVisibilityPacket
extends BaseS2CMessage {
    private final List<UUID> uuids;

    private PlayerVisibilityPacket(List<UUID> uuids) {
        this.uuids = uuids;
    }

    PlayerVisibilityPacket(class_2540 buf) {
        this.uuids = buf.method_34066(class_2540::method_10790);
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_VISIBLE_PLAYER_LIST;
    }

    public void write(class_2540 buf) {
        buf.method_34062(this.uuids, class_2540::method_10797);
    }

    public void handle(NetworkManager.PacketContext context) {
        VisibleClientPlayers.updatePlayerList(this.uuids);
    }

    public static void syncToLevel(class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            PlayerVisibilityPacket.syncToPlayers(serverLevel.method_18766(p -> true));
        }
    }

    public static void syncToAll() {
        PlayerVisibilityPacket.syncToPlayers(ClaimedChunkManagerImpl.getInstance().getMinecraftServer().method_3760().method_14571());
    }

    public static void syncToPlayers(List<class_3222> players) {
        if (players == null) {
            players = ClaimedChunkManagerImpl.getInstance().getMinecraftServer().method_3760().method_14571();
        }
        List playerList = players.stream().map(player -> new VisiblePlayerItem((class_3222)player, ClaimedChunkManagerImpl.getInstance().getOrCreateData((class_3222)player))).collect(Collectors.toList());
        boolean override = (Boolean)FTBChunksWorldConfig.LOCATION_MODE_OVERRIDE.get();
        for (VisiblePlayerItem recipient : playerList) {
            ArrayList<UUID> playerIds = new ArrayList<UUID>();
            for (VisiblePlayerItem other : playerList) {
                if (!override && !recipient.player.method_5687(2) && !other.data.canPlayerUse(recipient.player, FTBChunksProperties.LOCATION_MODE)) continue;
                playerIds.add(other.player.method_5667());
            }
            new PlayerVisibilityPacket(playerIds).sendTo(recipient.player);
        }
    }

    private record VisiblePlayerItem(class_3222 player, ChunkTeamDataImpl data) {
    }
}

