/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.util.HeightUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import net.minecraft.class_1163;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4543;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ChunkUpdateTask
implements MapTask,
class_4543.class_4544 {
    private static final int[] ALL_BLOCKS = (int[])class_156.method_654((Object)new int[256], array -> {
        for (int i = 0; i < 256; ++i) {
            array[i] = i;
        }
    });
    private static final class_2960 AIR = new class_2960("minecraft:air");
    private static long debugLastTime = 0L;
    private MapManager manager;
    private final class_1937 level;
    private final class_2791 chunkAccess;
    private final class_1923 chunkPos;
    private final int[] blocksToUpdate;
    private final long taskStartTime;

    public ChunkUpdateTask(@Nullable MapManager manager, class_1937 level, class_2791 chunkAccess, class_1923 chunkPos) {
        this(manager, level, chunkAccess, chunkPos, ALL_BLOCKS);
    }

    public ChunkUpdateTask(@Nullable MapManager manager, class_1937 level, class_2791 chunkAccess, class_1923 chunkPos, int[] blocksToUpdate) {
        this.manager = manager;
        this.level = level;
        this.chunkAccess = chunkAccess;
        this.chunkPos = chunkPos;
        this.blocksToUpdate = blocksToUpdate;
        this.taskStartTime = System.currentTimeMillis();
    }

    public static void init() {
        debugLastTime = 0L;
    }

    public static long getDebugLastTime() {
        return debugLastTime;
    }

    @Override
    public void runMapTask() throws Exception {
        boolean versionChange;
        while (this.manager == null) {
            this.manager = MapManager.getInstance().orElse(null);
            if (this.manager != null) continue;
            if (System.currentTimeMillis() - this.taskStartTime >= 30000L) {
                return;
            }
            Thread.sleep(1L);
        }
        if (this.manager.isInvalid()) {
            return;
        }
        long startTime = System.nanoTime();
        class_5321 dimId = this.level.method_27983();
        MapChunk mapChunk = this.manager.getDimension((class_5321<class_1937>)dimId).getRegion(XZ.regionFromChunk((class_1923)this.chunkPos)).getDataBlocking().getChunk(XZ.of((class_1923)this.chunkPos));
        MapRegionData data = mapChunk.getRegionData();
        class_2378 biomes = this.level.method_30349().method_30530(class_7924.field_41236);
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        int blockX = this.chunkPos.method_8326();
        int blockZ = this.chunkPos.method_8328();
        boolean changed = false;
        boolean bl = versionChange = mapChunk.getVersion() != 4;
        if (versionChange) {
            mapChunk.setVersion(4);
            changed = true;
        }
        for (int wi : this.blocksToUpdate) {
            int wx = wi % 16;
            int wz = wi / 16;
            blockPos.method_10103(blockX + wx, this.chunkAccess.method_12005(class_2902.class_2903.field_13197, blockX + wx, blockZ + wz) + 2, blockZ + wz);
            int waterY = class_3532.method_15340((int)HeightUtils.getHeight(this.level, this.chunkAccess, blockPos), (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
            int height = blockPos.method_10264();
            class_2680 state = this.chunkAccess.method_8320((class_2338)blockPos);
            int ax = mapChunk.getPos().x() * 16 + wx;
            int az = mapChunk.getPos().z() * 16 + wz;
            int index = ax + az * 512;
            int waterLightAndBiome0 = data.waterLightAndBiome[index] & 0xFFFF;
            int blockIndex0 = data.getBlockIndex(index);
            short height0 = data.height[index];
            blockPos.method_33098(waterY == -32767 ? height : waterY);
            int waterLightAndBiome = waterLightAndBiome0 & 0x7FF;
            waterLightAndBiome |= waterY != -32767 ? 32768 : 0;
            waterLightAndBiome |= (this.level.method_8314(class_1944.field_9282, (class_2338)blockPos) & 0xF) << 11;
            class_2960 id = state == null ? AIR : FTBChunks.BLOCK_REGISTRY.getId((Object)state.method_26204());
            int blockIndex = this.manager.getBlockColorIndex(id == null ? AIR : id);
            class_1959 biome = (class_1959)this.method_16359(blockPos.method_10263() >> 2, blockPos.method_10264() >> 2, blockPos.method_10260() >> 2).comp_349();
            waterLightAndBiome &= 0xF800;
            waterLightAndBiome |= this.manager.getBiomeColorIndex((class_2378<class_1959>)biomes, biome, biome) & 0x7FF;
            if (versionChange || height0 != height) {
                data.height[index] = (short)height;
                changed = true;
            }
            if (versionChange || waterLightAndBiome0 != waterLightAndBiome) {
                data.waterLightAndBiome[index] = (short)waterLightAndBiome;
                if (biome != null && (versionChange || (waterLightAndBiome0 & 0x7FF) != (waterLightAndBiome & 0x7FF))) {
                    double cx = blockPos.method_10263();
                    double cz = blockPos.method_10260();
                    data.foliage[index] = data.foliage[index] & 0xFF000000 | class_1163.field_5664.getColor(biome, cx, cz) & 0xFFFFFF;
                    data.grass[index] = data.grass[index] & 0xFF000000 | class_1163.field_5665.getColor(biome, cx, cz) & 0xFFFFFF;
                    data.water[index] = data.water[index] & 0xFF000000 | class_1163.field_5666.getColor(biome, cx, cz) & 0xFFFFFF;
                }
                changed = true;
            }
            if (!versionChange && blockIndex0 == blockIndex) continue;
            data.setBlockIndex(index, blockIndex);
            changed = true;
        }
        if (changed) {
            mapChunk.forceUpdate();
        }
        debugLastTime = System.nanoTime() - startTime;
    }

    public String toString() {
        return "ChunkUpdateTask@" + String.valueOf(this.chunkPos);
    }

    public class_6880<class_1959> method_16359(int x, int y, int z) {
        if (x >> 2 == this.chunkPos.field_9181 && z >> 2 == this.chunkPos.field_9180) {
            return this.chunkAccess.method_16359(x, y, z);
        }
        return this.level.method_16359(x, y, z);
    }
}

