/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.api;

import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.api.FTBChunksProperties;
import dev.ftb.mods.ftbchunks.api.FTBChunksTags;
import dev.ftb.mods.ftbchunks.api.ProtectionPolicy;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_4081;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface Protection {
    public static final Protection EDIT_BLOCK = (player, pos, hand, chunk, entity) -> {
        class_2680 blockState = player.method_37908().method_8320(pos);
        if (blockState.method_26164(FTBChunksTags.Blocks.EDIT_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_EDIT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection INTERACT_BLOCK = (player, pos, hand, chunk, entity) -> {
        class_2680 blockState = player.method_37908().method_8320(pos);
        if (blockState.method_26164(FTBChunksTags.Blocks.INTERACT_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_INTERACT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection RIGHT_CLICK_ITEM = (player, pos, hand, chunk, entity) -> {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_19267() || Protection.isBeneficialPotion(stack) || stack.method_31573(FTBChunksTags.Items.RIGHT_CLICK_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_INTERACT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && stack.method_31573(FTBChunksTags.Items.RIGHT_CLICK_BLACKLIST_TAG)) {
            return ProtectionPolicy.DENY;
        }
        return ProtectionPolicy.ALLOW;
    };
    public static final Protection EDIT_FLUID = (player, pos, hand, chunk, entity) -> {
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_EDIT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection INTERACT_ENTITY = (player, pos, hand, chunk, entity) -> {
        if (entity != null && entity.method_5864().method_20210(FTBChunksTags.Entities.ENTITY_INTERACT_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.ENTITY_INTERACT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection ATTACK_NONLIVING_ENTITY = (player, pos, hand, chunk, entity) -> {
        if (entity != null && entity.method_5864().method_20210(FTBChunksTags.Entities.NONLIVING_ENTITY_ATTACK_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.NONLIVING_ENTITY_ATTACK_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection EDIT_AND_INTERACT_BLOCK = (player, pos, hand, chunk, entity) -> {
        class_2680 blockState = player.method_37908().method_8320(pos);
        if (blockState.method_26164(FTBChunksTags.Blocks.INTERACT_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_EDIT_AND_INTERACT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };

    public ProtectionPolicy getProtectionPolicy(class_3222 var1, class_2338 var2, class_1268 var3, @Nullable ClaimedChunk var4, @Nullable class_1297 var5);

    public static boolean isBeneficialPotion(class_1799 stack) {
        return stack.method_7909() instanceof class_1812 && class_1844.method_8067((class_1799)stack).stream().noneMatch(effect -> effect.method_5579().method_18792() == class_4081.field_18272);
    }
}

