/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.exlll.configlib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Queue;
import net.kenddie.exlll.configlib.CommentNode;
import net.kenddie.exlll.configlib.CommentNodeExtractor;
import net.kenddie.exlll.configlib.ConfigurationException;
import net.kenddie.exlll.configlib.FileConfigurationStore;
import net.kenddie.exlll.configlib.IOStreamConfigurationStore;
import net.kenddie.exlll.configlib.TypeSerializer;
import net.kenddie.exlll.configlib.Validator;
import net.kenddie.exlll.configlib.YamlConfigurationProperties;
import net.kenddie.exlll.configlib.YamlWriter;
import net.kenddie.snakeyaml.engine.v2.api.Dump;
import net.kenddie.snakeyaml.engine.v2.api.DumpSettings;
import net.kenddie.snakeyaml.engine.v2.api.Load;
import net.kenddie.snakeyaml.engine.v2.api.LoadSettings;
import net.kenddie.snakeyaml.engine.v2.common.FlowStyle;
import net.kenddie.snakeyaml.engine.v2.exceptions.YamlEngineException;
import net.kenddie.snakeyaml.engine.v2.nodes.Node;
import net.kenddie.snakeyaml.engine.v2.nodes.Tag;
import net.kenddie.snakeyaml.engine.v2.representer.StandardRepresenter;

public final class YamlConfigurationStore<T>
implements FileConfigurationStore<T>,
IOStreamConfigurationStore<T> {
    private static final Dump YAML_DUMPER = YamlConfigurationStore.newYamlDumper();
    private static final Load YAML_LOADER = YamlConfigurationStore.newYamlLoader();
    private final YamlConfigurationProperties properties;
    private final TypeSerializer<T, ?> serializer;
    private final CommentNodeExtractor extractor;

    public YamlConfigurationStore(Class<T> configurationType, YamlConfigurationProperties properties) {
        Validator.requireNonNull(configurationType, "configuration type");
        this.properties = Validator.requireNonNull(properties, "properties");
        this.serializer = TypeSerializer.newSerializerFor(configurationType, properties);
        this.extractor = new CommentNodeExtractor(properties);
    }

    @Override
    public void write(T configuration, OutputStream outputStream) {
        Validator.requireNonNull(configuration, "configuration");
        Validator.requireNonNull(outputStream, "output stream");
        Queue<CommentNode> extractedCommentNodes = this.extractor.extractCommentNodes(configuration);
        YamlWriter yamlFileWriter = new YamlWriter(outputStream, this.properties);
        String dumpedYaml = this.tryDump(configuration);
        yamlFileWriter.writeYaml(dumpedYaml, extractedCommentNodes);
    }

    @Override
    public void save(T configuration, Path configurationFile) {
        Validator.requireNonNull(configuration, "configuration");
        Validator.requireNonNull(configurationFile, "configuration file");
        this.tryCreateParentDirectories(configurationFile);
        Queue<CommentNode> extractedCommentNodes = this.extractor.extractCommentNodes(configuration);
        YamlWriter yamlFileWriter = new YamlWriter(configurationFile, this.properties);
        String dumpedYaml = this.tryDump(configuration);
        yamlFileWriter.writeYaml(dumpedYaml, extractedCommentNodes);
    }

    private void tryCreateParentDirectories(Path configurationFile) {
        Path parent = configurationFile.getParent();
        if (!Files.exists(parent, new LinkOption[0]) && this.properties.createParentDirectories()) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String tryDump(T configuration) {
        Object serializedConfiguration = this.serializer.serialize((Object)configuration);
        try {
            return YAML_DUMPER.dumpToString(serializedConfiguration);
        }
        catch (YamlEngineException e) {
            String msg = "The given configuration could not be converted into YAML. \nDo all custom serializers produce valid target types?";
            throw new ConfigurationException(msg, e);
        }
    }

    @Override
    public T read(InputStream inputStream) {
        Validator.requireNonNull(inputStream, "input stream");
        try {
            Object yaml = YAML_LOADER.loadFromInputStream(inputStream);
            Map<?, ?> conf = this.requireYamlMapForRead(yaml);
            return (T)this.serializer.deserialize(conf);
        }
        catch (YamlEngineException e) {
            String msg = "The input stream does not contain valid YAML.";
            throw new ConfigurationException(msg, e);
        }
    }

    private Map<?, ?> requireYamlMapForRead(Object yaml) {
        if (yaml == null) {
            String msg = "The input stream is empty or only contains null.";
            throw new ConfigurationException(msg);
        }
        if (!(yaml instanceof Map)) {
            String msg = "The contents of the input stream do not represent a configuration. A valid configuration contains a YAML map but instead a '" + yaml.getClass() + "' was found.";
            throw new ConfigurationException(msg);
        }
        Map map = (Map)yaml;
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T load(Path configurationFile) {
        Validator.requireNonNull(configurationFile, "configuration file");
        try (BufferedReader reader = Files.newBufferedReader(configurationFile, this.properties.getCharset());){
            Object yaml2 = YAML_LOADER.loadFromReader(reader);
            Map<?, ?> conf = this.requireYamlMapForLoad(yaml2, configurationFile);
            Object T1 = this.serializer.deserialize(conf);
            return (T)T1;
        }
        catch (YamlEngineException e) {
            String msg = "The configuration file at %s does not contain valid YAML.";
            throw new ConfigurationException(msg.formatted(configurationFile), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<?, ?> requireYamlMapForLoad(Object yaml, Path configurationFile) {
        if (yaml == null) {
            String msg = "The configuration file at %s is empty or only contains null.";
            throw new ConfigurationException(msg.formatted(configurationFile));
        }
        if (!(yaml instanceof Map)) {
            String msg = "The contents of the YAML file at %s do not represent a configuration. A valid configuration file contains a YAML map but instead a '" + yaml.getClass() + "' was found.";
            throw new ConfigurationException(msg.formatted(configurationFile));
        }
        Map map = (Map)yaml;
        return map;
    }

    @Override
    public T update(Path configurationFile) {
        Validator.requireNonNull(configurationFile, "configuration file");
        if (Files.exists(configurationFile, new LinkOption[0])) {
            T configuration = this.load(configurationFile);
            this.save(configuration, configurationFile);
            return configuration;
        }
        T defaultConfiguration = this.serializer.newDefaultInstance();
        this.save(defaultConfiguration, configurationFile);
        return defaultConfiguration;
    }

    static Dump newYamlDumper() {
        DumpSettings settings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).setIndent(2).build();
        return new Dump(settings, new YamlConfigurationRepresenter(settings));
    }

    static Load newYamlLoader() {
        LoadSettings settings = LoadSettings.builder().build();
        return new Load(settings);
    }

    static final class YamlConfigurationRepresenter
    extends StandardRepresenter {
        public YamlConfigurationRepresenter(DumpSettings settings) {
            super(settings);
        }

        @Override
        protected Node representSequence(Tag tag, Iterable<?> sequence, FlowStyle flowStyle) {
            Node node = super.representSequence(tag, sequence, flowStyle);
            this.representedObjects.clear();
            return node;
        }

        @Override
        protected Node representMapping(Tag tag, Map<?, ?> mapping, FlowStyle flowStyle) {
            Node node = super.representMapping(tag, mapping, flowStyle);
            this.representedObjects.clear();
            return node;
        }
    }
}

