/*
 * Decompiled with CFR 0.152.
 */
package net.libz.network;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.ConfigManager;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.SyntaxError;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.libz.access.MouseAccessor;
import net.libz.api.ConfigSync;
import net.libz.mixin.config.AutoConfigAccess;
import net.libz.network.LibzServerPacket;
import net.libz.util.ConfigHelper;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class LibzClientPacket {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)LibzServerPacket.SET_MOUSE_POSITION, (client, handler, buf, sender) -> {
            int mouseX = buf.readInt();
            int mouseY = buf.readInt();
            client.execute(() -> ((MouseAccessor)client.field_1729).setMousePosition(mouseX, mouseY));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)LibzServerPacket.SYNC_CONFIG_PACKET, (client, handler, buf, sender) -> {
            String configName = buf.method_19772();
            boolean gson = buf.readBoolean();
            ObjectMapper objectMapper = new ObjectMapper();
            byte[] jsonBytes = new byte[buf.readableBytes()];
            buf.readBytes(jsonBytes);
            client.execute(() -> {
                JsonNode oldJsonNode = ConfigHelper.getConfigNode(configName, gson, false);
                JsonNode jsonNode = ConfigHelper.readJsonTree(objectMapper, jsonBytes);
                if (oldJsonNode.isObject() && jsonNode.isObject()) {
                    ObjectNode existingObjectNode = (ObjectNode)oldJsonNode;
                    ObjectNode newObjectNode = (ObjectNode)jsonNode;
                    newObjectNode.fields().forEachRemaining(entry -> {
                        String fieldName = (String)entry.getKey();
                        JsonNode newValue = (JsonNode)entry.getValue();
                        existingObjectNode.set(fieldName, newValue);
                    });
                    Jankson jankson = Jankson.builder().build();
                    for (ConfigHolder<?> holder : AutoConfigAccess.getHolders().values()) {
                        if (!((ConfigManager)holder).getDefinition().name().equals(configName)) continue;
                        try {
                            ConfigData data = (ConfigData)jankson.fromJson(jankson.load(existingObjectNode.toString()), holder.getConfigClass());
                            ((ConfigManager)holder).setConfig(data);
                            if (!(holder.getConfig() instanceof ConfigSync)) break;
                            ((ConfigSync)holder.getConfig()).updateConfig(data);
                        }
                        catch (SyntaxError e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            });
        });
    }
}

