/*
 * Decompiled with CFR 0.152.
 */
package elocindev.combat_effects.mixin;

import elocindev.combat_effects.CombatEffects;
import elocindev.combat_effects.api.DataHolders;
import elocindev.combat_effects.config.entries.MainConfig;
import elocindev.necronomicon.api.NecUtilsAPI;
import elocindev.necronomicon.api.ResourceIdentifier;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Inject(method={"damage"}, at={@At(value="TAIL")})
    public void damage(class_1282 damageSource, float amount, CallbackInfoReturnable<Boolean> ci) {
        class_1309 entity = (class_1309)this;
        if (damageSource.method_5529() != null && damageSource.method_5529() instanceof class_1309) {
            class_1309 attacker = (class_1309)damageSource.method_5529();
            if (entity instanceof class_3222) {
                class_1657 player = (class_1657)entity;
                this.processEffects(attacker, player, true);
            } else if (entity instanceof class_1309 && damageSource.method_5529() instanceof class_1657) {
                class_1657 player = (class_1657)damageSource.method_5529();
                class_1309 livingEntity = entity;
                this.processEffects(livingEntity, player, false);
            }
        }
    }

    private void processEffects(class_1309 entity, class_1657 player, boolean isPlayerTheVictim) {
        for (DataHolders.EntityHolder entityHolder : MainConfig.INSTANCE.entities) {
            if (!this.checkMatch(entity, entityHolder.entity_regex) || !(entity.method_6032() >= (float)entityHolder.minimum_hp)) continue;
            if (!isPlayerTheVictim && entityHolder.only_on_player_hit) {
                return;
            }
            if (entityHolder.apply_to_entity_instead_of_player) {
                this.applyEffects(entity, entityHolder.effects_to_apply);
                continue;
            }
            this.applyEffects((class_1309)player, entityHolder.effects_to_apply);
        }
    }

    private void applyEffects(class_1309 entityToApply, List<DataHolders.EffectHolder> effects) {
        for (DataHolders.EffectHolder effect : effects) {
            class_1291 actualEffect = (class_1291)class_7923.field_41174.method_10223(ResourceIdentifier.get((String)effect.effect_id));
            if (actualEffect == null) {
                CombatEffects.LOGGER.error("Effect with id {} not found!", (Object)effect.effect_id);
                continue;
            }
            class_1293 effectInstance = new class_1293(actualEffect, effect.duration, effect.amplifier, false, effect.show_particles);
            entityToApply.method_6092(effectInstance);
        }
    }

    private boolean checkMatch(class_1309 entity, String regex) {
        return Pattern.matches(regex, NecUtilsAPI.getEntityId((class_1297)entity));
    }
}

