/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.ThermooRegistryKeys;
import com.github.thedeathlycow.thermoo.api.attribute.ItemAttributeModifier;
import com.github.thedeathlycow.thermoo.api.command.EnvironmentCommand;
import com.github.thedeathlycow.thermoo.api.command.HeatingModeArgumentType;
import com.github.thedeathlycow.thermoo.api.command.TemperatureCommand;
import com.github.thedeathlycow.thermoo.api.command.TemperatureUnitArgumentType;
import com.github.thedeathlycow.thermoo.api.season.ThermooSeasonEvents;
import com.github.thedeathlycow.thermoo.api.season.ThermooSeasons;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentManager;
import com.github.thedeathlycow.thermoo.impl.ItemAttributeModifierManager;
import com.github.thedeathlycow.thermoo.impl.TemperatureEffectLoader;
import com.github.thedeathlycow.thermoo.impl.ThermooCommonRegisters;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.Season;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Thermoo
implements ModInitializer {
    public static final String MODID = "thermoo";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"thermoo");

    public void onInitialize() {
        ArgumentTypeRegistry.registerArgumentType((class_2960)Thermoo.id("heating_mode"), HeatingModeArgumentType.class, (class_2314)class_2319.method_41999(HeatingModeArgumentType::heatingMode));
        ArgumentTypeRegistry.registerArgumentType((class_2960)Thermoo.id("temperature_unit"), TemperatureUnitArgumentType.class, (class_2314)class_2319.method_41999(TemperatureUnitArgumentType::temperatureUnit));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register(TemperatureCommand.COMMAND_BUILDER.get());
            dispatcher.register(EnvironmentCommand.COMMAND_BUILDER.get());
        });
        DynamicRegistries.registerSynced(ThermooRegistryKeys.ITEM_ATTRIBUTE_MODIFIER, ItemAttributeModifier.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[]{DynamicRegistries.SyncOption.SKIP_WHEN_EMPTY});
        ItemAttributeModifierManager.INSTANCE.registerToEventsCommon();
        ThermooCommonRegisters.registerAttributes();
        ThermooCommonRegisters.registerTemperatureEffects();
        ResourceManagerHelper serverManager = ResourceManagerHelper.get((class_3264)class_3264.field_14190);
        serverManager.registerReloadListener((IdentifiableResourceReloadListener)TemperatureEffectLoader.INSTANCE);
        Thermoo.registerFabricSeasonsIntegration();
        LOGGER.info("Creating environment manager {}", (Object)EnvironmentManager.INSTANCE);
        LOGGER.info("Thermoo initialized");
    }

    private static void registerFabricSeasonsIntegration() {
        if (FabricLoader.getInstance().isModLoaded("seasons")) {
            LOGGER.warn("Registering builtin Fabric Seasons integration with Thermoo. Note that this integration will be removed as a builtin feature in the future.");
            ThermooSeasonEvents.GET_CURRENT_SEASON.register(world -> {
                Season fabricSeason = FabricSeasons.getCurrentSeason((class_1937)world);
                return Optional.ofNullable(switch (fabricSeason) {
                    case Season.WINTER -> ThermooSeasons.WINTER;
                    case Season.SUMMER -> ThermooSeasons.SUMMER;
                    case Season.FALL -> ThermooSeasons.AUTUMN;
                    case Season.SPRING -> ThermooSeasons.SPRING;
                    default -> null;
                });
            });
        }
    }

    @Contract(value="->new")
    public static class_2960 id(String path) {
        return new class_2960(MODID, path);
    }
}

