/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.ThermooRegistryKeys;
import com.github.thedeathlycow.thermoo.api.attribute.ItemAttributeModifier;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.google.common.collect.Multimap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;

public class ItemAttributeModifierManager
implements ModifyItemAttributeModifiersCallback {
    public static final ItemAttributeModifierManager INSTANCE = new ItemAttributeModifierManager();
    @Nullable
    private class_5455 manager;

    public void registerToEventsCommon() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.manager = server.method_30611();
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (this.manager == null) {
                Thermoo.LOGGER.warn("Unable to get dynamic registry manager for Thermoo Item Attribute Modifiers.");
                return;
            }
            class_2378 registry = this.manager.method_30530(ThermooRegistryKeys.ITEM_ATTRIBUTE_MODIFIER);
            Thermoo.LOGGER.info("Loaded {} items attribute modifier(s)", (Object)(registry != null ? registry.method_10204() : 0));
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            this.manager = null;
        });
        ModifyItemAttributeModifiersCallback.EVENT.register((Object)this);
    }

    public void registerToEventsClient() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (this.manager == null) {
                this.manager = handler.method_29091();
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            this.manager = null;
        });
    }

    public void modifyAttributeModifiers(class_1799 stack, class_1304 slot, Multimap<class_1320, class_1322> attributeModifiers) {
        if (this.manager != null) {
            this.manager.method_33310(ThermooRegistryKeys.ITEM_ATTRIBUTE_MODIFIER).ifPresent(registry -> registry.method_40270().forEach(entry -> ((ItemAttributeModifier)entry.comp_349()).apply(stack, slot, attributeModifiers)));
        }
    }

    private ItemAttributeModifierManager() {
    }
}

