/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.temperature.effects;

import com.github.thedeathlycow.thermoo.api.temperature.effects.TemperatureEffect;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class ScalingAttributeModifierTemperatureEffect
extends TemperatureEffect<Config> {
    @Override
    public void apply(class_1309 victim, class_3218 serverWorld, Config config) {
        class_1324 attrInstance = victim.method_5996(config.attribute);
        if (attrInstance == null) {
            return;
        }
        double amount = config.scale * victim.thermoo$getTemperatureScale();
        attrInstance.method_26835(new class_1322(config.uuid, config.name, amount, config.operation));
    }

    @Override
    public boolean shouldApply(class_1309 victim, Config config) {
        double currentValue;
        boolean shouldApply;
        class_1324 attrInstance = victim.method_5996(config.attribute);
        if (attrInstance == null) {
            return false;
        }
        class_1322 modifier = attrInstance.method_6199(config.uuid);
        if (modifier == null) {
            return true;
        }
        double newAmount = config.scale * victim.thermoo$getTemperatureScale();
        boolean bl = shouldApply = newAmount != (currentValue = modifier.method_6186());
        if (shouldApply) {
            attrInstance.method_6200(config.uuid);
        }
        return shouldApply;
    }

    @Override
    public Config configFromJson(JsonElement json, JsonDeserializationContext context) throws JsonSyntaxException {
        return Config.fromJson(json);
    }

    public record Config(float scale, class_1320 attribute, UUID uuid, String name, class_1322.class_1323 operation) {
        public static Config fromJson(JsonElement jsonElement) throws JsonSyntaxException {
            float scale = 1.0f;
            String name = "";
            JsonObject json = jsonElement.getAsJsonObject();
            if (json.has("scale")) {
                scale = json.get("scale").getAsFloat();
            }
            if (json.has("name")) {
                name = json.get("name").getAsString();
            }
            UUID id = UUID.fromString(json.get("modifier_uuid").getAsString());
            class_2960 attrID = new class_2960(json.get("attribute_type").getAsString());
            class_1320 attribute = (class_1320)class_7923.field_41190.method_10223(attrID);
            if (attribute == null) {
                throw new JsonParseException("Unknown attribute: " + attrID);
            }
            class_1322.class_1323 operation = class_1322.class_1323.valueOf((String)json.get("operation").getAsString().toUpperCase());
            return new Config(scale, attribute, id, name, operation);
        }
    }
}

