/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.temperature.effects;

import com.github.thedeathlycow.thermoo.api.temperature.effects.TemperatureEffect;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;

public class DamageTemperatureEffect
extends TemperatureEffect<Config> {
    @Nullable
    private class_2378<class_8110> registry;
    private final Map<class_5321<class_8110>, class_1282> damageSourcePool = new HashMap<class_5321<class_8110>, class_1282>();

    public DamageTemperatureEffect() {
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.invalidateRegistryCache());
    }

    @Override
    public void apply(class_1309 victim, class_3218 serverWorld, Config config) {
        class_1282 source;
        if (this.registry == null) {
            class_5455.class_6890 registryManager = serverWorld.method_8503().method_30611();
            this.registry = registryManager.method_30530(class_7924.field_42534);
        }
        if ((source = this.getDamageSourceFromType(config.damageType, this.registry)) != null) {
            victim.method_5643(source, config.amount);
        }
    }

    @Override
    public boolean shouldApply(class_1309 victim, Config config) {
        return victim.field_6012 % config.damageInterval == 0 && config.amount != 0.0f;
    }

    @Override
    public Config configFromJson(JsonElement json, JsonDeserializationContext context) throws JsonSyntaxException {
        return Config.fromJson(json, context);
    }

    @Nullable
    private class_1282 getDamageSourceFromType(class_5321<class_8110> damageType, class_2378<class_8110> registry) {
        if (this.damageSourcePool.containsKey(damageType)) {
            return this.damageSourcePool.get(damageType);
        }
        if (registry.method_35842(damageType)) {
            class_1282 source = new class_1282((class_6880)registry.method_40290(damageType));
            this.damageSourcePool.put(damageType, source);
            return source;
        }
        Thermoo.LOGGER.warn("Trying to use unknown damage type {}", damageType);
        return null;
    }

    private void invalidateRegistryCache() {
        this.registry = null;
        this.damageSourcePool.clear();
        Thermoo.LOGGER.info("Invalidated damage temperature effect registry cache");
    }

    public record Config(float amount, int damageInterval, class_5321<class_8110> damageType) {
        public static Config fromJson(JsonElement json, JsonDeserializationContext context) throws JsonSyntaxException {
            JsonObject object = json.getAsJsonObject();
            float amount = object.get("amount").getAsFloat();
            int damageInterval = object.get("damage_interval").getAsInt();
            class_2960 damageTypeID = new class_2960(object.get("damage_type").getAsString());
            class_5321 damageType = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)damageTypeID);
            return new Config(amount, damageInterval, (class_5321<class_8110>)damageType);
        }
    }
}

