/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.command;

import com.github.thedeathlycow.thermoo.api.command.TemperatureUnitArgumentType;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentManager;
import com.github.thedeathlycow.thermoo.api.util.TemperatureConverter;
import com.github.thedeathlycow.thermoo.api.util.TemperatureUnit;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Contract;

public class EnvironmentCommand {
    public static final Supplier<LiteralArgumentBuilder<class_2168>> COMMAND_BUILDER = EnvironmentCommand::buildCommand;

    @Contract(value="->new")
    private static LiteralArgumentBuilder<class_2168> buildCommand() {
        LiteralArgumentBuilder printController = (LiteralArgumentBuilder)class_2170.method_9247((String)"printcontroller").executes(context -> EnvironmentCommand.printController((class_2168)context.getSource()));
        LiteralArgumentBuilder checkTemperature = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"checktemperature").executes(context -> {
            class_243 pos = ((class_2168)context.getSource()).method_9222();
            return EnvironmentCommand.executeCheckTemperature((class_2168)context.getSource(), new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350));
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(context -> EnvironmentCommand.executeCheckTemperature((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target").method_24515()))).then(class_2170.method_9244((String)"unit", (ArgumentType)TemperatureUnitArgumentType.temperatureUnit()).executes(context -> EnvironmentCommand.executeCheckTemperature((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target").method_24515(), TemperatureUnitArgumentType.getTemperatureUnit((CommandContext<class_2168>)context, "unit")))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"location", (ArgumentType)class_2262.method_9698()).executes(context -> EnvironmentCommand.executeCheckTemperature((class_2168)context.getSource(), class_2262.method_9696((CommandContext)context, (String)"location")))).then(class_2170.method_9244((String)"unit", (ArgumentType)TemperatureUnitArgumentType.temperatureUnit()).executes(context -> EnvironmentCommand.executeCheckTemperature((class_2168)context.getSource(), class_2262.method_9696((CommandContext)context, (String)"location"), TemperatureUnitArgumentType.getTemperatureUnit((CommandContext<class_2168>)context, "unit")))));
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"thermoo").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"environment").requires(src -> src.method_9259(2))).then((ArgumentBuilder)checkTemperature)).then((ArgumentBuilder)printController));
    }

    private static int printController(class_2168 source) {
        String controller = EnvironmentManager.INSTANCE.getController().toString();
        source.method_9226(() -> class_2561.method_48321((String)"commands.thermoo.environment.printcontroller.success", (String)"Controller logged to console"), false);
        Thermoo.LOGGER.info("The current controller is: {}", (Object)controller);
        return 0;
    }

    private static int executeCheckTemperature(class_2168 source, class_2338 location) {
        int temperatureChange = EnvironmentManager.INSTANCE.getController().getLocalTemperatureChange((class_1937)source.method_9225(), location);
        class_5321 biome = source.method_9225().method_23753(location).method_40230().orElse(null);
        source.method_9226(() -> class_2561.method_48322((String)"commands.thermoo.environment.checktemperature.success", (String)"The passive temperature change at %s, %s, %s (%s) is %s", (Object[])new Object[]{location.method_10263(), location.method_10264(), location.method_10260(), biome == null ? "unknown" : biome.method_29177(), temperatureChange}), false);
        return temperatureChange;
    }

    private static int executeCheckTemperature(class_2168 source, class_2338 location, TemperatureUnit unit) {
        int temperatureTick = EnvironmentManager.INSTANCE.getController().getLocalTemperatureChange((class_1937)source.method_9225(), location);
        class_5321 biome = source.method_9225().method_23753(location).method_40230().orElse(null);
        double temperature = TemperatureConverter.temperatureTickToAmbientTemperature(temperatureTick, new TemperatureConverter.Settings(unit, 1.0, 0.0));
        source.method_9226(() -> class_2561.method_48322((String)"commands.thermoo.environment.checktemperature.unit.success", (String)"The temperature at %s, %s, %s (%s) is %s\u00b0%s", (Object[])new Object[]{location.method_10263(), location.method_10264(), location.method_10260(), biome == null ? "unknown" : biome.method_29177(), String.format("%.2f", temperature), unit.getUnitSymbol()}), false);
        return (int)temperature;
    }
}

